#include <stdio.h>
#include "sym.h"
#include "assem.h"
#include "scanner.h"
 
/*
 * const - scan a constant
 *	return an expression with
 *		type - type of symbol associated with adcon
 *		val  - multiplication factor
 *		len  - length of constant
 *		symp - symbol table pointer for adcon
 *	valp - bytes of constant
 */
 
dc1(ep, valp)
register EXPR *ep;
char *valp;{

	register int s, t;
	register TOKEN *tp;
	int r, mult;
	char *p;
	EXPR e1;

	tp = &curtoke;
	mult = getmult(tp);
	switch(tp->t_state) {
		case FQ:
		case HQ:
			s = tp->t_val;
			scan1(tp, 1);
			r = 1;
			while (tp->t_state == '-' || tp->t_state == '+') {
				if (tp->t_state == '-') r = -r;
				scan1(tp, 1);
				}
			if (tp->t_state != ABS && tp->t_state != DIG)
				error(0, "Constant not numeric");
			ep->e_type = ABSOLUTE;
			ep->e_len = s;
			if (r == -1) tp->t_val = -tp->t_val;
			if (s <= BPW) *(int *)valp = tp->t_val;
			else move((char *)&(tp->t_val), valp+s-BPW, BPW);
			ep->e_symp = NULL;
			ep->e_val = mult;
			scan1(tp, 1);
			if (tp->t_state != SQS)
				error(0, "Missing single quote");
			scan1(tp, 1);
			break;
		case BIN:
		case HEX:
		case CHAR:
			ep->e_type = tp->t_state-BIN+BABS;
			ep->e_val = mult;
			ep->e_len = tp->t_val;
			ep->e_symp = NULL;
			move(tp->t_name, valp, ep->e_len);
			scan1(tp, 1);
			break;
		case ID:
			deletesym(tp->t_name);
			r = tp->t_name[0];
			if (r == 'a' || r == 'v') t = BPW;
			else if (r == 'y' || r == 's') t = BPH;
			else error(0, "Unknown specification: %s", tp->t_name);
			s = tp->t_name[1];
			if (s == 'l') {
				s = 0;
				p = &(tp->t_name[2]);
				for (; *p >= '0' && *p <= '9'; p++)
					s = 10*s+(*p-'0');
				t = s;
				s = *p;
				}
			if (s != '\0')
				error(0, "Bad specification: %s", tp->t_name);
			putc(r, txtfil);
			putc(t, txtfil);
			if (r == 'a' || r == 'y' || r == 'v') {
				scan1(tp, 1);
				expres(ep);
				*(int *)valp = ep->e_val;
				*(struct symtab **)(valp+BPW) = ep->e_symp;
				ep->e_len = t;
				if (r == 'v' && ep->e_symp)
					(ep->e_symp)->s_type |= EXTERN;
				}
			else {
				scan1(tp, 1);
				if (tp->t_state != '(')
					error(0, "Missing left paren");
				scan1(tp, 1);
				if ((r = expres(ep)) == '(') {
					r = expres(&e1);
					ep->e_val += e1.e_val << 12;
					}
				ep->e_type = ABSOLUTE;
				ep->e_len = BPH;
				*(int *)valp = ep->e_val;
				if (r != ')')
					error(0, "Missing right paren");
				}
			ep->e_val = mult;
			break;
		default:
			error(0, "Unknown constant");
		}
	}

/*
 * dc for pass 2 - a little less error checking
 */

dc2(ep, valp)
register EXPR *ep;
char *valp;{

	register int s, t;
	register TOKEN *tp;
	int r, mult;
	EXPR e1;

	tp = &curtoke;
	mult = getmult(tp);
	switch(tp->t_state) {
		case FQ:
		case HQ:
			s = tp->t_val;
			scan2(tp, 1);
			r = 1;
			while (tp->t_state == '-' || tp->t_state == '+') {
				if (tp->t_state == '-') r = -r;
				scan2(tp, 1);
				}
			ep->e_type = ABSOLUTE;
			ep->e_len = s;
			if (r == -1) tp->t_val = -tp->t_val;
			if (s <= BPW) *(int *)valp = tp->t_val;
			else move((char *)&(tp->t_val), valp+s-BPW, BPW);
			ep->e_symp = NULL;
			ep->e_val = mult;
			scan2(tp, 1);
			scan2(tp, 1);
			break;
		case BIN:
		case HEX:
		case CHAR:
			ep->e_type = tp->t_state-BIN+BABS;
			ep->e_val = mult;
			ep->e_len = tp->t_val;
			ep->e_symp = NULL;
			move(tp->t_name, valp, ep->e_len);
			scan2(tp, 1);
			break;
		case ID:
			r = getc(txtfil);
			t = getc(txtfil);
			if (r == 'a' || r == 'y' || r == 'v') {
				scan2(tp, 1);
				expres(ep);
				*(int *)valp = ep->e_val;
				*(struct symtab **)(valp+BPW) = ep->e_symp;
				ep->e_len = t;
				}
			else {
				scan2(tp, 1);
				scan2(tp, 1);
				if (expres(ep) == '(') {
					expres(&e1);
					ep->e_val += e1.e_val << 12;
					}
				else {
					getbase(&(ep->e_val), &(e1.e_val), ep->e_type);
					ep->e_val += (e1.e_val << 12);
					}
				ep->e_type = ABSOLUTE;
				ep->e_len = BPH;
				*(int *)valp = ep->e_val;
				}
			ep->e_val = mult;
			break;
		}
	}

/*
 * scan a ds statement
 */

ds1(ep)
register EXPR *ep;{

	register TOKEN *tp;
	register char *p;

	tp = &curtoke;
	ep->e_val = getmult(tp);
	if (tp->t_state != ID) error(0, "Unknown specification");
	p = tp->t_name;
	deletesym(p);
	ep->e_len = dslen(*p);
	if (*++p == 'l') {
		ep->e_len = 0;
		for (++p; *p >= '0' && *p <= '9'; p++)
			ep->e_len = 10*ep->e_len+(*p-'0');
		}
	if (*p != '\0') error(0, "Bad specification: %s", tp->t_name);
	putc(ep->e_len, txtfil);
	}

ds2(ep)
register EXPR *ep;{

	ep->e_val = getmult(&curtoke);
	ep->e_len = getc(txtfil);
	}

/*
 * dslen - length of define
 */

dslen(c)
register int c;{

	switch(c) {
		case 'f':
		case 'a':
		case 'v':
		case 'l':
			return(BPW);
		case 'd':
			return(BPD);
		case 'h':
		case 'y':
		case 's':
			return(BPH);
		case 'b':
		case 'x':
		case 'c':
			return(1);
		default:
			error(0, "Unknown specification: %c", c);
		}
		/*NOTREACHED*/
	}

/*
 * getmult - get multiplication factor
 */

getmult(tp)
register TOKEN *tp;{

	register int r, s;
	EXPR e;

	r = 1;
	s = tp->t_state;
	if (s == ABS || s == DIG) {
		r = tp->t_val;
		(*scan)(tp, 1);
		}
	else if (s == '(') {
		expres(&e);
		r = e.e_val;
		if (e.e_symp && scan == scan1) r += (e.e_symp)->s_val;
		if ((e.e_type&LOCAL) != ABSOLUTE)
			error(-1, "Expression not absolute");
		}
	return(r);
	}
