/ zero.s 5/8/79
zero:
resnpsw: ds	0d
ipsw:    dc     x'000c0000',a(main)
resopsw: ds	0d
iccw1:   ds     d
iccw2:   ds     d
extopsw: ds	d
svcopsw: ds	d
pgmopsw: ds	d
mckopsw: ds	d
ioopsw:  ds     d
csw:     ds     d
caw:     ds     f
         ds     f
timer:   dc     f'-1'
         ds     f
extnpsw: ds	0d
         dc     x'000c0000',a(exttrap)
svcnpsw: ds	0d
         dc     x'000c0000',a(svctrap)
pgmnpsw: ds	0d
         dc     x'000c0000',a(pgmtrap)
mcknpsw: ds     0d
         dc     x'00080000',a(mcktrap)
ionpsw:  ds     0d
         dc     x'000c0000',a(iotrap)
         ds     f
         ds     h       / "processor address"
extcode: ds	h
svccode: ds	f
pgmcode: ds	f	/ program interrupt code in low order byte
tranexcp: ds	f	/ translation exection addres
monclass: ds	h	/ monitor class number
percode: ds	h
peraddr: ds	f
moncode: ds	f
         ds     2f
chanlid: ds     f
ioel:    ds     f
         ds     f       / limited channel logout
         ds     f
ioaddr:  ds     f       / i/o address

/ these next two are set by ipl program before we get control
. = zero + 192
         entry  ipladdr, sysname
ipladdr: ds     f       / ipl device address
sysname: ds     cl20    / unix name

/ save areas for machine checks
timersa: ds     d
clocksa: ds     d
mcic:   ds      d       / interrupt code
        ds      d
fsa:    ds      f       / failing storage address
regcode: ds     f       / region code
mcfla:  ds      12d     / fixed logout area
fprsa:  ds      4d      / floating reg save area
gprsa:  ds      16f     / general reg save area
crsa:   ds      16f     / control reg save area
/ extended logout starts here (not used on Amdahl machines)

/ end of fixed area

. = zero+512
/
	entry	u
u:	ds	f	/ pointer to u area of currently running process
	entry	runrun
runrun:	ds	f

ustack:	ds	f	/ temporary for user stack pointer
temp15: ds      f       / temporary for r15


usize = 1
pgsize = 4096
stkdrop = 104
probstat = x'01'
nowait = x'fd'
/
	using	zero,0
/ these routines resides in low core, and therefore need no base registers
exttrap:
        mvc     resopsw(8),extopsw
        st      r15,temp15
        l       r15,=v(extrn)
        b       trap
svctrap:
        mvc     resopsw(8),svcopsw
        st      r15,temp15
        l       r15,=v(svc)
        b       trap
pgmtrap:
        mvc     resopsw(8),pgmopsw
        st      r15,temp15
        l       r15,=v(pgm)
        b       trap
iotrap:
        mvc     resopsw(8),ioopsw
        st      r15,temp15
        l       r15,=v(iointr)
        b       trap
mcktrap:
        mvc     resopsw(8),mckopsw
        st      r15,temp15
        l       r15,=v(mck)
        b       trap
/ common trap code
trap:
        st      sp,ustack       / save user sp
        tm      resopsw+1,probstat      / user or system?
        bz      1f              / system
        l       sp,u            / user
        la      sp,usize*pgsize-stkdrop(,sp)
        b       2f
1:      s       sp,=a(stkdrop)
2:      stm     r0,r14,0(sp)    / save gprs
        l       r0,ustack
        st      r0,sp*4(,sp)
        l       r0,temp15
        st      r0,r15*4(,sp)
        mvc     64(8,sp),resopsw        / save psw
        std     r0,72(,sp)      / save fprs
        std     r2,80(,sp)
        std     r4,88(,sp)
        std     r6,96(,sp)
/ call C routine
        sr      r12,r12         / must be here for fixstak
        balr    r14,r15
        tm      64+1(sp),probstat       /back to system?
        bz      5f      / yes, skip scheduling
3:      l       r0,runrun       / reschedule?
        ltr     r0,r0
        bz      4f              / no, skip uswtch
        l       r15,=v(uswtch)
        balr    r14,r15
        b       3b
4:      l       r1,u    / load user controlled control regs
/       lctl    r8,r11,0(r1)    / not used for now
5:      mvc     resopsw(8),64(sp)       / put psw where we can find it
        ni      resopsw+1,nowait        / turn off wait state
        ld      r0,72(,sp)              / restore fprs
        ld      r2,80(,sp)
        ld      r4,88(,sp)
        ld      r6,96(,sp)
        lm      r0,r15,0(sp)            / restore gprs
        lpsw    resopsw                 / fly away home

        entry   stnsm,stosm,setsm,savu,retu
	entry	idle,fubyte,fuibyte,fuword,fuiword
	entry	subyte,suibyte,suword,suiword,copyin
	entry	copyout,icode
/
main:
	l	r2,=v(edata)	/ get bss start addr
	lr	r3,r2	/ dup
	s	r3,=v(end)	/ get neg length of bss
	lpr	r3,r3	/ absolute value
	sr	r4,r4	/ no second op
	sr	r5,r5
	mvcl	r2,r4	/ zero bss segment
	mvc	adpswsav(4),pgmnpsw+4	/ save new pgm psw lower half
	la	r1,addrint	/ get addr of interrupt entry
	st	r1,pgmnpsw+4	/ set addr intr entry
	l	r1,=v(end)	/ get addr of kernel end
	la	r1,4095(,r1)	/ round up to
	n	r1,=x'fffff000'	/ page boundary
	l	r8,=v(ffpage)	/ get first free page ptr addr
	st	r1,0(,r8)	/ store addr of first free page
	lr	r7,r1	/ save ffpage ptr
	sr	r4,r4	/ zero count of pages
1:	lr	r2,r1	/ dup r1
	a	r2,=f'4096'	/ bump r2 to next page
	l	r3,0(,r2)	/ attempt addr exception
	st	r2,0(,r1)	/ chain this page
	l	r3,=x'000000f0'
	ssk	r3,r2
	la	r6,2048(,r2)
	ssk	r3,r6
	l	r3,=f'4096'
	sr	r14,r14
	sr	r15,r15
	lr	r1,r2	/ bump chain ptr
	mvcl	r2,r14
	la	r4,1(,r4)	/ increment page count
	b	1b / try next page
addrint: mvc	0(4,r1),=f'0'	/ zero last link in chain
	mvc	pgmnpsw+4(4),adpswsav	/ restore psw
	l	r3,=v(maxmem)	/ get maxmem var addr
	st	r4,0(,r3)	/ store page count
	l	r3,=v(memlim)
	la	r1,4095(,r1)	/ get highest addr
	st	r1,0(,r3)	/ store in memlim
	mvc	0(4,r8),0(r7)	/ delink first page
	st	r7,u	/ use it as u struct ptr
	lr	r2,r7	/ dup u ptr
	l	r3,=f'4096'	/ page length
	sr	r4,r4	/ zero second oper
	sr	r5,r5	/ zero second length
	mvcl	r2,r4	/ fill page with zeroes
	la	r12,usize*pgsize-28(,r7)	/ initialize auto ptr
	lr	sp,r12	/ initialize stack ptr
	l	r15,=v(main370) / get main.c addr
        mvc     resopsw(8),userinit
        b       trap            / enter C routine
userinit: ds    0d
	dc	x'071d0f00'
	dc	f'0'
adpswsav:	ds	f	/ temp
/
stnsm:	/ 1 arg
	ic	r1,0(,sp)	/ get argument
	ex	r1,stnsmi	/ execute the stnsm
	ic	r0,0(sp)	/ get the previous mask
	sll	r0,24	/ shift it into word
	br	r14	/ return
/
stnsmi:	stnsm	0(sp),0 / prototype inst
stosm:	/ 1 arg
	ic	r1,0(,sp)	/ get argument
	ex	r1,stosmi	/ execute the stosm
	ic	r0,0(sp)	/ get the previos mask
	sll	r0,24	/ shift it into word
	br	r14	/ return
stosmi:	stosm	0(sp),0 / prototype inst
/
setsm:	/ 1 arg
	ssm	0(sp)	/ set sysmask to arg
	br	r14	/ return
/
savu:
	l	r1,0(,sp)	/ get save addr
	st	sp,0(,r1)	/ save stack pointer
	st	r12,4(,r1)	/ save r12 too
	br	r14	/ return
/
retu:
        l       r1,0(,sp)       / load save area addr
	l	r12,4(,r1)	/ load saved r12
        l       sp,0(,r1)       / and stack pointer
	br	r14	/ return
/
idle:	/ no args
	lpsw	wait	/ load wait state psw
return:	br	r14	/ return if awakened
wait:	ds	0d
	dc	x'030e0000'
	dc	a(return)
/
fubyte: fuibyte:	/ 1 arg
	l	r1,0(,sp)	/ get user addr
	lra	r1,0(,r1)	/ load real addr
	bnz	1f / branch if not found
	sr	r0,r0	/ zero r0
	ic	r0,0(,r1)	/ insert byte
	br	r14
1:	l	r0,=f'-1'	/ load bad indication
	br	r14	/ return
/
fuword: fuiword:	/ 1 arg
	l	r1,0(,sp)	/ get user addr
	lra	r1,0(,r1)	/ load real addr
	bnz	1f / branch if not found
	l	r0,0(,r1)	/ load word
	br	r14
1:	l	r0,=f'-1'	/ load bad indication
	br	r14	/ return
subyte: suibyte:	/ 2 args
	l	r1,0(,sp)	/ get user virtual addr
	l	r0,4(,sp)	/ get byte to set
	lra	r1,0(,r1)	/ load real addr
	bnz	1f	/ branch if not found
	stc	r0,0(,r1)	/ store the byte
	sr	r0,r0	/ indicate no error
	br	r14
1:	l	r0,=f'-1'	/ indicate error
	br	r14	/ return
suword: suiword:
	l	r1,0(,sp)	/ get user virtual addr
	l	r0,4(,sp)	/ get word to set to
	lra	r1,0(,r1)	/ load real addr
	bnz	1f	/ branch if not found
	st	r0,0(,r1)	/ store word
	sr	r0,r0	/ indicate no error
	br	r14
1:	l	r0,=f'-1'	/ indicate error
	br	r14	/ return
suiword = suword
pgmask = x'fffff000'
/
copyin:	s	sp,=f'20'	/ drop stack
	stm	r2,r6,0(sp)	/ save volatile regs
	l	r1,28(,sp)	/ get length
	l	r2,24(,sp)	/ get system addr
	l	r6,20(,sp)	/ get user addr
1:	ltr	r1,r1	/ any to move?
	bz	4f	/ no, branch
	l	r3,=a(pgsize)	/ page length
	ar	r3,r6	/ add to user addr
	n	r3,=a(pgmask)	/ mask off lower bits
	sr	r3,r6	/ sub addr for len
	cr	r3,r1	/ take minimum of
	bnh	2f	/ r1 and r3 for
	lr	r3,r1	/ length to be moved
2:	lr	r5,r3	/ dup length for mvcl
	lra	r4,0(,r6)	/ get user's real addr
	bnz	3f	/ branch if non-existent
	sr	r1,r3	/ dec len by len being moved
	ar	r6,r3	/ inc user addr by len
	mvcl	r2,r4	/ move	and inc r2 (sys addr)
	b	1b	/ branch back
3:	la	r1,1	/ load error ind
4:	lr	r0,r1	/ load return code
	lm	r2,r6,0(sp)	/ restore regs
	la	sp,20(,sp)	/ pop stack
	br	r14	/ return
/
copyout: s	sp,=f'20'	/ drop stack
	stm	r2,r6,0(sp)	/ save registers
	l	r1,28(,sp)	/ get length to move
	l	r2,20(,sp)	/ get system addr
	l	r6,24(,sp)	/ get user addr
1:	ltr	r1,r1	/ length zero?
	bz	4f / yes, branch
	l	r3,=a(pgsize)	/ page length
	ar	r3,r6	/ add to user addr
	n	r3,=a(pgmask)	/ mask off lower bits
	sr	r3,r6	/ sub addr for length
	cr	r3,r1	/ compare with arg len
	bnh	2f / branch if <= arg len
	lr	r3,r1	/ minimum of r3 & r1
2:	lr	r5,r3	/ dup len for mvcl
	lra	r4,0(,r6)	/ get real user addr
	bnz	3f	/ branch if non-existent
	sr	r1,r3	/ decrement length
	ar	r6,r3	/ increment user addr
	mvcl	r4,r2	/ move and inc sys addr
	b	1b
3:	la	r1,1	/ load error indication
4:	lr	r0,r1	/ load return code
	lm	r2,r6,0(sp)	/ restore regs
	la	sp,20(,sp)	/ pop stack
	br	r14	/ return
/
	entry	bcopy
bcopy:
	l	0,0(,13)
	st	14,0(,13)
	l	14,4(,13)
	l	1,8(,13)
	lr	15,1
	mvcl	14,0
	l	14,0(,13)
	br	14
/
	entry	sthalf
sthalf:
	l	1,0(,13)
	l	0,4(,13)
	sth	0,0(,1)
	br	14
	entry	ldhalf
ldhalf:	l	1,0(,13)
	lh	0,0(,1)
	br	14
/
	entry	min
min:	l	0,0(,13)
	c	0,4(,13)
	blr	14
	l	0,4(,13)
	br	14
/
	entry	max
max:	l	0,0(,13)
	c	0,4(,13)
	bhr	14
	l	0,4(,13)
	br	14
/
	entry	clrbuf
clrbuf:	l	r1,0(,sp)
	l	r1,28(,r1)	/ bp->b_addr
	mvi	0(r1),0
	mvc	1(255,r1),0(r1)
	mvc	256(256,r1),0(r1)
	br	14
/
	entry	clkstrt
clkstrt:
	stck	clk	/ get tod value
	lm	r0,r1,clk
	n	r0,=x'7fffffff'	/ since may 11, 1971
	srdl	r0,12	/ micro seconds
	d	r0,=f'1000000'	/ seconds
	a	r1,=f'42825414' / since jan 1, 1970
	l	r15,=v(time)
	st	r1,0(r15)
	lm	r0,r1,clk
	al	r0,interval
	al	r1,interval+4
	bc	12,1f
	a	r0,=f'1'
1:	stm	r0,r1,clk
	sckc	clk
	br	r14
	ds	0d
interval:	dc	x'00000000f4240000' / 1 second
clk:	ds	d
/
/ return pointer to double word cpu id
        entry   cpuid
cpuid:
        stidp   cpuidx
        la      r0,cpuidx
        br      r14
cpuidx: ds      d
/
/ issue store channel id instruction
        entry   chanid
chanid:
        l       r1,0(,sp)
        stidc   0(r1)
        balr    r0,0
        sll     r0,2
        srl     r0,30
        br      r14
/
/ issue CP command diagnose
        entry   vmdiag8
vmdiag8:
        l       r1,0(,sp)       / buffer
        l       r0,4(,sp)       / length
        diag    r1,r0,x'8'
        br      r14             / return code in r0
/
icode:
	using	icode,0
	la	r1,parmlist-icode
	svc	11	/ exec /etc/init
	svc	1	/ exit if exec failed
parmlist: dc	a(name-icode)
	dc	a(args-icode)
name:	dc	c'/etc/init\0'
args:	dc	a(name-icode)
	dc	a(0)
ltorg
