	double  tmpdbl;
	long    tmplong;
	char    *cp;
%%
[ \t]   {               /* ignore white space */
	}
[1-9][0-9]* {           /* decimal input */
	sscanf(yytext, "%ld", &tmplong);
	yylval = alloci(tmplong);
	return(NUMBER);
	}
0[0-7]* {               /* octal input */
	sscanf(yytext, "%lo", &tmplong);
	yylval = alloci(tmplong);
	return(NUMBER);
	}
0[Xx][0-9a-fA-F]* {     /* hexadecimal input */
	sscanf(yytext+2, "%lx", &tmplong);
	yylval = alloci(tmplong);
	return(NUMBER);
	}
0r[a-zA-Z]* {           /* roman numeral input */
	tmplong = rtoi(yytext+2);
	if (tmplong < 0) {    /* roman number error */
		tmplong = 0;
		printf("  ?\n");
	}
	yylval = alloci(tmplong);
	return(NUMBER);
	}
[0-9]+(\.[0-9]*)?([eE][-+]?[0-9]+) |    /* float input */
[0-9]*\.[0-9]+([eE][-+]?[0-9]+) |
[0-9]+\.[0-9]*([eE][-+]?[0-9]+)? |
[0-9]*\.[0-9]+([eE][-+]?[0-9]+)? {
	sscanf(yytext, "%lf", &tmpdbl);
	yylval = allocf(tmpdbl);
	return(NUMBER);
	}
[a-z]   {                       /* register */
	yylval = *yytext - 'a';
	return(LETTER);
	}
"."     {                       /* accumulator (last output) */
	return(ACC);
	}
;[doxXrR] {                     /* integer output format */
	outconv = yytext[1];
	return(SKIP);
	}
;([1-9][0-9]*)?[efg] { 		/* float output format */
	sscanf(yytext+1, "%d%c", &fprec, &fconv);
	return(SKIP);
	}
;[efg]([1-9][0-9]*)? { 		/* float output format */
	sscanf(yytext+1, "%c%d", &fconv, &fprec);
	return(SKIP);
	}
"\n"    {
	return('\n');
	}
"<<"    {
	return(LSHFT);
	}
">>"    {
	return(RSHFT);
	}
sin     {
	return(SIN);
	}
cos     {
	return(COS);
	}
atan    {
	return(ATAN);
	}
exp     {
	return(EXP);
	}
log     {
	return(LOG);
	}
"**"    {
	return(POW);
	}
.       {                     /* anything else */
	yylval = *yytext;
	return(yylval);
	}
