/*
 * ended: inform user when a process has ended
 *        must be owned by root, with setuid bit on
 *        usage:  ended pid ...
 */

#include <stdio.h>

main(argc, argv)
	int argc;
	char *argv[];
{
	int pid;
	if (--argc == 0) {
		error("usage:  ended pid ...");
		exit(1);
	}
	while (argc--) {
		argv++;
		pid = atoi(*argv);
		if (pid <= 0) {
			error("ended:  invalid process id: %s", *argv);
			continue;
		}
		if (kill(pid, 0) < 0) {
			error("ended:  no such process id: %s", *argv);
			continue;
		}
		if (fork() == 0) {
			while (kill(pid, 0) == 0)
				sleep(10);
			printf("\007Process %s has ended.\n", *argv);
			exit(0);
		}
	}
	exit(0);
}

error(arglist)
int *arglist;
{
	fprintf(stderr, "%r", &arglist);
	fputc('\n', stderr);
}
