/*
 * ed.c - modified for ned.
 */

#include <signal.h>
#include <sgtty.h>
#include <setjmp.h>

#define getline(x) ((char *) (x & ~01))   /* For historical reasons. */
#define ERRLEN  50
#define BSIZE   4096
#define BPOW    12
#define MAXBLK  4095
#define	NULL	0
#define	FNSIZE	64
#define LBSIZE  512
#define	ESIZE	128
#define	GBSIZE	256
#define	NBRA	5
#define EOF     (-1)
#define	KSIZE	9

#define	CBRA	1
#define	CCHR	2
#define	CDOT	4
#define	CCL	6
#define	NCCL	8
#define	CDOL	10
#define	CEOF	11
#define	CKET	12
#define	CBACK	14
#define	STAR	01
#define	READ	0
#define	WRITE	1
int	peekc;
int	lastc;
char	savedfile[FNSIZE];
char	file[FNSIZE];
char    tmpfile[FNSIZE];
char	linebuf[LBSIZE];
char	rhsbuf[LBSIZE/2];
char	expbuf[ESIZE+4];
int	circfl;
int	*zero;
int	*dot;
int	*dol;
int	*addr1;
int	*addr2;
char    genbuf[BSIZE];
int     count;
char	*nextip;
char	*linebp;
int	ninbuf;
int     io = -1;
int     io2 = -1;
int     seek();
int	xflag;
int	xtflag;
int	kflag;
char	key[KSIZE + 1];
char	perm[768];
char	tperm[768];
int	listf;
char	*globp;
int	tline;
char	*loc1;
char	*loc2;
char	*locs;
int	names[26];
int	anymarks;
char	*braslist[NBRA];
char	*braelist[NBRA];
int	nbra;
int	subnewa;
int	subolda;
int	fchange;
int     nlall = 1024;
int	*address();
char	*place();
char	*mktemp();
char	*malloc();
char	*realloc();
jmp_buf savej;

char    *gtp;                   /* getchar pointer */
int     B;                      /* controls reg. expr. special chars */
int     rc;                     /* return code (for mcc) */
extern  int     bell;           /* ring bell flag */
extern  char    errmsg[];       /* error message buffer */
extern  char    *errmsgptr;     /* error message pointer */
extern  int     mode;           /* mode for file creation */
extern  int     amode;
extern  int     cmode;
extern  int     imode;
extern  int     alt;
extern  int     cols;
extern  int     shift;
extern  int     K;
extern  int     N;
extern  int     U;
extern  int     V;
extern  int     roflg;
extern  int     sflg;
extern  int     debug;
extern  int     errno;
#include <sys/types.h>
#include <sys/stat.h>

edcmd(aip)
char    *aip;
{
	register char *ip;
	char    *savegtp;
	char    buf[100];

	if (strlen(aip) > sizeof buf - 3)
		error("Ccommand too long.");
	strcpy(ip = buf, aip);
	if (debug)
		printf("edcmd. ip %s *ip %c/%x\n", ip, *ip, *ip);
	savegtp = gtp;
	gtp = ip;
	while (*ip)
		ip++;
	while (*--ip == ' ' && ip > gtp)
		;
	*++ip = '\n';
	*++ip = '\0';
	commands();
	gtp = savegtp;
	if (debug)
		printf("edcmd - normal return. errmsg %s\n", errmsg);
}

commands()
{
	int getfile();
	register *a1, c;

	for (;;) {
	addr1 = 0;
	addr2 = 0;
	do {
		addr1 = addr2;
		if ((a1 = address())==0) {
			c = gtchar();
			break;
		}
		addr2 = a1;
		if ((c=gtchar()) == ';') {
			c = ',';
			dot = a1;
		}
	} while (c==',');
	if (addr1==0)
		addr1 = addr2;
	if (debug)
		printf("commands. c %c %x\n", c, c);
	switch(c) {

	case '\n':
		if (addr2 != 0)
			dot = addr2;
		if (dot == zero && dot < dol)
			dot++;
		continue;

	case 'a':
		setdot();
		newline();
		dot = addr2;
		amode++;
		continue;

	case 'c':
		delete();
		dot = addr1;
		cmode++;
		continue;

	case 'd':
		delete();
		alt++;
		continue;

	case 'E':
		fchange = 2;
	case 'e':
		setnoaddr();
		if (fchange == 1) {
			fchange = 2;
			error("Unsaved changes.");
		}
		filename(c);
		init();
		alt = 0;
		addr2 = zero;
		goto caseread;

	case 'f':
		setnoaddr();
		filename(c);
		puts(savedfile);
		continue;

	case 'g':
		global(1);
		continue;

	case 'i':
		setdot();
		nonzero();
		newline();
		dot = addr2;
		imode++;
		continue;

	case 'j':
	case 'J':
		if (addr2==0) {
			addr1 = dot;
			addr2 = dot+1;
		}
		setdot();
		newline();
		nonzero();
		join(c);
		alt++;
		fchange = 1;
		continue;

	case 'k':
		if ((c = gtchar()) < 'a' || c > 'z')
			error("Invalid mark character.");
		newline();
		setdot();
		nonzero();
		names[c-'a'] = *addr2 & ~01;
		anymarks |= 01;
		continue;

	case 'l':
		setdot();
		newline();
		dot = addr2;
		listf++;
		continue;

	case 'm':
		move(0);
		alt++;
		continue;

	case 'p':
		setnoaddr();
		pcmd();
		continue;

	case 'Q':
		fchange = 2;
	case 'q':
		setnoaddr();
		newline();
		quit(rc);

	case 'r':
		filename(c);
	caseread:
		if ((io = open(file, 0)) < 0) {
			lastc = '\n';
			if (c == 'r')
				werror("Cannot open \"%s\"", file);
			else
				error("New file.");
		}
		setall();
		ninbuf = 0;
		c = zero != dol;
		addr1 = dot;
		append(getfile, addr2);
		if (dot == zero && dol > zero)
			dot = zero + 1;
		exfile();
		fchange = c;
		alt += c;
		shift = 0;
		continue;

	case 's':
		setdot();
		nonzero();
		substitute(globp!=0);
		alt++;
		fchange = 1;
		continue;

	case 't':
		move(1);
		alt++;
		fchange = 1;
		continue;

	case 'u':
		setdot();
		nonzero();
		newline();
		if ((*addr2&~01) != subnewa)
			error("Cannot undo.");
		*addr2 = subolda;
		dot = addr2;
		alt++;
		continue;

	case 'v':
		global(0);
		continue;

	case 'x':
		if (fchange == 0) {
			while ((c = gtchar()) != '\n' && c != ';')
				;
			continue;
		}

	case 'W':
	case 'w':
		setall();
		nonzero();
		writefile(c);
		continue;

	case '=':
		setall();
		newline();
		putd((addr2-zero)&077777);
		continue;

	case '!':
		shell();
		continue;

	case EOF:
		return;

	case 'A':
		Acmd();
		newline();
		continue;

	case 'B':
		if ((c = gtchar()) == '?')
			if (B)
				puts("Reg. expr. off.");
			else
				puts("Reg. expr. on.");
		else {
			peekc = c;
			B = !B;
		}
		newline();
		continue;

	case 'C':
		cols = !cols;
		newline();
		continue;

	case 'D':
		Dcmd();
		newline();
		continue;

	case 'H':
		Hcmd();
		newline();
		continue;

	case 'F':
		Fcmd();
		continue;

	case 'K':
		if ((c = gtchar()) == '?')
			if (K)
				puts("Memorex.");
			else
				puts("COI.");
		else {
			peekc = c;
			K = !K;
		}
		newline();
		continue;

	case 'L':
		Lcmd();
		newline();
		continue;

	case 'N':
		if ((c = gtchar()) == '?')
			if (N)
				puts("Nonulls.");
			else
				puts("Nulls.");
		else {
			peekc = c;
			N = !N;
		}
		newline();
		continue;

	case 'P':
		Pcmd();
		newline();
		continue;

	case 'R':
		Rcmd();
		newline();
		continue;

	case 'S':
		setdot();
		Scmd(addr1, addr2);
		newline();
		continue;

	case 'T':
		Tcmd();
		newline();
		continue;

	case 'U':
		if ((c = gtchar()) == '?')
			if (U)
				puts("Caps.");
			else
				puts("Asis.");
		else {
			peekc = c;
			U = !U;
		}
		newline();
		continue;

	case 'V':
		if ((c = gtchar()) == '?')
			if (V)
				puts("Verbose.");
			else
				puts("Terse.");
		else {
			peekc = c;
			V = !V;
		}
		newline();
		continue;

	case 'X':
		if ((c = gtchar()) == '?') {
			if (mode & 0111)
				puts("0777");
			else
				puts("0666");
			continue;
		} else
			peekc = c;
		newline();
		if (mode & 0111)
			mode = 0666;
		else
			mode = 0777;
		continue;

	case 'Z':
		Zcmd();
		newline();
		continue;
	}
	error("Unknown command.");
	}
}

mark(c, addr)
char c;
int *addr;
{
	names[c-'a'] = *addr & ~01;
	anymarks |= 01;
}

int *
address()
{
	register *a1, minus, c;
	int n, relerr;

	minus = 0;
	a1 = 0;
	for (;;) {
		c = gtchar();
		if ('0'<=c && c<='9') {
			n = 0;
			do {
				n *= 10;
				n += c - '0';
			} while ((c = gtchar())>='0' && c<='9');
			peekc = c;
			if (a1==0)
				a1 = zero;
			if (minus<0)
				n = -n;
			a1 += n;
			minus = 0;
			continue;
		}
		relerr = 0;
		if (a1 || minus)
			relerr++;
		switch(c) {
		case ' ':
		case '\t':
			continue;

		case '+':
			minus++;
			if (a1==0)
				a1 = dot;
			continue;

		case '-':
			minus--;
			if (a1==0)
				a1 = dot;
			continue;

		case '?':
		case '/':
			compile(c);
			a1 = dot;
			for (;;) {
				if (c=='/') {
					a1++;
					if (a1 > dol) {
						puts("Wraparound.");
						a1 = zero;
					}
				} else {
					a1--;
					if (a1 < zero) {
						puts("Wraparound.");
						a1 = dol;
					}
				}
				if (execute(0, a1))
					break;
				if (a1==dot)
					error("Not found.");
			}
			break;

		case '$':
			a1 = dol;
			break;

		case '.':
			a1 = dot;
			break;

		case '\'':
			if ((c = gtchar()) < 'a' || c > 'z')
				error("Invalid mark character.");
			for (a1=zero; a1<=dol; a1++)
				if (names[c-'a'] == (*a1 & ~01))
					break;
			break;

		default:
			peekc = c;
			if (a1==0)
				return(0);
			a1 += minus;
			if (a1 < zero)
				a1 = zero;
			if (a1 > dol)
				a1 = dol;
			return(a1);
		}
		if (relerr)
			error("Invalid address.");
	}
}

setdot()
{
	if (addr2 == 0)
		addr1 = addr2 = dot;
	if (addr1 > addr2)
		error("Invalid address combination.");
}

setall()
{
	if (addr2==0) {
		addr1 = zero+1;
		addr2 = dol;
		if (dol==zero)
			addr1 = zero;
	}
	setdot();
}

setnoaddr()
{
	if (addr2)
		error("Address(es) not allowed.");
}

nonzero()
{
	if (addr1<=zero || addr2>dol)
		error("Invalid address range.");
}

newline()
{
	register c;

	if ((c = gtchar()) == '\n' || c == ';')
		return;
	if (c=='l') {
		listf++;
		if ((c = gtchar()) == '\n' || c == ';')
			return;
	}
	error("Invalid command format.");
}

filename(comm)
{
	register char *p1, *p2;
	register c;

	count = 0;
	c = gtchar();
	if (c=='\n' || c==';' || c==EOF) {
		p1 = savedfile;
		if (*p1==0 && comm!='f')
			error("No filename.");
		p2 = file;
		while (*p2++ = *p1++)
			;
		return(1);
	}
	if (c!=' ')
		error("Invalid command format.");
	while ((c = gtchar()) == ' ')
		;
	if (c == '\n' || c == ';' || c == EOF)
		error("Invalid command format.");
	p1 = file;
	do {
		if (c == '\\') {     /* allow escaped semicolons */
			c = gtchar();
			if (c != ';') {
				peekc = c;
				c = '\\';
			}
		}
		*p1++ = c;
		if (c==' ')
			error("Invalid command format.");
	} while ((c = gtchar()) != '\n' && c != ';' && c != EOF);
	while (*--p1 == '/')
		;
	*++p1 = 0;
	if (comm == 'f' || comm == 'E' || comm == 'e' || savedfile[0] == '\0')
		strcpy(savedfile, file);
	if (comm == 'f')
		fchange = 1;
	return(0);
}

exfile()
{
	close(io);
	io = -1;
	putd(count);
	ptchar(' ');
}

error(s)
char *s;
{
	if (debug)
		printf("error called. s %s\n", s);
	listf = 0;
	errmsgptr = errmsg;
	if (V)
		puts(s);
	else
		puts("?");
	count = 0;
	lastc = '\0';
	globp = 0;
	peekc = '\0';
	if (io > 0) {
		close(io);
		io = -1;
	}
	if (io2 > 0) {
		close(io2);
		io2 = -1;
	}
	bell = 1;
	if (*tmpfile) {
		unlink(tmpfile);
		*tmpfile = '\0';
	}
	longjmp(savej, 1);
}

gtchar()
{
	if (lastc=peekc) {
		peekc = 0;
		return(lastc);
	}
	if (globp) {
		if ((lastc = *globp++) != 0)
			return(lastc);
		globp = 0;
		return(EOF);
	}
	if (!*gtp)
		return(lastc = EOF);
	lastc = *gtp++ & 0177;
	return(lastc);
}

ungtchar(c)
char    c;
{
	peekc = c;
}

getfile()
{
	register char c;
	register char *lp, *fp;

	lp = linebuf;
	fp = nextip;
	do {
		if (--ninbuf < 0) {
			if ((ninbuf = read(io, genbuf, BSIZE)-1) < 0)
				return(EOF);
			if (kflag) {
				fp = genbuf;
				while(fp < &genbuf[ninbuf]) {
					if (*fp++ & 0200) {
						crblock(perm, genbuf, ninbuf+1, count);
						break;
					}
				}
			}
			fp = genbuf;
		}
		c = *fp++;
		if (c=='\0')
			continue;
		if (lp >= &linebuf[LBSIZE]) {
			lastc = '\n';
			error("Line too long 1.");
		}
		*lp++ = c;
		count++;
	} while (c != '\n');
	*--lp = 0;
	nextip = fp;
	return(0);
}

putfile()
{
	int *a1, n;
	register char *fp, *lp;
	register nib;

	nib = BSIZE;
	fp = genbuf;
	a1 = addr1;
	do {
		lp = getline(*a1++);
		for (;;) {
			if (--nib < 0) {
				n = fp-genbuf;
				if(kflag)
					crblock(perm, genbuf, n, count-n);
				if(write(io, genbuf, n) != n)
					error("Write error.");
				nib = BSIZE - 1;
				fp = genbuf;
			}
			count++;
			if ((*fp++ = *lp++) == 0) {
				fp[-1] = '\n';
				break;
			}
		}
	} while (a1 <= addr2);
	n = fp-genbuf;
	if(kflag)
		crblock(perm, genbuf, n, count-n);
	if(write(io, genbuf, n) != n)
		error("Write error.");
}

append(f, a)
int *a;
int (*f)();
{
	register *a1, *a2, *rdot, *xdot;
	int nline, tl;

	nline = 0;
	xdot = a;
	while ((*f)() == 0) {
		if ((dol-zero)+1 >= nlall) {
			int *ozero = zero;
			nlall += 1024;
			free((char *)zero);
			if ((zero = (int *)realloc((char *)zero, nlall*sizeof(int)))==NULL) {
				lastc = '\n';
				zero = ozero;
				error("Out of memory.");
			}
			dot += zero - ozero;
			xdot += zero - ozero;
			dol += zero - ozero;
			newzero(zero - ozero);
			if (debug)
				printf("new zero. zero %x ozero %x\n", zero, ozero);
		}
		tl = putline(linebuf);
		nline++;
		a1 = ++dol;
		a2 = a1+1;
		rdot = ++xdot;
		while (a1 > rdot)
			*--a2 = *--a1;
		*rdot = tl;
	}
	return(nline);
}

addline(cp, addr)
char    *cp;
int     *addr;
{
	int getsub();
	int *ozero;

	if (setjmp(savej))
		nederr(errmsg);
	linebp = cp;
	ozero = zero;
	append(getsub, addr);
	return(zero - ozero);
}

quit(n)
int n;
{
	extern char autofile[];

	if (fchange == 1 && dol!=zero && n < 2) {
		fchange = 2;
		error("Unsaved changes.");
	}
	if (n < 2)
		unlink(autofile);
	exit(n);
}

/*
 * It may be worthwhile to note that fd 2 has to be a terminal or
 * qsopen would have failed.  This is very handy in this routine.
 */
shell()
{
	register pid, rpid;
	int     retcode;
	char    buf[100];
	char    *bp;
	int     piped[2];
	char    c;

	setall();
	c = gtchar();
	fsclose();
	if (c == '\n') {         /* spawn interactive shell */
		if ((pid = fork()) == 0) {
			signal(SIGINTR, SIG_DFL);
			signal(SIGQUIT, SIG_DFL);
			close(0);
			close(1);
			dup(2);
			dup(2);
			execl("/bin/sh", "sh", 0);
			exit(0);
		}
		while((rpid = wait(&retcode)) != pid && rpid != -1)
			;
		return;
	}
	bp = buf;
	if (c != '<' && c != '>' && c != '|') {
		*bp++ = c;
		c = '!';
	}
	while ((*bp++ = gtchar()) != '\n')
		;
	*bp = '\0';
	if ( c == '>' || c == '|')
		nonzero();
	fsclose();
	write(2, "!", 1);
	write(2, buf, bp - buf);
	if (c == '|' || c == '>') {
		strcpy(tmpfile, "/tmp/nedpipeXXXXXX");
		mktemp(tmpfile);
		io = creat(tmpfile, 0600);
		putfile();
		close(io);
	}
	if (c == '|' || c == '<')
		pipe(piped);
	if ((pid = fork()) == 0) {
		signal(SIGINTR, SIG_DFL);
		switch (c) {              /* io redirection */
		case '<':
			/*
			 * cmd std out = buffer
			 */
			close(1);
			dup(piped[1]);
			close(piped[0]);
			close(piped[1]);
			close(0);
			dup(2);
			break;
		case '>':
			/*
			 * cmd std in = tmpfile
			 * (it would seem that a pipe would suffice here - I tried it and ned just hung)
			 */
			close(0);
			open(tmpfile, 0);
			close(1);
			dup(2);
			break;
		case '|':
			/*
			 * cmd std in = tmpfile, std out = buffer
			 */
			close(0);
			open(tmpfile, 0);
			close(1);
			dup(piped[1]);
			close(piped[0]);
			close(piped[1]);
			break;
		default:
			close(0);
			close(1);
			dup(2);
			dup(2);
			break;
		}
		execl("/bin/sh", "sh", "-c", buf, 0);
		exit(0);
	} else
		switch (c) {
		case '|':
			rdelete(addr1, addr2);
		case '<':
			io = piped[0];
			close(piped[1]);
			append(getfile, (c == '|')? addr1 - 1: addr2);
			close(io);
			alt++;
			fchange = 1;
			if (c == '|' && addr1 == zero + 1 && addr2 == dol)
				dot = zero + 1;  /* cursor at home pos too */
			break;
		}
	io = -1;
	while ((rpid = wait(&retcode)) != pid && rpid != -1)
		;
	write(2,"!\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n",25);
	unlink(tmpfile);
	*tmpfile = '\0';
	count = 0;
}

delete()
{
	setdot();
	newline();
	nonzero();
	rdelete(addr1, addr2);
}

delline(addr, n)
int     *addr;
int     n;
{
	int     *savedot;

	savedot = dot;
	if (addr + n - 1 > dol)
		rdelete(addr, dol);
	else
		rdelete(addr, addr + n - 1);
	dot = savedot;
	alt++;
	fchange = 1;
}

replline(cp, addr)
char    *cp;
int     *addr;
{
  /*    free((char *) *addr);     this is not safe */
	*addr = putline(cp);
}

rdelete(ad1, ad2)
int *ad1, *ad2;
{
	register *a1, *a2, *a3;

	a1 = ad1;
	a2 = ad2+1;
	a3 = dol;
	dol -= a2 - a1;
	do {
	   /*   free((char *) *a1);     this is not safe */
		*a1++ = *a2++;
	} while (a2 <= a3);
	a1 = ad1;
	if (a1 > dol)
		a1 = dol;
	dot = a1;
	fchange = 1;
}

gdelete()
{
	register *a1, *a2, *a3;

	a3 = dol;
	for (a1=zero+1; (*a1&01)==0; a1++)
		if (a1>=a3)
			return;
	for (a2=a1+1; a2<=a3;) {
		if (*a2&01) {
			a2++;
			dot = a1;
		} else
			*a1++ = *a2++;
	}
	dol = a1-1;
	if (dot>dol)
		dot = dol;
	fchange = 1;
}

putline(cp)
char *cp;
{
	int n;
	char *p;

	n = strlen(cp);
	p = malloc(n + 1);
	if (p == NULL)
		nederr("Ned: malloc: out of memory");
	strcpy(p, cp);
	return((int) p);
}

init()
{
	register *markp;

	tline = 2;
	for (markp = names; markp < &names[26]; )
		*markp++ = 0;
	subnewa = 0;
	anymarks = 0;
	if(xflag) {
		xtflag = 1;
		makekey(key, tperm);
	}
	dot = dol = zero;
}

global(k)
{
	register char *gp;
	register c;
	register int *a1;
	int *savedot;
	char globuf[GBSIZE];

	if (globp)
		error("Global recursion.");
	setall();
	nonzero();
	if ((c=gtchar())=='\n')
		error("Invalid command format.");
	compile(c);
	gp = globuf;
	while ((c = gtchar()) != '\n') {
		if (c==EOF)
			error("Invalid command format.");
		if (c=='\\') {
			c = gtchar();
			if (c!='\n')
				*gp++ = '\\';
		}
		*gp++ = c;
		if (gp >= &globuf[GBSIZE-2])
			error("Command too long.");
	}
	*gp++ = '\n';
	*gp++ = 0;
	for (a1=zero; a1<=dol; a1++) {
		*a1 &= ~01;
		if (a1>=addr1 && a1<=addr2 && execute(0, a1)==k)
			*a1 |= 01;
	}
	/*
	 * Special case: g/.../d (avoid n^2 algorithm)
	 */
	savedot = dot;
	if (globuf[0]=='d' && globuf[1]=='\n' && globuf[2]=='\0') {
		gdelete();
		dot = savedot;
		return;
	}
	for (a1=zero; a1<=dol; a1++) {
		if (*a1 & 01) {
			*a1 &= ~01;
			dot = a1;
			globp = globuf;
			commands();
			a1 = zero;
		}
	}
	dot = savedot;
}

join(c)
char c;
{
	register char *gp, *lp;
	register *a1;

	gp = genbuf;
	for (a1=addr1; a1<=addr2; a1++) {
		lp = getline(*a1);
		while (*gp = *lp++)
			if (gp++ >= &genbuf[LBSIZE-2])
				error("Line too long 2.");
		if (c == 'j')
			*gp++ = ' ';
	}
	if (gp > genbuf && c == 'j')
		*--gp = '\0';
	else
		*gp = '\0';
	lp = linebuf;
	gp = genbuf;
	while (*lp++ = *gp++)
		;
	*addr1 = putline(linebuf);
	if (addr1<addr2)
		rdelete(addr1+1, addr2);
	dot = addr1;
}

nedjoin(c, a1, a2)
char c;
int *a1, *a2;
{
	int *save;

	if (a1 <= zero || a2 > dol || a1 > a2)
		return;
	addr1 = a1;
	addr2 = a2;
	save = dot;
	if (setjmp(savej) == 0) {
		join(c);
		alt++;
		fchange = 1;
	}
	dot = save;
	return;
}

substitute(inglob)
{
	register *markp, *a1, nl;
	int gsubf;
	int getsub();

	gsubf = compsub();
	for (a1 = addr1; a1 <= addr2; a1++) {
		int *ozero;
		if (execute(0, a1)==0)
			continue;
		inglob |= 01;
		dosub();
		if (gsubf) {
			while (*loc2) {
				if (execute(1, (int *)0)==0)
					break;
				dosub();
			}
		}
		subnewa = putline(linebuf);
		*a1 &= ~01;
		if (anymarks) {
			for (markp = names; markp < &names[26]; markp++)
				if (*markp == *a1)
					*markp = subnewa;
		}
		subolda = *a1;
		*a1 = subnewa;
		ozero = zero;
		nl = append(getsub, a1);
		nl += zero-ozero;
		a1 += nl;
		addr2 += nl;
	}
	if (inglob==0)
		error("Not found.");
}

compsub()
{
	register seof, c;
	register char *p;

	if ((seof = gtchar()) == '\n' || seof == ' ')
		error("Invalid command format.");
	compile(seof);
	p = rhsbuf;
	for (;;) {
		c = gtchar();
		if (c=='\\')
			c = gtchar() | 0200;
		if (c=='\n') {
			if (globp)
				c |= 0200;
			else
				error("Invalid command format.");
		}
		if (c==seof)
			break;
		*p++ = c;
		if (p >= &rhsbuf[LBSIZE/2])
			error("Replacememt too long.");
	}
	*p++ = 0;
	if ((peekc = gtchar()) == 'g') {
		peekc = 0;
		newline();
		return(1);
	}
	newline();
	return(0);
}

getsub()
{
	register char *p1, *p2;

	p1 = linebuf;
	if ((p2 = linebp) == 0)
		return(EOF);
	while (*p1++ = *p2++)
		;
	linebp = 0;
	return(0);
}

dosub()
{
	register char *lp, *sp, *rp;
	int c;

	lp = linebuf;
	sp = genbuf;
while (sp < &genbuf[LBSIZE]) *sp++ = '\0'; sp = genbuf;
	rp = rhsbuf;
	while (lp < loc1)
		*sp++ = *lp++;
	while (c = *rp++&0377) {
		if (c=='&') {
			sp = place(sp, loc1, loc2);
			continue;
		} else if (c&0200 && (c &= 0177) >='1' && c < nbra+'1') {
			sp = place(sp, braslist[c-'1'], braelist[c-'1']);
			continue;
		}
		*sp++ = c&0177;
		if (sp >= &genbuf[LBSIZE])
			error("Line too long 3.");
	}
	lp = loc2;
	loc2 = sp - genbuf + linebuf;
	while (*sp++ = *lp++)
		if (sp >= &genbuf[LBSIZE])
			error("Line too long 4.");
	lp = linebuf;
	sp = genbuf;
	while (*lp++ = *sp++)
		;
}

char *
place(sp, l1, l2)
register char *sp, *l1, *l2;
{
	while (l1 < l2) {
		*sp++ = *l1++;
		if (sp >= &genbuf[LBSIZE])
			error("Line too long 5.");
	}
	return(sp);
}

move(cflag)
{
	int *adt;
	int *savedot, *ozero;

	setdot();
	nonzero();
	if ((adt = address())==0)
		error("Invalid target address.");
	newline();
	savedot = dot;
	ozero = zero;
	movesub(cflag, adt);
	dot = savedot - ozero + zero;
}

movesub(cflag, adt)
int cflag;
int *adt;
{
	register int *ad1, *ad2;
	int getcopy();

	if (cflag) {
		int *ozero, delta;
		ad1 = dol;
		ozero = zero;
		append(getcopy, ad1++);
		ad2 = dol;
		delta = zero - ozero;
		ad1 += delta;
		adt += delta;
	} else {
		ad2 = addr2;
		for (ad1 = addr1; ad1 <= ad2;)
			*ad1++ &= ~01;
		ad1 = addr1;
	}
	ad2++;
	if (adt<ad1) {
		dot = adt + (ad2-ad1);
		if ((++adt)==ad1)
			return;
		reverse(adt, ad1);
		reverse(ad1, ad2);
		reverse(adt, ad2);
	} else if (adt >= ad2) {
		dot = adt++;
		reverse(ad1, ad2);
		reverse(ad2, adt);
		reverse(ad1, adt);
	} else
		error("Invalid address combination.");
	fchange = 1;
	alt++;
}

nedmove(cflag, a1, a2, adt)
int     *a1, *a2, *adt;
{
	int *savedot, *ozero;

	addr1 = a1;
	addr2 = a2;
	ozero = zero;
	savedot = dot;
	movesub(cflag, adt);
	dot = savedot - ozero + zero;
}

reverse(a1, a2)
register int *a1, *a2;
{
	register int t;

	for (;;) {
		t = *--a2;
		if (a2 <= a1)
			return;
		*a2 = *a1;
		*a1++ = t;
	}
}

getcopy()
{
	if (addr1 > addr2)
		return(EOF);
	strcpy(linebuf, getline(*addr1++));   /* Needed due to getline macro. */
	return(0);
}

compile(aeof)
{
	register eof, c;
	register char *ep;
	char *lastep;
	char bracket[NBRA], *bracketp;
	int cclcnt;

	ep = expbuf;
	eof = aeof;
	bracketp = bracket;
	if ((c = gtchar()) == eof) {
		if (*ep==0)
			error("No saved regular expression.");
		return;
	}
	circfl = 0;
	nbra = 0;
	if (c=='^' && !B) {
		c = gtchar();
		circfl++;
	}
	peekc = c;
	lastep = 0;
	for (;;) {
		if (ep >= &expbuf[ESIZE])
			goto cerror;
		c = gtchar();
		if (c==eof) {
			if (bracketp != bracket)
				goto cerror;
			*ep++ = CEOF;
			return;
		}
		if (B) {
			if (c == '\n') {
				*ep++ = CEOF;
				peekc = c;
				return;
			}
			*ep++ = CCHR;
			*ep++ = c;
			continue;
		}
		if (c!='*')
			lastep = ep;
		switch (c) {

		case '\\':
			if ((c = gtchar())=='(') {
				if (nbra >= NBRA)
					goto cerror;
				*bracketp++ = nbra;
				*ep++ = CBRA;
				*ep++ = nbra++;
				continue;
			}
			if (c == ')') {
				if (bracketp <= bracket)
					goto cerror;
				*ep++ = CKET;
				*ep++ = *--bracketp;
				continue;
			}
			if (c>='1' && c<'1'+NBRA) {
				*ep++ = CBACK;
				*ep++ = c-'1';
				continue;
			}
			*ep++ = CCHR;
			if (c=='\n')
				goto cerror;
			*ep++ = c;
			continue;

		case '.':
			*ep++ = CDOT;
			continue;

		case '\n':
			*ep++ = CEOF;
			peekc = '\n';
			return;

		case '*':
			if (lastep==0 || *lastep==CBRA || *lastep==CKET)
				goto defchar;
			*lastep |= STAR;
			continue;

		case '$':
			if ((peekc=gtchar()) != eof && peekc != '\n')
				goto defchar;
			*ep++ = CDOL;
			continue;

		case '[':
			*ep++ = CCL;
			*ep++ = 0;
			cclcnt = 1;
			if ((c=gtchar()) == '^') {
				c = gtchar();
				ep[-2] = NCCL;
			}
			do {
				if (c=='\n')
					goto cerror;
				if (c=='-' && ep[-1]!=0) {
					if ((c=gtchar())==']') {
						*ep++ = '-';
						cclcnt++;
						break;
					}
					while (ep[-1]<c) {
						*ep = ep[-1]+1;
						ep++;
						cclcnt++;
						if (ep>=&expbuf[ESIZE])
							goto cerror;
					}
				}
				*ep++ = c;
				cclcnt++;
				if (ep >= &expbuf[ESIZE])
					goto cerror;
			} while ((c = gtchar()) != ']');
			lastep[1] = cclcnt;
			continue;

		defchar:
		default:
			*ep++ = CCHR;
			*ep++ = c;
		}
	}
   cerror:
	expbuf[0] = 0;
	nbra = 0;
	error("Invalid regular expression format.");
}

execute(gf, addr)
int *addr;
{
	register char *p1, *p2, c;

	for (c=0; c<NBRA; c++) {
		braslist[c] = 0;
		braelist[c] = 0;
	}
	if (gf) {
		if (circfl)
			return(0);
		p1 = linebuf;
		p2 = genbuf;
		while (*p1++ = *p2++)
			;
		locs = p1 = loc2;
	} else {
		if (addr==zero)
			return(0);
		p1 = getline(*addr);
		strcpy(linebuf, p1);  /* Needed due to getline macro. */
		p1 = linebuf;
		locs = 0;
	}
	p2 = expbuf;
	if (circfl) {
		loc1 = p1;
		return(advance(p1, p2));
	}
	/* fast check for first character */
	if (*p2==CCHR) {
		c = p2[1];
		do {
			if (*p1!=c)
				continue;
			if (advance(p1, p2)) {
				loc1 = p1;
				return(1);
			}
		} while (*p1++);
		return(0);
	}
	/* regular algorithm */
	do {
		if (advance(p1, p2)) {
			loc1 = p1;
			return(1);
		}
	} while (*p1++);
	return(0);
}

advance(lp, ep)
register char *ep, *lp;
{
	register char *curlp;
	int i;

	for (;;) switch (*ep++) {

	case CCHR:
		if (*ep++ == *lp++)
			continue;
		return(0);

	case CDOT:
		if (*lp++)
			continue;
		return(0);

	case CDOL:
		if (*lp==0)
			continue;
		return(0);

	case CEOF:
		loc2 = lp;
		return(1);

	case CCL:
		if (cclass(ep, *lp++, 1)) {
			ep += *ep;
			continue;
		}
		return(0);

	case NCCL:
		if (cclass(ep, *lp++, 0)) {
			ep += *ep;
			continue;
		}
		return(0);

	case CBRA:
		braslist[*ep++] = lp;
		continue;

	case CKET:
		braelist[*ep++] = lp;
		continue;

	case CBACK:
		if (braelist[i = *ep++]==0)
			error("Regular expression error.");
		if (backref(i, lp)) {
			lp += braelist[i] - braslist[i];
			continue;
		}
		return(0);

	case CBACK|STAR:
		if (braelist[i = *ep++] == 0)
			error("Regular expression error.");
		curlp = lp;
		while (backref(i, lp))
			lp += braelist[i] - braslist[i];
		while (lp >= curlp) {
			if (advance(lp, ep))
				return(1);
			lp -= braelist[i] - braslist[i];
		}
		continue;

	case CDOT|STAR:
		curlp = lp;
		while (*lp++)
			;
		goto star;

	case CCHR|STAR:
		curlp = lp;
		while (*lp++ == *ep)
			;
		ep++;
		goto star;

	case CCL|STAR:
	case NCCL|STAR:
		curlp = lp;
		while (cclass(ep, *lp++, ep[-1]==(CCL|STAR)))
			;
		ep += *ep;
		goto star;

	star:
		do {
			lp--;
			if (lp==locs)
				break;
			if (advance(lp, ep))
				return(1);
		} while (lp > curlp);
		return(0);

	default:
		error("Regular expression error.");
	}
}

backref(i, lp)
register i;
register char *lp;
{
	register char *bp;

	bp = braslist[i];
	while (*bp++ == *lp++)
		if (bp >= braelist[i])
			return(1);
	return(0);
}

cclass(set, c, af)
register char *set, c;
{
	register n;

	if (c==0)
		return(0);
	n = *set++;
	while (--n)
		if (*set++ == c)
			return(af);
	return(!af);
}

putd(n)
{
	register r;

	r = n%10;
	n /= 10;
	if (n)
		putd(n);
	ptchar(r + '0');
}

puts(sp)
register char *sp;
{
	while (*sp)
		ptchar(*sp++);
}

ptchar(ac)
{
	if (errmsgptr < &errmsg[ERRLEN-1])
		*errmsgptr++ = ac;
}

crblock(permp, buf, nchar, startn)
char *permp;
char *buf;
int startn;
{
	register char *p1;
	int n1;
	int n2;
	register char *t1, *t2, *t3;

	t1 = permp;
	t2 = &permp[256];
	t3 = &permp[512];

	n1 = startn&0377;
	n2 = (startn>>8)&0377;
	p1 = buf;
	while(nchar--) {
		*p1 = t2[(t3[(t1[(*p1+n1)&0377]+n2)&0377]-n2)&0377]-n1;
		n1++;
		if(n1==256){
			n1 = 0;
			n2++;
			if(n2==256) n2 = 0;
		}
		p1++;
	}
}

getkey()
{
	struct sgttyb b;
	int save;
	int (*sig)();
	register char *p;
	register c;

	sig = signal(SIGINT, SIG_IGN);
	if (gtty(0, &b) == -1)
		error("Input not tty.");
	save = b.sg_flags;
	b.sg_flags &= ~ECHO;
	stty(0, &b);
	printf("Key:");
	p = key;
	while(((c=getchar()) != EOF) && (c!='\n')) {
		if(p < &key[KSIZE])
			*p++ = c;
	}
	*p = 0;
	b.sg_flags = save;
	stty(0, &b);
	signal(SIGINT, sig);
	return(key[0] != 0);
}

/*
 * Besides initializing the encryption machine, this routine
 * returns 0 if the key is null, and 1 if it is non-null.
 */
crinit(keyp, permp)
char	*keyp, *permp;
{
	register char *t1, *t2, *t3;
	register i;
	int ic, k, temp, pf[2];
	unsigned random;
	char buf[13];
	int  seed;

	t1 = permp;
	t2 = &permp[256];
	t3 = &permp[512];
	if(*keyp == 0)
		return(0);
	strncpy(buf, keyp, 8);
	while (*keyp)
		*keyp++ = '\0';
	buf[8] = buf[0];
	buf[9] = buf[1];
	if (pipe(pf)<0)
		pf[0] = pf[1] = -1;
	if (fork()==0) {
		close(0);
		close(1);
		dup(pf[0]);
		dup(pf[1]);
		execl("/usr/lib/makekey", "-", 0);
		execl("/lib/makekey", "-", 0);
		exit(1);
	}
	write(pf[1], buf, 10);
	if (wait((int *)NULL)==-1 || read(pf[0], buf, 13)!=13)
		error("Crypt: cannot generate key.");
	close(pf[0]);
	close(pf[1]);
	seed = 123;
	for (i=0; i<13; i++)
		seed = seed*buf[i] + i;
	for(i=0;i<256;i++){
		t1[i] = i;
		t3[i] = 0;
	}
	for(i=0; i<256; i++) {
		seed = 5*seed + buf[i%13];
		random = seed % 65521;
		k = 256-1 - i;
		ic = (random&0377) % (k+1);
		random >>= 8;
		temp = t1[k];
		t1[k] = t1[ic];
		t1[ic] = temp;
		if(t3[k]!=0) continue;
		ic = (random&0377) % k;
		while(t3[ic]!=0) ic = (ic+1) % k;
		t3[k] = ic;
		t3[ic] = k;
	}
	for(i=0; i<256; i++)
		t2[t1[i]&0377] = i;
	return(1);
}

makekey(a, b)
char *a, *b;
{
	register int i;
	int  t;
	char temp[KSIZE + 1];

	for(i = 0; i < KSIZE; i++)
		temp[i] = *a++;
	t = time();
	t += getpid();
	for(i = 0; i < 4; i++)
		temp[i] ^= (t>>(8*i))&0377;
	crinit(temp, b);
}

writefile(c)
char c;
{
	int r, s, dirac;
	char *cp;
	char *rindex(), *getenv();
	struct  stat  stat_info;

	r = filename(c);
	if (roflg && r)
		error("Read only.");
	if (file[0] == '\0')
		error("No filename.");
	if (access(file, 0) == 0 && access(file, 2) != 0)
		error("No write access.");
	s = stat(file, &stat_info);
	strcpy(tmpfile, file);
	cp = rindex(tmpfile, '/');
	if (cp)
		*cp = '\0';
	else
		strcpy(tmpfile, ".");
	dirac = access(tmpfile, 2);
	if (dirac == 0 && c != 'W' && (s == -1 || ( stat_info.st_uid == getuid()
			&& stat_info.st_gid == getgid() && stat_info.st_nlink == 1))) {
		strcat(tmpfile, "/ned.tmpXXXXXX");
		mktemp(tmpfile);
		io = creat(tmpfile, (s == -1) ? mode : (int) stat_info.st_mode);
		if (io < 0)
			werror("Cannot creat \"%s\"", tmpfile);
		putfile();
		exfile();
		sync();
		unlink(file);
		if (link(tmpfile, file))
			werror("Cannot link \"%s\"\n", file);
		sync();
		unlink(tmpfile);
		*tmpfile = '\0';
	} else {
		cp = getenv("HOME");
		if (cp == NULL)
			werror("No home directory.");
		strcpy(tmpfile, cp);
		strcat(tmpfile, "/ned.tmpXXXXXX");
		mktemp(tmpfile);
		io = creat(tmpfile, mode);
		if (io < 0)
			werror("Cannot creat tempfile.");
		/* io is a temp file in $HOME */
		if (c == 'W') {
			/* cat the original file into it */
			io2 = open(file, 2);
			if (io2 < 0)
				werror("Cannot open \"%s\"", file);
			filecopy(io2, io, file, tmpfile);
		}
		putfile();
		/* tmp file in $HOME is complete */
		sync();
		if (c == 'W')
			seek(io2, 0, 0);
		else {
			io2 = creat(file, (s == -1) ? mode : (int) stat_info.st_mode);
			if (io2 < 0)
				werror("Cannot creat \"%s\"", file);
		}
		close(io);  /* it is open for writing only */
		io = open(tmpfile, 0);
		if (io < 0)
			werror("cannot open \"%s\"\n", tmpfile);
		filecopy(io, io2, tmpfile, file);
		close(io2);
		exfile();
		sync();
		unlink(tmpfile);
		*tmpfile = '\0';
	}
	if (strcmp(savedfile, file) == 0) {
		rc = 1;
		fchange = 0;
		alt = 0;
	}
}

filecopy(io1, io2, file1, file2)
register int io1, io2;
char *file1, *file2;
{
	register n;
	static char buf[4096];

	while ((n = read(io1, buf, BSIZE)) > 0)
		if (write(io2, buf, n) < 0)
			werror("Write error %d on \"%s\"", errno, file2);
	if (n < 0)
		werror("Read error %d on \"%s\"", errno, file1);
}

/*VARARGS*/
werror(s)
char *s;
{
	char tmp[128];

	sprintf(tmp, "%r", &s);
	error(tmp);
}
