/*
 * Ned error handling routines.
 */

#define ERRLEN 100

#include <signal.h>
#include <stdio.h>
#include <pwd.h>

extern int sys_nsig;
extern char *sys_siglist[];

extern int debug;
extern int fchange;
extern int io;
extern int *addr1;
extern int *addr2;
extern int *zero;
extern int *dol;

int nerr;
int signospc(), sig();

char errmsg1[ERRLEN];
char errmsg2[ERRLEN];
char errfile[] = "ned.errorXXXXXX";

/*
 * Set up to catch all signals.
 */
sigsetup()
{
	register i;
	extern int catch();

	for (i = 1; i <= NSIG; i++)
		signal(i, catch);
	signal(SIGNOSPC, signospc);
	if (debug)
	        signal(SIGINT, SIG_DFL);
	else
	        signal(SIGINT, SIG_IGN);
}

/*
 * Handle SIGNOSPC (disk full) signal.
 * Save the buffer on disk per the user's instructions.
 */
signospc()
{
	char *cp;
	static char buf[100];
	int c, c2;

	signal(SIGNOSPC, signospc);
	fchange = 0;            /* to avoid hangup in "q" */
	if (buf[0])             /* already tried once and disk was full */
		unlink(buf);
	fsclose();
	printf("Ned: disk full signal received.\n");
	if (isatty(fileno(stdin)) == -1)
		if (freopen("/dev/tty", "r", stdin) == NULL)
			nederr("Cannot open tty");
	do {
		printf("Do you want to try to save the file? (y or n) ");
		c = getchar();
		while ((c2 = getchar()) != '\n' && c2 != EOF)
			;
		if (c == 'n' || c2 == EOF)
		        quit(2);
	} while (c != 'y');
	do {
		printf("Enter file name (null line to exit): ");
		cp = buf;
		while ((c = getchar()) != '\n' && c != EOF)
			*cp++ = c;
		if (cp == buf)
			quit(2);
		*cp = '\0';
		io = creat(buf, 0666);
		if (io < 0)
			printf("Cannot creat: %s\n", buf);
	} while (io < 0);
	addr1 = zero;
	addr2 = dol;
	putfile();
	printf("File written successfully: %s\n", buf);
	quit(2);
}

/*
 * Catch other signals.
 */
catch(signo)
int signo;
{
	char buf[ERRLEN];

	signal(signo, catch);
	if (debug)
		printf("catch. signo %d\n", signo);
	if (signo > 0 && signo < sys_nsig)
	        sprintf(buf, "Ned: signal %d (%s) received.\n", signo, sys_siglist[signo]);
	else
	        sprintf(buf, "Ned: signal %d received.\n", signo);
	nederr(buf);
}

/*
 * Ned error handling routine.
 * Try to save the buffer in errfile.
 */
nederr(msg)
char *msg;
{
	if (debug)
		printf("nederr called. msg %s\n", msg);
	if (nerr) {
		strcpy(errmsg2, msg);
		sendmsg();
		quit(2);
	}
	nerr = 1;
	strcpy(errmsg1, msg);
	if (dol <= zero) {
		strcpy(errmsg2, "Buffer empty - not saved.\n");
		sendmsg();
		quit(2);
	}
	mktemp(errfile);
	io = creat(errfile, 0666);
	if (io < 0) {
		sprintf(errmsg2, "Cannot creat %s.\n", errfile);
		sendmsg();
		quit(2);
	}
	addr1 = zero + 1;
	addr2 = dol;
	putfile();
	sync();
	sprintf(errmsg2, "Ned buffer saved in file \"%s\".\n", errfile);
	sendmsg();
	quit(2);
}

sendmsg()
{
	char *user;
	char *getlogin();
	struct passwd *pwp, *getpwuid();

	user = getlogin();
	if (user == NULL) {
		pwp = getpwuid(getuid());
		if (pwp == NULL) {
			printf("getpwuid failed.\n%s\n%s\n", errmsg1, errmsg2);
			return;
		}
		user = pwp->pw_name;
	}
	strcat(errmsg1, errmsg2);
	notify(user, errmsg1, 0);
}
