#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/dir.h>
#include "save.h"

char    cflg;
char    fflg;
char    error;
char    *usage = "Usage: %s [-v n] [-c] [-o] [-f] file ...\n";
extern  char    *cmdname;
/*
 * Restore each of the arguments.
 */
main(argc, argv)
int     argc;
char    **argv;
{
	char    svname[100];
	char    argname[100];
	char    *sname();
	int     ver = 0;
	int     oflg = 0;
	int     lastchar;
	FILE    *ifp, *fopen(), *ofp;

	*argv++;
	while (--argc && **argv == DASH) {
                switch(*(*argv+1)) {
                case OUTPUT:
			oflg++;
			fflg++;
                        break;
		case VERSION:
			if (--argc <= 0) {
				fprintf(stderr, usage, cmdname);
				exit(1);
			}
			if (!isnum(*++argv)) {
				fprintf(stderr, usage, cmdname);
				exit(1);
			}
			ver = atoi(*argv);
			break;
		case COMMENTS:
			cflg++;
			break;
		case FORCE:
			fflg++;
			break;
		default:
                        fprintf(stderr, usage, cmdname);
			exit(1);
                }
		argv++;
        }
        if (argc <= 0) {
                fprintf(stderr, usage, cmdname);
                exit(1);
        }
	for (; argc--; argv++) {
		strcpy(argname, *argv);
		lastchar = strlen(argname) - 1;
		if (argname[lastchar] == CSUFFIX)
			argname[lastchar] = EOS;
                if (strlen(sname(argname)) >= DIRSIZ) {
                        fprintf(stderr, "%s: %s: filename too long\n",
				cmdname, argname);
			error++;
                        continue;
                }
                strcpy(svname, argname);
                strcat(svname, SUFFIX);
		if (cantrest(argname, svname))
                        continue;
                if ((ifp = fopen(svname, "r")) == NULL) {
                        fprintf(stderr, "%s: %s: not saved\n",
				cmdname, argname);
			error++;
                        continue;
		} else if (cflg) {
			prt(argname, ifp);
                        fclose(ifp);
			continue;
                } else  if (!oflg) {
                        if ((ofp = fopen(argname, "w")) == NULL) {
                                fprintf(stderr, "%s: %s: unable to open\n",
                                        cmdname, argname);
                                fclose(ifp);
                                error++;
                                continue;
                        }
                } else
			ofp = stdout;
                restore(ifp, ofp, ver);
                fclose(ifp);
                fclose(ofp);
		ofp = NULL;
        }
	exit(error);
}
/*
 *  cantrest - see if this file can be restored
 *  Returns:  0:  the file can be restored
 *            1:  the file can't be restored
 */
cantrest(name, svname)
char    *name;
char    *svname;
{
	struct  stat    svstatb, statb;

	if (stat(name, &statb) != -1) {
		if (stat(svname, &svstatb) == -1) {
                        fprintf(stderr, "%s: %s: not saved\n",
				cmdname, name);
			error++;
			return(1);
		}
		if (access(svname, 4) == -1) {
                        fprintf(stderr, "%s: %s: cannot read\n",
				cmdname, svname);
			error++;
			return(1);
                }
		if (!cflg && !fflg) {
                        if (statb.st_mtime > svstatb.st_mtime) {
                                fprintf(stderr, "%s: %s: not out of date\n",
                                        cmdname, name);
                                error++;
                                return(1);
                        }
                }
	}
	return(0);
}
/* feed - feed a line to the version applier
 * If no more versions, then output the line.
 * Unescape output lines.
 */
feed(v, line, ofp)
struct  version *v;
char    *line;
FILE    *ofp;
{
	if (v != NULL)
		ver(v, line, ofp);
	else
		fprintf(ofp, "%s", (*line != CNTRLCHAR)? line: &line[1]);
}
/* prt - print comments and other info
 * Open the file and look for "%I" beginning in column one.
 * Print the info line and any comment lines.
 */
prt(name, fp)
char    *name;
FILE    *fp;
{
	int     nversion = 0, maxver = 0;
	char    buff[MAXLINE];


	if (fgets(buff, MAXLINE, fp) == NULL)
		return;
        sscanf(buff, "%*s %d", &maxver);
	if (maxver)
		printf("\n%s: maximum of %d versions saved\n", name, maxver);
	else
		printf("\n%s: all versions saved\n", name);

	while (fgets(buff, MAXLINE, fp) != NULL) {
		if (buff[0] == CNTRLCHAR) {
			switch(buff[1]) {
			case INFO:
                                printf("\nversion %d  %s", ++nversion, &buff[2]);
				break;
                        case CMT:
                                printf("%s", &buff[2]);
				break;
			}
		}
	}
}
