#include <stdio.h>
#include <stdioerr.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/dir.h>
#include <signal.h>
#include <pwd.h>
#include "save.h"

char    *usage = "Usage: %s [-n n] [-c] [-r] [-f] file ...\n";
char    cflg;                   /* suppress comment flag */
char    rflg;                   /* remove flag */
char    vflg;                   /* max versions flag */
char    fflg;                   /* force flag */
char    error;
char    *tmp = "/tmp/saveXXXXXX";
char    *tmp2 = "/tmp/saveXXXXXX";
int     signalno;               /* number of a caught signal */
int     die = 1;                /* can we die now */
extern  char    *cmdname;
/*
 * Save a version of each argument file.  Restore the latest version
 * from the savefile, run diff between it and the argument file, and
 * append the diff commands to the savefile.
 * If too many versions, combine the oldest ones and rebuild the
 * savefile.
 */
main(argc, argv)
int     argc;
char    **argv;
{
	char    argname[100];
	char    *sname(), *mktemp();
	int     nmaxver = 0;            /* new max versions */
	int     lastchar;
	int     fd;
	int     savesig();
	int     i;

	*argv++;
	while (--argc && **argv == DASH) {
                switch (*(*argv+1)) {
                case COMMENTS:
                        cflg++;
                        break;
		case MAXVERS:
			if (--argc <= 0) {
                                fprintf(stderr, usage, cmdname);
                                exit(1);
                        }
			if (!isnum(*++argv)) {
				fprintf(stderr, usage, cmdname);
				exit(1);
			}
			if ((nmaxver = atoi(*argv)) < 0) {
				fprintf(stderr, "%s: %d: Bad maximum versions\n",
                                        cmdname, nmaxver);
				exit(1);
                        }
			vflg++;
			break;
		case REMOVE:
			rflg++;
			break;
		case FORCE:
			fflg++;
			break;
		default:
                        fprintf(stderr, usage, cmdname);
			exit(1);
                }
		argv++;
	}
	if (argc <= 0) {
		fprintf(stderr, usage, cmdname);
		exit(1);
	}
	onerror(EIO, EIGNORE);
	for (i = 1; i <= NSIG; i++)
                signal(i, savesig);

	mktemp(tmp);
	fd = creat(tmp, 0600);
	close(fd);
	for (; argc--; argv++) {
		if (signalno)
			exit(signalno);
		strcpy(argname, *argv);
		lastchar = strlen(argname) - 1;
		if (argname[lastchar] == CSUFFIX)
			argname[lastchar] = EOS;
                if (strlen(sname(argname)) >= DIRSIZ) {
                        fprintf(stderr, "%s: %s: filename too long\n",
				cmdname, argname);
                        error++;
                        continue;
                }
                if (save(argname, nmaxver) != -1) {
                        if (rflg)
                                unlink(argname);
		} else
			unlink(tmp);
	}
	exit(error);
}
/*
 * getcmt - get comments
 * If requested, get comments for this version.
 * Read comments from the standard input and save them in case
 * there are multiple files.
 */
getcmt(fp)
FILE    *fp;
{
	char    buff[MAXLINE];
	char    *malloc(), *getenv();
	char    *ps2;
	struct  comment *c, **ptr;
	static  struct  comment *cmthdr = NULL;
	static  int     first = 1;

	if (!cflg) {
                if (first) {
                        first = 0;
                        if ((ps2 = getenv("PS2")) == NULL)
                                ps2 = "> ";
                        if (isatty(fileno(stdin)))
                                printf("comments:\n%s", ps2);
                        ptr = &cmthdr;
                        while (fgets(buff, MAXLINE, stdin) != NULL &&
                               strcmp(buff, ".\n") != 0 &&
                               strcmp(buff, "\n") != 0) {
                                c = (struct comment *) malloc(sizeof(struct comment));
                                c->c_next = NULL;
                                c->c_text = malloc(strlen(buff)+1);
                                strcpy(c->c_text, buff);
                                *ptr = c;
                                ptr = &c->c_next;
                                if (isatty(fileno(stdin)))
                                        printf("%s", ps2);
                        }
                }
	}
	die = 0;
	wrinfo(fp);
	for (c = cmthdr; c != NULL; c = c->c_next)
                fprintf(fp, "%c%c %s", CNTRLCHAR, CMT, c->c_text);
}
/*
 * wrinfo - write the info line
 * Contains the userid of the owner of the version and the date and time.
 */
wrinfo(fp)
FILE    *fp;
{
	struct  passwd  *pw, *getpwuid();
	time_t  time();
	char    *username, *getlogin(), *ctime();

	if ((username = getlogin()) == NULL) {
		pw = getpwuid(getuid());
		username = pw->pw_name;
	}
	fprintf(fp, "%c%c %s %s", CNTRLCHAR, INFO, username, ctime(time()));
}
/*
 *  savesig - remove temporary files upon catching signals
 *  For interrupts and quits set a flag and cleanup after
 *  finishing this save.
 *  ARGSUSED
 */
savesig(sig)
int     sig;
{
	if (!die) {
                if (sig == SIGINTR || sig == SIGQUIT) {
                        signalno = sig;
                        return;
                }
	}
	unlink(tmp);
	unlink(tmp2);
	exit(sig);
}
