/*------------ source/sccs4/cmd/rmdel.c --------*/
# include "../hdr/defines.h"
# include "../hdr/had.h"
# include <pwd.h>
 
/* SCCSID(@(#)rmchg        1.4); */
 
/*
        Program to remove a specified delta from an SCCS file,
        when invoked as 'rmdel',
        or to change the comments of a specified delta,
        when invoked as 'chghist'.
        (The program has two links to it, one called 'rmdel', the
        other 'chghist'.)
 
        The delta to be removed (or whose comments
        are to be changed) is specified via the
        r argument, in the form of an SID.
 
        If the delta is to be removed, it must be the most recent one
        in its branch in the delta tree (a so-called 'leaf' delta).
        For either function, the user must have basically
        the same permissions as are required to make deltas.
 
        If a directory is given as an argument, each SCCS file
        within the directory will be processed as if it had been
        specifically named. If a name of '-' is given, the standard
        input will be read for a list of names of SCCS files to be
        processed. Non SCCS files are ignored.
*/
 
# define COPY 0
# define NOCOPY 1
 
struct sid sid;
int num_files;
char had[26];
char D_type;
int D_serial;
struct passwd *getpwuid();
 
main(argc,argv)
int argc;
char *argv[];
{
        register int i;
        register char *p;
        char c;
        extern rmchg();
        extern int Fcnt;
 
        /*
        Set flags for 'fatal' to issue message, call clean-up
        routine, and terminate processing.
        */
        Fflags = FTLMSG | FTLCLN | FTLEXIT;
 
        for(i=1; i<argc; i++)
                if(argv[i][0] == '-' && (c = argv[i][1])) {
                        p = &argv[i][2];
                        switch (c) {
 
                        case 'r':
                                if (!(*p))
                                        fatal("r has no sid (help rmdel.11)");
                                chksid(sid_ab(p,&sid),&sid);
                                break;
                        default:
                                fatal("unknown key letter (help sccs.21)");
                        }
 
                        if (had[c - 'a']++)
                                fatal("key letter twice (help sccs.22)");
                        argv[i] = 0;
                }
                else
                        num_files++;
 
        if(num_files == 0)
                fatal("missing file arg (help sccs.23)");
 
        if (*(p = sname(argv[0])) == 'n')
                p++;
        if (equal(p,"rmdel"))
                D_type = 'R';           /* invoked as 'rmdel' */
        else if (equal(p,"chghist"))
                D_type = 'D';           /* invoked as 'chghist' */
        else
                fatal("bad invocation (help rmdel.10)");
 
        setsig();
 
        /*
        Change flags for 'fatal' so that it will return to this
        routine (main) instead of terminating processing.
        */
        Fflags =& ~FTLEXIT;
        Fflags =| FTLJMP;
 
        /*
        Call 'rmchg' routine for each file argument.
        */
        for (i=1; i<argc; i++)
                if (p = argv[i])
                        do_file(p,rmchg);
 
        exit(Fcnt ? 1 : 0);
}
 
 
/*
        Routine that actually causes processing of the delta.
        Processing on the file takes place on a
        temporary copy of the SCCS file (the x-file).
        The name of the x-file is the same as that of the
        s-file (SCCS file) with the 's.' replaced by 'x.'.
        At end of processing, the s-file is removed
        and the x-file is renamed with the name of the old s-file.
 
        This routine makes use of the z-file to lock out simultaneous
        updates to the SCCS file by more than one user.
*/
 
struct packet gpkt;     /* see file s.h */
char line[BUFSIZ];
char *Comments;
 
/* Mod for Version 7
USXALLOC();             /* defines alloc() and free() */
 
int first_time 1;
 
rmchg(file)
char *file;
{
        struct deltab dt;       /* see file s.h */
        struct stats stats;     /* see file s.h */
        extern char *Sflags[];
        int n;
        char *p, *cp;
        int keep;
        extern char Pgmr[8];
        int fowner, downer, user;
        char *id;
 
        if (setjmp(Fjmp))       /* set up to return here from 'fatal' */
                return;         /* and return to caller of rmchg */
 
        if (!HADR)
                fatal("missing r (help rmdel.1)");
 
        if (D_type == 'D' && first_time) {
                first_time = 0;
                dohist(file);
        }
 
        if (!exists(file))
                fatal(sprintf(Error,"file %s does not exist (help rmdel.2)",file));
 
        /*
        Lock out any other user who may be trying to process
        the same file.
        */
        if (lockit(auxf(file,'z'),2,getpid()))
                fatal("cannot create lock file (help sccs.24)");
 
        sinit(&gpkt,file,1);    /* initialize packet and open s-file */
 
        /*
        Flag for 'putline' routine to tell it to open x-file
        and allow writing on it.
        */
        gpkt.p_upd = 1;
 
        /*
        Save requested SID for later checking of
        permissions (by 'permiss').
        */
        move(&sid,&gpkt.p_reqsid,sizeof(gpkt.p_reqsid));
 
        /*
        Now read-in delta table. The 'dodelt' routine
        will read the table and change the delta entry of the
        requested SID to be of type 'R' if this is
        being executed as 'rmdel'; otherwise, for 'chghist', only
        the comments section will be changed
        (by 'escdodelt', called by 'dodelt').
        */
        if (dodelt(&gpkt,&stats,&sid,D_type) == 0)
                fmterr(&gpkt);
 
        /*
        Get serial number of requested SID from
        delta table just processed.
        */
        D_serial = sidtoser(&gpkt.p_reqsid,&gpkt);
 
        /*
        If SID has not been zeroed (by 'dodelt'),
        SID was not found in file.
        */
        if (sid.s_rel != 0)
                fatal("nonexistent sid (help rmdel.3)");
		else move(&gpkt.p_reqsid,&sid,sizeof(sid));	/* reassign */
				/* for multiple invocations (directory)     */
 
        /*
        Now check permissions.
        */
        finduser(&gpkt);
        doflags(&gpkt);
        permiss(&gpkt);
 
        /*
        Check that user is either owner of file or
        directory, or is one who made the delta.
        */
        fstat(fileno(gpkt.p_iop),&Statbuf);
        fowner = Statbuf.st_uid & 0377;
        copy(gpkt.p_file,line);         /* temporary for dname() */
        if (stat(dname(line),&Statbuf))
                downer = -1;
        else
                downer = Statbuf.st_uid & 0377;
        user = getuid() & 0377;
        if (user != fowner || user != downer) {
                id = getlogin();
		if (id == NULL) {
			struct passwd *pwent;
			pwent = getpwuid(getuid());
			if (pwent == NULL)
				fatal("cannot determine user name (help sccs.29)");
			else
				id = pwent->pw_name;
			}
                if (!equal(Pgmr,id))
                        fatal(sprintf(Error,
                                "you are neither owner nor '%s' (help rmdel.4)",Pgmr));
			}
 
        /*
        For 'rmdel', check that delta being removed is a
        'leaf' delta, and if ok,
        process the body.
        */
        if (D_type == 'R') {
                for (n = maxser(&gpkt); n > D_serial; n--) {
                        p = &gpkt.p_idel[n];
                        if (p->i_pred == D_serial)
                                fatal("not a 'leaf' delta (help rmdel.5)");
                }
 
                flushto(&gpkt,EUSERTXT,COPY);
 
                keep = YES;
                gpkt.p_chkeof = 1;              /* set EOF is ok */
                while ((p = getline(&gpkt)) != NULL) {
                        if (*p++ == CTLCHAR) {
                                cp = p++;
                                NONBLANK(p);
                                /*
                                Convert serial number to binary.
                                */
                                if (*(p = satoi(p,&n)) != '\n')
                                        fmterr(&gpkt);
                                if (n == D_serial) {
                                        gpkt.p_wrttn = 1;
                                        if (*cp == INS)
                                                keep = NO;
                                        else
                                                keep = YES;
                                }
                        }
                        else
                                if (keep == NO)
                                        gpkt.p_wrttn = 1;
                }
        }
        else {
                /*
                This is for invocation as 'chghist'.
                */
 
                /*
                Indicate that EOF at this point is ok, and
                flush rest of s-file to x-file.
                */
                gpkt.p_chkeof = 1;
                while (getline(&gpkt))
                        ;
        }
 
        flushline(&gpkt,0);
 
        /*
        Delete old s-file, change x-file name to s-file.
        */
        rename(auxf(&gpkt,'x'),&gpkt);
 
        clean_up();
}
 
 
escdodelt(pkt)
struct packet *pkt;
{
        extern int First_esc;
        char *p;
        extern int Timenow;
        char *id;
 
        if (D_type == 'D' && First_esc) {       /* chghist, first time */
                First_esc = 0;
 
                putline(pkt,sprintf(line,"%c%c ",CTLCHAR,COMMENTS));
                putline(pkt,Comments);
                putline(pkt,"\n");
                putline(pkt,sprintf(line,"%c%c ",CTLCHAR,COMMENTS));
                putline(pkt,"*** CHANGED *** ");
                date_ba(&Timenow,line);         /* get date and time */
                putline(pkt,line);
                id = getlogin();
		if (id == NULL) {
			struct passwd *pwent;
			pwent = getpwuid(getuid());
			if (pwent == NULL)
				fatal("cannot determine user name (help sccs.29)");
			else
				id = pwent->pw_name;
			}
                putline(pkt,sprintf(line," %s\n",id));
        }
 
}
 
 
clean_up()
{
        xrm(&gpkt);
        if (gpkt.p_file[0])
                unlockit(auxf(gpkt.p_file,'z'),getpid());
	/*xfreeall();conflicts w/stdio lib free*/
}
