#define N_RDONLY 0100000                /* read-only variable */
#define N_EXPORT 0040000                /* exportable variable */
#define N_ENVNAM 0020000                /* variable's in environment */
#define N_DEFAULT 0
/*
 * Node associated with each shell variable.  These nodes are kept
 * in a sorted binary tree.
 */
struct	namnod {
	struct  namnod  *namlft;        /* left subtree */
	struct  namnod  *namrgt;        /* right subtree */
	char    *namid;                 /* variable's name */
	char    *namval;                /* variable's local value */
	char    *namenv;                /* variable's environment value */
	int     namflg;                 /* flags */
};
/*
 *  Shell commands structure.
 */
struct	sysnod {
	char    *sysnam;                /* name of the command */
	int  sysval;                    /* internal value */
};
/*
 * Argument node.
 */
struct	argnod {
	struct  argnod  *argnxt;        /* next argument */
	int     argmk;
	char    *argval;                /* argument string */
};
/*
 * Dollar node.  For the $0 $1 ... $n variables
 */
struct  dolnod {
	struct   dolnod  *dolnxt;       /* next node */
	int      doluse;                /* num of times in for loop use */
	char     **dolarg;              /* arg vector */
};
/*
 *  I/o redirection for a command or list of commands
 */
struct  ionod {
	int     iofile;                 /* file descriptor and flags */
	char    *ioname;                /* name of the file */
	struct  ionod   *ionxt;
	struct  ionod   *iolst;
};
/*
 * Regular expression nodes for switches in case statements
 *                      pattern) stmt-list1 ;;
 */
struct  regnod {
	struct  argnod  *regptr;        /* regular expression pattern */
	union   node    *regcom;        /* stmt-list1 */
	struct  regnod  *regnxt;        /* next pattern */
};
/*
 * The following structures are all nodes of the parse tree
 *
 *Fork node.
 */
struct  _forknod {
	int     type;                   /* node type */
	struct  ionod   *forkio;        /* i/o for this fork */
	union   node    *forktre;       /* stmt-list to be forked */
};
/*
 * Command node
 */
struct  _comnod {
	int     type;                   /* node type */
	struct  ionod   *comio;         /* fancy i/o */
	struct  argnod  *comarg;        /* arguments */
	struct  argnod  *comset;        /* shell variable assignments */
};
/*
 * If statement node.   if   stmt-list1
 *                      then stmt-list2
 *                      else stmt-list3
 *                      fi
 */
struct  _ifnod {
	int     type;                   /* node type */
	union	node    *iftre;         /* stmt-list1 */
	union	node    *thtre;         /* stmt-list2 */
	union	node    *eltre;         /* stmt-list3 */
};
/*
 * While statement.     while   stmt-list1
 *                      do
 *                              stmt-list2
 *                      done
 */
struct  _whnod {
	int     type;                   /* node type */
	union	node    *whtre;         /* stmt-list1 */
	union	node    *dotre;         /* stmt-list2 */
};
/*
 * For statement.       for name [in arg1 arg2 ... argn ]
 *                      do
 *                              stmt-list1
 *                      done
 */
struct  _fornod {
	int     type;                   /* node type */
	union	node    *fortre;        /* stmt-list1 */
	char    *fornam;                /* for index variable name */
	union   node    *forlst;        /* arg1, arg2, ... if not the default */
};
/*
 * Switch node.         case name in
 *                      pattern1) stmt-list1 ;;
 *                      pattern2) stmt-list2 ;;
 *                              ...
 *                      patternn) stmt-listn
 *                      esac
 */
struct  _swnod {
	int     type;                   /* node type */
	char    *swarg;                 /* case variable name */
	struct  regnod  *swlst;         /* pattern list */
};
/*
 * Parenthesis node.            (stmt-list1)
 */
struct  _parnod {
	int     type;                   /* node type */
	union	node    *partre;        /* stmt-list1 */
};
/*
 * Stmt-list node.
 */
struct  _lstnod {
	int     type;                   /* node type */
	union	node    *lstlef;        /* left subtree */
	union	node    *lstrit;        /* right subtree */
};

union   node    {
        struct  _forknod forknod;
        struct  _comnod  comnod;
        struct  _ifnod   ifnod;
        struct  _whnod   whnod;
        struct  _fornod  fornod;
        struct  _swnod   swnod;
        struct  _parnod  parnod;
        struct  _lstnod  lstnod;
};

#define NODESIZ         (sizeof(union  node))
#define IOSIZ           (sizeof(struct ionod))
#define ARGSIZ          (sizeof(struct argnod))
#define DOLSIZ          (sizeof(struct dolnod))
