/*
 * Talk to the 'SMART' virtual machine
 */
#include <qsdefs.h>
#include <stdio.h>
#include <sgtty.h>

int fd;

main(argc, argv)
int argc;
char **argv;
{
	char line[100], *cp1, *cp2;

	fd = vmcfopen("smart", VMC_P2);
	if(fd < 0) {
		fprintf(stderr, "Can't open VMCF for SMART\n");
		exit(1);
	}
	if(argc <= 1)
		interact();
	cp1 = line;
	while(--argc) {
		cp2 = *++argv;
		while(*cp1 = *cp2++) cp1++;
		*cp1++ = ' ';
	}
	*cp1 = '\0';
	oneshot(line);
}

interact()
{
	extern char atetab[], etatab[];
	char screen[22*80+1], line[51];
	int i, n;
	char *cp;

	screen[0] = '\0';
	for(;;) {
		line[0] = '\0';
                panel(erase) {
                        #@201##1screen,sizeof screen#
			#@2402# Smart command: #7line,50#
		}
		switch(qskp) {
		case PF3:
		case TESTREQ:
			exit(0);
		case ENTER:
			if(line[0] == '\0')
				strcpy(line, "next");
			break;
		case CLEAR:
		case PA2:
			strcpy(line, "next");
			break;
		case PF4:
			strcpy(line, "d user all");
			break;
		case PF5:
			strcpy(line, "d i/o");
			break;
		case PF6:
			strcpy(line, "d channel");
			break;
		}
		for(cp=line; *cp; cp++)
			*cp = atetab[*cp];
		n = cp-line;
		if(write(fd, line, n) != n) {
			fprintf(stderr, "VMCF write error\n");
			exit(0);
		} else {
			n = read(fd, screen, sizeof screen);
			if(n < 0) {
				fprintf(stderr, "VMCF read error\n");
                                exit(0);
			} else {
				for(i=0; i<n; i++) {
					screen[i] = etatab[screen[i]];
					if(screen[i] == '\0')
						screen[i] = ' ';
				}
				screen[n] = '\0';
			}
		}
	}
}

oneshot(line)
char *line;
{
	extern char atetab[], etatab[];
	char screen[22][80];
	int i, j, n;
	char *cp;

        for(cp=line; *cp; cp++)
                *cp = atetab[*cp];
        n = cp-line;
        if(write(fd, line, n) != n) {
                fprintf(stderr, "VMCF write error\n");
        } else {
                n = read(fd, screen, sizeof screen);
                if(n < 0) {
                        fprintf(stderr, "VMCF read error\n");
                } else {
                        for(i=0; i<22; i++) {
				for(j=0; j<80; j++)
                                        screen[i][j] = etatab[screen[i][j]];
				for(j=79; j>=0 && screen[i][j] == ' '; j--)
                                        screen[i][j] = '\0';
                        }
			for(i=21; i>=0; i--)
				if(screen[i][0] != '\0')
					break;
			for(j=0; j<=i; j++)
				printf("%.80s\n", screen[j]);
                }
        }
}

#include <errno.h>
char vmcf[] = "/dev/vmcf0";

vmcfopen(user, prot)
char *user;
{
	extern errno;
	int fd;

        do {
                fd = open(vmcf, 2);
                vmcf[9]++;
        } while(fd == -1 && errno == EBUSY);
	if(fd != -1) {
		ioctl(fd, VMCUSER, user);
		ioctl(fd, VMCPROT, prot);
	}
	return(fd);
}
