#include <stdio.h>
#include <ctype.h>
#include <errno.h>
#include <signal.h>

char *complex = "COMPLEX1";
char *job;

main(argc, argv)
int argc;
char **argv;
{
	int fd, parent, child, status, exit();
	extern errno;
	char line[100], cmd[132];

	if(argc > 3 || argc < 2) {
		fprintf(stderr, "Usage: st [ complex_id ] jobname\n");
		exit(1);
	}
	if(argc == 2)
		job = argv[1];
	else {
		complex = argv[1];
		job = argv[2];
	}
	upcase(job);
	upcase(complex);
	if((fd = smsgopen("rscs")) < 0) {
		fprintf(stderr, "Can't open /dev/smsg?\n");
		exit(1);
	}
	signal(SIGTERM, exit);
	signal(SIGINTR, 1);
	signal(SIGQUIT, 1);
	parent = getpid();
	child = fork();
	if(child == 0) {
		close(0);
		dup(fd);
		scan();
		exit(0);
	}

	sprintf(cmd, "sm rscs cmd %s $d'%s", complex, job);
	upcase(cmd);
	docp(cmd);
}

scan()
{
	char line[136], jid[10], cid[10], newcid[10], outlin[120];
	int catch();

	signal(SIGALRM, catch);
	alarm(60);

	while(fgets(line, 136, stdin) != NULL) {
		if(sscanf(line, " DMTCMX202E INVALID LINK %s", cid) > 0
			&& strcmp(cid, complex) == 0) {
			fprintf(stderr, "Invalid link %s.\n", complex);
			return;
		}
		if(sscanf(line, " DMTCMX303E LINK %s IS NOT ACTIVE", cid) > 0
			&& strcmp(cid, complex) == 0) {
			fprintf(stderr, "Link %s is not active.\n", complex);
			return;
		}
		if(sscanf(line, " DMTCMX310E LOCATION %s IS NOT DEFINED", cid) > 0
			&& strcmp(cid, complex) == 0) {
			fprintf(stderr, "Location %s is not defined.\n", complex);
			return;
		}
		if(sscanf(line, " DMTCMX320E LINK %s NOT CONNECTED", cid) > 0
			&& strcmp(cid, complex) == 0) {
			fprintf(stderr, "Link %s is not connected.\n", complex);
			return;
		}
		if(sscanf(line, " DMTCMX636I %s ROUTED THROUGH LINK %s", cid, newcid) > 0
			&& strcmp(cid, complex) == 0) {
			fprintf(stderr, "Can't use %s; use %s instead.\n", complex, newcid);
			return;
		}
		if(sscanf(line, " DMTCMX651I LINK %s INACTIVE", cid) > 0
			&& strcmp(cid, complex) == 0) {
			fprintf(stderr, "Link %s is inactive.\n", complex);
			return;
		}
		if(sscanf(line, " DMTRGX170I FROM%*c%[^:]:%[^\n]", cid, outlin) <= 0)
                        continue;
		if(strcmp(cid, complex)) continue;
		if(sscanf(outlin+19, " $HASP000 %s", jid) <= 0)
			continue;
		if(strcmp(jid, job)) continue;
		printf("%s\n", outlin);
		exit(0);
	}
}

catch()
{
	fprintf(stderr, "No status for '%s'\n", job);
	exit(1);
}

upcase(cp)
char *cp;
{
        while(*cp) {
                if(islower(*cp))
                        *cp = toupper(*cp);
                cp++;
        }
}

/*
 * Issue CP command, checking for errors and retrying if necessary.
 */
docp(cmd)
char *cmd;
{
	extern errno;
	int i;

	while((i = cpcmd(cmd)) < 0 && errno == 18) {
		fprintf(stderr, "Data error -- retrying.\n");
		sleep(1);
	}
	if(i < 0)
		fprintf(stderr, "R(%d)\n", errno);
}
