#include <stdio.h>
#include <pwd.h>

#define UNDEFINED 0
#define ATTACH    1
#define DETACH    2
#define FOUND     0
#define NOTFOUND  1
#define NOTYOURS  2
#define MAXTAPES  4
#define TAPEKILL  4

char tfname[] = "/dev/tape/lock18";
char name[10];
int silent;

/*
 * Tape spooler.
 * tape [-r -a -u][-c command][-d density][tape name]
 */
tape(argc, argv)
int argc;
char *argv[];
{
	int density = 1600;
	int ring = 0;
	int action = UNDEFINED;
	int k;

	char *command = NULL;
	char *p;
	char *getlogin();
	struct passwd *getpwuid();

	/*
	 * Check arguments.
	 */
	if(argc < 2) {
		fprintf(stderr, "Usage:  tape [-u] [-m -w -s -d density -c command ] volser\n");
		return(0);
	}
	while(--argc) {
		argv++;
		if(**argv == '-') {
			switch(*++*argv) {
			case 'w':
				ring++;
				break;
			case 'm':
				if(action == DETACH) {
					fprintf(stderr, "-m and -u are contradictory.\n");
					return(0);
				}
				action = ATTACH;
				break;
			case 's':
				silent++;
				break;
			case 'u':
				if(action == ATTACH) {
					fprintf(stderr, "-m and -u are contradictory.\n");
					return(0);
				}
				action = DETACH;
				break;
			case 'd':
				density = atoi(*++argv);
				argc--;
				switch(density) {
				case 800:
				case 1600:
				case 6250:
					break;
				default:
					fprintf(stderr ,"Tape: Bad density %d\n", density);
					return(0);
				}
				break;
			case 'c':
				command = *++argv;
				argc--;
				break;
			default:
				fprintf(stderr, "Unknown argument \"%s\".\n", *argv);
				return(0);
			}
		}
		else {
			if(*name != 0) {
				fprintf(stderr, "Multiple names '%s' and '%s'\n", name, *argv);
				return(0);
			}
			sprintf(name, "%s", *argv);
		}
	}
	if(*name == 0) {
		fprintf(stderr, "Tape: Error, No tape name specified. \n");
		return(0);
	}
	if(action == UNDEFINED) {
		fprintf(stderr, "Tape: Error, No action (-m or -u) defined. \n");
		return(0);
	}
	/*
	 * Two seperate things, one for detach, the other attach.
	 */
	if(action == DETACH) {
		k = remove(name);
		switch(k) {
		case FOUND:
			break;
		case NOTFOUND:
			fprintf(stderr, "Tape %s is not mounted.\n", name);
			break;
		case NOTYOURS:
			fprintf(stderr, "You do not own tape \"%s\" as mounted.\n", name);
			break;
		default:
			fprintf(stderr, "Cannot remove. Silly code = %d\n", k);
			break;
		}
		return(0);
	}
	if(ring && !density) {
		fprintf(stderr, "Tape: Density required when ring is used.\n");
		return(0);
	}
	p = getlogin();
	if(p == NULL)
		p = (getpwuid(getuid()))->pw_name;
	fprintf(stdout, "%s\n", name);
	fprintf(stdout, "%s\n", p);
	fprintf(stdout, "%d\n", density);
	fprintf(stdout, "%d\n", silent);
	fprintf(stdout, "%s\n", ring? "WITH" : "NO");
	fprintf(stdout, "%s\n", (command == NULL) ? "*" : command);
	return(1);
}

/*
 * Find the drive file with this Volser and remove it.
 * Also kill the daemon guarding the device.
 */

remove(who)
char *who;
{
	char tile[80];
	char tame[20];
	char owner[20];
	char *getlogin();
	char *log;
	struct passwd *getpwuid();
	FILE *fd;
	int  ct;
	int  daepid;

	for(ct=1; ct<=MAXTAPES; ct++) {
		sprintf(tile, "%s%x", tfname, ct);
		fd = fopen(tile, "r");
		if(fd != NULL) {
			fscanf(fd, "%s %s %d", tame, owner, &daepid);
			fclose(fd);
			if(strcmp(tame, who) == 0) {
				if (getuid() != 0) {
					log = getlogin();
					if(log == NULL)
						log = (getpwuid(getuid()))->pw_name;
					if(strcmp(owner, log) != 0)
						return(NOTYOURS);
				}
				unlink(tile);
				kill(daepid, TAPEKILL);
				return(FOUND);
			}
		}
	}
	return(NOTFOUND);
}
