CSW = 64
TRKCYL = 19
BLKTRK = 3
IOADDR = 186 / funny psw loc for ipl function
IOOPSW = 56
IONPSW = 120
CAW = 72
BLKSIZE = 4096
ISIZE = 64
L2ISIZE = 6
IPERBLK = BLKSIZE\/ISIZE
SAVEADDR = 192
SAVENAME = 196
blkno = 0
blist = 1
eblist = 2
iblist = 3
eiblist = 4
relblk = 4
nbytes = 5
blkind = 6
wkreg = 7
wkregevn = 8
wkregodd = 9
curb = 10
unit = 13

.csect  ipl
        balr    r12,0
        using   .,r12
        la      r15,dstg                 /base for storage dsect
	lr      r11,r15
	a       r11,f4096
        using   storage,r15,r11
        lh      unit,IOADDR            /get ipl device address
        la      r1,block
	a       r1,blksize
        st      r1,endblk
        la      r1,prompt
        stcm    r1,7,conscp+1
        la      r1,pathname
        stcm    r1,7,conscp+9
        xc      pathname(16),pathname
        xc      bb(8),bb
        la      r1,conscp               /set up for console i/o
        st      r1,CAW
csio:   sio     9                       /start console i/o
        bnz     csio
        la      r1,cwait
        st      r1,iopsw+4
        mvc     IONPSW(8),iopsw
        lpsw    waitpsw
cwait:
        la      wkreg,1                 /load error code
        cli     CSW+4,x'0c'             /test for proper dev/chan end
        bne     error
        tr      pathname(16),etatab     /translate ebcdic to ascii
/       we have pathname in pathname
        cli     pathname,x'2f'           /complete pathname?
        bne     1f
        mvc     pathname(15),pathname+1 /compress out slash
/set up disk channel program
1:      la      r1,bb                   /relocate channel pgm
        stcm    r1,7,cp+1
        stcm    r1,7,cp+9
        la      r1,cchhr
        stcm    r1,7,cp+17
        la      r1,cp+16
        stcm    r1,7,cp+25
        la      r1,iowait               /set up I/O int psw
        st      r1,iopsw+4
        mvc     IONPSW(8),iopsw
        la      r1,block
        stcm    r1,7,rdccw+1
        la      blkno,2                 /block number for root directory
        la      wkreg,cp                /set CAW for block i/o
        st      wkreg,CAW
        bal     r14,blkread             /read block
        mvc     i_node(ISIZE),block+ISIZE /get root directory inode(ino 2)
        sr      relblk,relblk           /relblk is relative block numbe   eg
/       note: root directory is assumed to have no indirect blocks
        sr      nbytes,nbytes
dirsrch:
	la      wkreg,i_addr(relblk)
        icm     blkno,7,0(wkreg)        /get block number
        bal     r14,blkread             /read block
        la      blkind,block            /set up block indexing
chkentry:
        clc     pathname(14),2(blkind)  /check directory entry
        be      gotdir
        la      nbytes,16(,nbytes)      /step byte counter
        la      blkind,16(,blkind)      /step index into block
        la      wkreg,6                 /load error
        c       nbytes,i_size           /eof?
        bnl     error                   /if so, give up
        c       blkind,endblk           /need another block?
        bl      chkentry                /not yet, so go back for next
        la      relblk,3(,relblk)       /get next block
        b       dirsrch
gotdir:
        /blkind points to directory entry
        lh      wkregodd,0(,blkind)     /get inode number of ipl file
        bctr    wkregodd,0              /convert to block no. and offset
        sr      wkregevn,wkregevn
        d       wkregevn,iperblk
        la      wkregodd,2(,wkregodd)
        /wkregodd has block no. that contains ipl file inode
        /wkregevn has inode number in that block
        sll     wkregevn,L2ISIZE        /convert to byte offset
        la      wkregevn,block(wkregevn)        /convert to address
        lr      blist,wkregevn          /save
        lr      blkno,wkregodd
        bal     r14,blkread             /read block
        mvc     i_node(ISIZE),0(blist)  /get inode from block
/
/       We now have the inode for the ipl file in core (in i_node)
/       The file can have at most one indirect block.
/
/       special first block processing.
/
        icm     blkno,7,i_addr         /get first block number.
        bal     r14,blkread            /get first block.
        l       nbytes,block+4         /pick up text size.
        a       nbytes,block+8         /add data size.
        a       nbytes,block+12        /add symbol table size. apt
        st      nbytes,i_size          /save bytes to be read in i_node
	sr      wkregevn,wkregevn       / move text to loc 0
	l       wkregodd,blkm32
	la      r0,block+32
	l       r1,blkm32
	mvcl    wkregevn,r0
        la      r1,cp                  /reset CAW to our chan pgm,
        st      r1,CAW                 / since we just zapped low core
        mvc     savpsw(8),IONPSW       /save UNIX psw
        mvc     IONPSW(8),iopsw        /insert our psw
        l       nbytes,blkm32          /initialize bytes read counter
        la      blist,i_addr+3         /set up list pointers for rdlist
        la      eblist,i_addr+27
        bal     r14,rdlist3            /read in next 9 blocks
/ read in the first indirect block
	sr      blkno,blkno
	icm     blkno,7,i_addr+30
        la      wkreg,iblock
        stcm    wkreg,7,rdccw+1        /point cp to indirect block buffer.
        bal     r14,blkread            /get first indirect block.
        la      wkreg,block            /point cp to block buffer.
        stcm    wkreg,7,rdccw+1
        la      blist,iblock           /point at indirect list beginning
	lr      eblist,blist            / and end
	a       eblist,blksize
        bal     r14,rdlist4            /read in the rest of the blocks
/
/       If we return here we have more than one indirect block
/
        la      wkreg,4                 /load error code
        b       error
/
/       Subroutines
/
rdlist4:
/
/       This routine reads in all the blocks in a list of 4 byte block numbers.
/       blist -> start of the list.
/       eblist -> the last entry in the list.
/
        st      r14,rdsave
        lr      curb,blist
read4:
        l       blkno,0(,curb)         /get next block number
        stcm    nbytes,7,rdccw+1       /set core address for block
        bal     r14,blkread            /read in block
        a       nbytes,blksize         /bump bytes read counter
        c       nbytes,i_size          /done?
        bl      1f
        mvc     IONPSW(8),savpsw       /restore UNIX iopsw
        st      unit,SAVEADDR           / save ipl addr
        mvc     SAVENAME(14),pathname   / save unix name
        lpsw    0                      /free at last!
1:      cr      curb,eblist            /end of list?
        be      rd3ret
        la      curb,4(,curb)          /bump list pointer
        b       read4
rd4ret:
        l       r14,rdsave
        br      r14
/
rdlist3:
/
/       This routine reads in all the blocks in a list of 3 byte block numbers.
/       blist -> start of the list.
/       eblist -> the last entry in the list.
/
        st      r14,rdsave
        lr      curb,blist
read3:
	sr      blkno,blkno
        icm     blkno,7,0(curb)        /get next block number
        stcm    nbytes,7,rdccw+1       /set core address for block
        bal     r14,blkread            /read in block
        a       nbytes,blksize         /bump bytes read counter
        c       nbytes,i_size          /done?
        bl      1f
        mvc     IONPSW(8),savpsw       /restore UNIX iopsw
        st      unit,SAVEADDR           / save ipl addr
        mvc     SAVENAME(14),pathname   / save unix name
        lpsw    0                      /free at last!
1:      cr      curb,eblist            /end of list?
        be      rd3ret
        la      curb,3(,curb)          /bump list pointer
        b       read3
rd3ret:
        l       r14,rdsave
        br      r14
/
/       This is the routine that reads in the blocks.
/       Desired block number is in register blkno.
/       Block zero is at cylinder 0, track 1, record 1.
blkread:
        lr      wkregodd,blkno
        sr      wkregevn,wkregevn
        d       wkregevn,blktrk
        la      wkregevn,1(,wkregevn)
        la      wkregodd,1(,wkregodd)
        stc     wkregevn,cchhr+4
        sr      wkregevn,wkregevn
        d       wkregevn,trkcyl
        sth     wkregevn,cchhr+2
        sth     wkregodd,cchhr
sio:    sio     0(unit)
        bnz     sio
lwait:  lpsw    waitpsw
/ CSW stored
iowait:
        la      wkreg,5                 /load error code
        tm      CSW+4,x'f3'             /Anything but chan end,dev end.
        bnz     error
        tm      CSW+5,x'ff'
        bnz     error
        tm      CSW+4,x'04'               /Device end?
        bz      lwait
        br      r14
/ all punts come hither
error:
        st      wkreg,errpsw+4
        lpsw    errpsw
/
/ data areas that are not altered (too much)
/
waitpsw:ds      0d
        dc      x'020a000000000000'
iopsw:
        dc      x'000c000000000000'
errpsw:
        dc      x'0002000000000000'
savpsw:
        ds      d
conscp:
        ccw     x'09',0,x'60',MSGLEN
        ccw     x'0a',0,x'60',14
        ccw     x'03',0,x'20',1
cp:
        ccw     x'07',0,x'40',6
        ccw     x'23',0,x'40',1
        ccw     x'31',0,x'40',5
        ccw     x'08',0,0,0
rdccw:
        ccw     x'06',0,0,BLKSIZE
prompt:
        dc      x'c595a3859940a2a8a2a3859440958194857a'
                / "Enter system name:" in EBCDIC
MSGLEN = 18
f4096:
	dc      f'4096'
blksize:
	dc      a(BLKSIZE)
blkm32:
	dc      a(BLKSIZE-32)
iperblk:
        dc      a(IPERBLK)
blktrk:
        dc      a(BLKTRK)
trkcyl:
        dc      a(TRKCYL)
endblk:
        ds      f
	ltorg
/ etatab.s 2/21/79
/ EBCDIC to ASCII translate table
etatab:
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'a'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'20'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'17'
	dc	x'2e'
	dc	x'3c'
	dc	x'28'
	dc	x'2b'
	dc	x'7c'
	dc	x'26'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'21'
	dc	x'24'
	dc	x'2a'
	dc	x'29'
	dc	x'3b'
	dc	x'7e'
	dc	x'2d'
	dc	x'2f'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'2c'
	dc	x'25'
	dc	x'5f'
	dc	x'3e'
	dc	x'3f'
	dc	x'0'
	dc	x'7e'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'60'
	dc	x'3a'
	dc	x'23'
	dc	x'40'
	dc	x'27'
	dc	x'3d'
	dc	x'22'
	dc	x'0'
	dc	x'61'
	dc	x'62'
	dc	x'63'
	dc	x'64'
	dc	x'65'
	dc	x'66'
	dc	x'67'
	dc	x'68'
	dc	x'69'
	dc	x'0'
	dc	x'7b'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'6a'
	dc	x'6b'
	dc	x'6c'
	dc	x'6d'
	dc	x'6e'
	dc	x'6f'
	dc	x'70'
	dc	x'71'
	dc	x'72'
	dc	x'0'
	dc	x'7d'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'7e'
	dc	x'73'
	dc	x'74'
	dc	x'75'
	dc	x'76'
	dc	x'77'
	dc	x'78'
	dc	x'79'
	dc	x'7a'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'5b'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'5b'
	dc	x'5c'
	dc	x'5d'
	dc	x'5e'
	dc	x'0'
	dc	x'7b'
	dc	x'41'
	dc	x'42'
	dc	x'43'
	dc	x'44'
	dc	x'45'
	dc	x'46'
	dc	x'47'
	dc	x'48'
	dc	x'49'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'7d'
	dc	x'4a'
	dc	x'4b'
	dc	x'4c'
	dc	x'4d'
	dc	x'4e'
	dc	x'4f'
	dc	x'50'
	dc	x'51'
	dc	x'52'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'5c'
	dc	x'0'
	dc	x'53'
	dc	x'54'
	dc	x'55'
	dc	x'56'
	dc	x'57'
	dc	x'58'
	dc	x'59'
	dc	x'5a'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'30'
	dc	x'31'
	dc	x'32'
	dc	x'33'
	dc	x'34'
	dc	x'35'
	dc	x'36'
	dc	x'37'
	dc	x'38'
	dc	x'39'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
	dc	x'0'
dstg:
        ds      0d

.dsect  storage
rdsave:
        ds      f
rdisave:
        ds      f
bb:
        ds      d
cchhr = bb + 2
pathname:
        ds      2d
i_node:
i_mode:
        ds      h
i_nlink:
        ds      h
i_uid:
        ds      h
i_gid:
        ds      h
i_size:
        ds      f
i_addr:
        ds      10f
i_fil:
        ds      3f
block:
        ds      4096c
iblock:
        ds      4096c
        end
