/* t.h:  external declarations
 * t0.c: storage allocation
 * t1.c: main control and input switching
 * t2.c: subroutine sequencing for one table
 * t3.c: interpret commands affecting whole table
 * t4.c: read table specification
 * t5.c: read data for table
 * t6.c: compute tab stops
 * t7.c: control to write table entries
 * t8.c: write out one line of output table
 * t9.c: write lines for tables over 200 lines
 * tb.c: check which entries exist, also storage allocation
 * tc.c: find character not in table to delimit fields
 * te.c: error message control, input line count
 * tf.c: save and restore fill mode around table
 * tg.c: process included text blocks
 * ti.c: classify line intersections
 * tm.c: split numerical fields
 * ts.c: minor string processing subroutines
 * tt.c: subroutines for drawing horizontal lines
 * tu.c: draws horizontal lines
 * tv.c: draw vertical lines
 */
# include "stdio.h"
# include "ctype.h"

# define MAXLIN 200
# define MAXHEAD 30
# define MAXCOL 20
# define MAXCHS 2000
# define MAXRPT 100
# define CLLEN 10
# define SHORTLINE 4
extern int nlin, ncol, iline, nclin, nslin;
extern int style[MAXHEAD][MAXCOL];
extern int ctop[MAXHEAD][MAXCOL];
extern char font[MAXHEAD][MAXCOL][2];
extern char csize[MAXHEAD][MAXCOL][4];
extern char vsize[MAXHEAD][MAXCOL][4];
extern char cll[MAXCOL][CLLEN];
extern int stynum[];
extern int F1, F2;
extern int lefline[MAXHEAD][MAXCOL];
extern int fullbot[];
extern char *instead[];
extern int expflg;
extern int ctrflg;
extern int evenflg;
extern int evenup[];
extern int boxflg;
extern int dboxflg;
extern int linsize;
extern int tab;
extern int lower;
extern int pr1403;
extern int linsize, delim1, delim2;
extern int allflg;
extern int textflg;
extern int left1flg;
extern int rightl;
struct colstr {char *col, *rcol;};
extern struct colstr *table[];
extern char *cspace, *cstore;
extern char *exstore, *exlim;
extern int sep[];
extern int used[], lused[], rused[];
extern int linestop[];
extern int leftover;
extern char *last, *ifile;
extern int texname;
extern int texct, texmax;
extern char texstr[];
extern int linstart;


extern FILE *tabin, *tabout;
# define CRIGHT 80
# define CLEFT 40
# define CMID 60
# define S1 31
# define S2 32
# define TMP 38
# define SF 35
# define SL 34
# define LSIZE 33
# define SIND 37
# define SVS 36
/* this refers to the relative position of lines */
# define LEFT 1
# define RIGHT 2
# define THRU 3
# define TOP 1
# define BOT 2
