%term INTERACT OPEN LDEV PVM INPUT MOVEMENT EDIT AID DATA ENTER ERROR
%{
char *ifn, databuf[200], *datap;
int lineno;
%}
%%
pgm:            input_list
;
input_list:     input_list input
|               input
;
input:          INPUT commands AID ';'  { printf("doinput(%d);}\n", $3); }
|               INPUT commands ';'      { printf("}\n"); }
|               OPEN LDEV ';'           { printf("ldopen();}\n"); }
|               OPEN PVM ';'            { printf("pvmopen(\"\");}\n"); }
|               OPEN PVM DATA ';'       { printf("pvmopen(%s);}\n", databuf); }
|               INTERACT ';'            { printf("interact();}\n"); }
|               error ';'
;
commands:       commands command
|               /* empty */
;
command:        DATA            { printf("inputtxt(%s);", databuf); }
|               MOVEMENT        { printf("domove(%d);", $1); }
|               EDIT            { printf("doedit(%d);", $1); }
;
%%
#include <stdio.h>
#include <ctype.h>
#include <tcl/3270.h>
#include <tcl/keyboard.h>

struct kwtab {
	char    *kword;
	int     type;
	int     val;
} kwtab[] = {
	"data",    DATA, 0,
	"input",   INPUT, 0,
	"open",    OPEN,  0,
	"interact", INTERACT, 0,
	"ldev",    LDEV,  0,
	"pvm",     PVM,   0,
	"enter",   AID, ENTER,
	"clear",   AID, CLEAR,
	"testreq", AID, TESTREQ,
	"pa1",     AID, PA1,
	"pa2",     AID, PA2,
	"pf1",     AID, PF1,
	"pf2",     AID, PF2,
	"pf3",     AID, PF3,
	"pf4",     AID, PF4,
	"pf5",     AID, PF5,
	"pf6",     AID, PF6,
	"pf7",     AID, PF7,
	"pf8",     AID, PF8,
	"pf9",     AID, PF9,
	"pf10",    AID, PF10,
	"pf11",    AID, PF11,
	"pf12",    AID, PF12,
	"up",      MOVEMENT,    M_UP,
	"down",    MOVEMENT,    M_DOWN,
	"left",    MOVEMENT,    M_LEFT,
	"right",   MOVEMENT,    M_RIGHT,
	"tab",     MOVEMENT,    M_FORW,
	"forward", MOVEMENT,    M_FORW,
	"backtab", MOVEMENT,    M_BACK,
	"back",    MOVEMENT,    M_BACK,
	"backward",MOVEMENT,    M_BACK,
	"newline", MOVEMENT,    M_NL,
	"einput",  EDIT,        E_EINPUT,
	"eeof",    EDIT,        E_EEOF,
	0,
};

yylex()
{
	static ininput = 0;
	static char line[255], *lp;
	char word[20], *wp;
	struct kwtab *k;

	if(ininput) {
		while(isspace(*lp)) lp++;
		if(*lp == '\0') {
			yyerror("no semi-colon on input stmt");
			lp = &";";
			return(ERROR);
		}
		if(*lp == ';') {
			ininput = 0;
			return(';');
		}
		wp = word;
		while(isalnum(*lp)) {
			if(isupper(*lp))
				*wp++ = tolower(*lp++);
			else
                                *wp++ = *lp++;
		}
		*wp = 0;
		wp = word;
		if(*wp == 0) {
			if(*lp == '"' || *lp == '(')
				strcpy(word, "data");
			else {
                                yyerror("keyword not found when expected");
                                return(ERROR);
			}
		}
		for(k=kwtab; k->kword!=NULL; k++)
		if(strcmp(word, k->kword) == 0) {
			yylval = k->val;
			switch(k->type) {
			case DATA:
				lp = getdata(lp);
				if(lp == NULL) {
					lp = &";";
					return(ERROR);
				}
				break;
			}
			return(k->type);
		}
		yyerror("unknown keyword");
		return(ERROR);
	}
	while(gets(line) != NULL) {
		lineno++;
		lp = line;
		while(isspace(*lp)) lp++;
		if(*lp == '$') {
			ininput = 1;
			for(wp=line; wp!=lp; wp++) putchar(*wp);
			lp++;
			printf("{ ");
			return(yylex());
		}
		puts(line);
	}
	return(0);
}

yyerror(s)
char *s;
{
	fprintf(stderr, "%s line %d: %s\n", ifn, lineno, s);
}

char *getdata(s)
char *s;
{
	char *copyg();

        while(isspace(*s)) s++;
	datap = databuf;
	if(*s == '\0' || (*s != '(' && *s != '"')) {
		yyerror("data not properly delimited");
		return(NULL);
	}
	if(*s == '(')
                s = copyg(s, ')');
	else
		s = copyg(s, '"');
	*datap = 0;
	return(s);
}

char *copyg(s, c)
char *s, c;
{
	*datap++ = *s++;
	while(s != NULL && *s != c) switch(*s) {

        case '(':
                if(c == ')')
                        s = copyg(s, ')');
                else
                        *datap++ = *s++;
                break;

        case '\\':
                if(c != ')')
                        *datap++ = *s++;
                *datap++ = *s++;
                break;

	case '"':
		if(c == ')')
			s = copyg(s, '"');
		else
			*datap++ = *s++;
		break;

	case '\'':
		if(c == ')')
			s = copyg(s, '\'');
		else
			*datap++ = *s++;
		break;

	case '\0':
		yyerror("missing data delimiter");
		return(NULL);
		break;

        default:
                *datap++ = *s++;
                break;
        }
        *datap++ = *s++;
	return(s);
}

main(argc, argv)
char **argv;
{
	char ofn[100], *rindex(), *cp1, *cp2;

	while(--argc) {
		ifn = *++argv;
		cp1 = rindex(ifn, '/');
		if(cp1 == NULL)
			cp1 = ifn;
		else
			cp1++;
		cp2 = ofn;
		while(*cp1 && *cp1 != '.')
			*cp2++ = *cp1++;
		*cp2 = '\0';
		if(strcmp(cp1, ".tcl") != 0) {
			fprintf(stderr, "%s: not a .tcl file\n", ifn);
			continue;
		}
		strcat(ofn, ".c");
		if(freopen(ifn, "r", stdin) == NULL) {
			fprintf(stderr, "%s: cannot open\n", ifn);
			continue;
		}
		if(freopen(ofn, "w", stdout) == NULL) {
			fprintf(stderr, "%s: cannot create\n", ofn);
			continue;
		}
		printf("#include <tcl/tcldefs.h>\n");
		printf("#line 1 \"%s\"\n", ifn);
		lineno = 0;
		yyparse();
	}
}
