/* time command */

#include <stdio.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/times.h>
#include <sys/timeb.h>

extern int errno;
extern char *sys_errlist[];

main(argc, argv)
char **argv;
{
	struct tms buffer, obuffer;
	struct timeb timeb;
	int status;
	register p;
	long before, after;

	if(argc<=1)
		exit(0);
	ftime(&timeb);
	before = 1000000L*timeb.time + 1000*timeb.millitm;
	p = fork();
	if(p == -1) {
		fprintf(stderr, "Try again.\n");
		exit(1);
	}
	if(p == 0) {
		execvp(argv[1], &argv[1]);
		fprintf(stderr, "%s: %s\n", argv[1], sys_errlist[errno]);
		exit(1);
	}
	signal(SIGINT, SIG_IGN);
	signal(SIGQUIT, SIG_IGN);
	times(&obuffer);
	while(wait(&status) != p)
		times(&obuffer);
	ftime(&timeb);
	after = 1000000L*timeb.time + 1000*timeb.millitm;
	if((status&0377) != 0)
		fprintf(stderr,"Command terminated abnormally.\n");
	times(&buffer);
	fprintf(stderr,"\n");
	printt("real", after-before);
	printt("user", buffer.tms_cutime - obuffer.tms_cutime);
	printt("sys ", buffer.tms_cstime - obuffer.tms_cstime);
	exit(status>>8);
}

printt(s, a)
char *s;
long a;
{
	fprintf(stderr, "%s\t%8.03f\n", s, (double)a/1000000.);
}
