/*
*  Look at the data in an accounting summary file
*
*  Synopsis: acctvw dayfile
*  Example:  acctvw 79064
*/
#include <stdio.h>
#include <pwd.h>
#include "/usr/src/cmd/accounting/acct.h"
#include <sys/acctfile.h>

struct aday aday[MAXUSERS];
struct cmds cmds[MAXCMDS];
int  lotime, hitime;
char dayfile[30];

#define BYTEPWD 4

main(argc, argv)
char **argv;
{
	if (argc != 2) {
		printf("arg count\n");
		exit(1);
	}
	sprintf(dayfile, daymodel, atoi(argv[1]));
	init();
	output();
}


/*
* init : reads in the "aday" data.
*/
init()
{
	int  n, users;
        FILE *tfd;

	if ((tfd = fopen(dayfile, "r"))==NULL) {
		printf("Couldn't open %s\n", dayfile);
		exit(1);
	}

	lotime = getw(tfd);
	hitime = getw(tfd);
	users  = getw(tfd);
	if (lotime==EOF || hitime==EOF || users==EOF) {
		fclose(tfd);
		printf("Problems reading %s\n", dayfile);
		return;
	}
	fread ((char *)aday, sizeof(*aday), users, tfd);
	while ((n = getw(tfd)) != EOF)
		fread((char *)&cmds[n], sizeof *cmds, 1, tfd);
	fclose(tfd);
}

struct passwd *pw;
struct passwd *getpwuid();

/*
*  output: prints the data out
*/
output()
{
	int  n;
	char *name;
	char *ctime();

	printf("lotime = %s", ctime(lotime));
	printf("hitime = %s\n", ctime(hitime));

	for (n=0; n<MAXUSERS; n++) {
	if (aday[n].ublk>0  ||  aday[n].scpu>0 || aday[n].ucpu>0
	||  aday[n].uconn>0  || aday[n].nocmd>0) {
	        if ((pw=getpwuid(n)) == 0)
			name = "?";
	        else
			name = pw->pw_name;
		printf("%s\tcmds=%-8d cpu=%-12d i/o=%-8d conn=%-8d\n",
			name,aday[n].nocmd,aday[n].scpu+aday[n].ucpu,
			aday[n].uio,aday[n].uconn);
		printf("\tread=%-8d pun=%-12d prt=%-8d blks=%-8d\n",
		aday[n].rread,aday[n].rpun,aday[n].rprt,aday[n].ublk);
	}
	}
	printf("\n\n");
	for (n=0; n<MAXCMDS; n++)
		if (cmds[n].count > 0)
			printf("%-12s count=%-4d real=%-6d cpu=%-10d i/o=%-6d\n",
			cmds[n].name, cmds[n].count, cmds[n].realt,
			cmds[n].cput+cmds[n].syst, cmds[n].io);
}
