/*
 * Add the contents of a directory to a tar tape.
 * File names beginning with `.' are ignored.
 *
 * If the tape is virgin (although all are sleazy)
 * then start it fresh.
 * If a tape fills, start a new one.
 *
 * archdaily
 *
 */
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/dir.h>

#define LOW_BYTE 0x0f

FILE *fptfn;
FILE *fpix;

struct stat statstuf;
struct direct files;

char index[] = "/usr/spool/arch/.index";
char tapes[] = "/usr/spool/arch/.tapes";
char tempcut[] = "/usr/spool/arch/.tempcut";
char totell[] = "backup";
char message[256];
char filename[20];
char volser[10];
char *tfn;
extern char *cmdname;

int tapestate;

main(argc, argv)
int argc;
char *argv[];
{
	FILE *fp;
	char *rindex();

	chdir("/usr/spool/arch");
	if((fpix = fopen(index, "a")) == NULL) {
		sprintf(message, "%s: Cannot open %s\n", cmdname, index);
		notify(totell, message, 0);
		exit(1);
	}
	if(argc != 1) {
		sprintf(message, "%s: No args to %s\n", cmdname, cmdname);
		notify(totell, message, 0);
		exit(1);
	}
	tfn = tapes;
        if((fp=fopen(".", "r")) == NULL) {
                sprintf(message, "%s: Cannot open directory\n", cmdname);
		notify(totell, message, 0);
                exit(2);
        }
        while(fread((char *) &files, 1, sizeof(struct direct), fp)==sizeof(struct direct)) {
                if(files.d_ino == 0)
                        continue;
                if(files.d_name[0] == '.')
                        continue;
                strncpy(filename, files.d_name, DIRSIZ);
                stat(filename, &statstuf);
                if((statstuf.st_mode & S_IFDIR) == 0)
                        feather(filename);
	}
        fclose(fp);
	down();
	exit(0);
}

/*
 * free up tape
 */
down()
{
	char cd[256];

        if(tapestate) {
                sprintf(cd, "/bin/tape -u %s", volser);
                system(cd);
        }
        return;
}

/*
 * Use tar to put this file on a tape.
 */
feather(name)
char *name;
{
	char cmd[256];
	char mes[256];
	int  back;
	int  from;

        if(!tapestate) {
                if((fptfn=fopen(tfn, "r")) == NULL) {
                        sprintf(message, "%s: Cannot open tape name file\n", cmdname);
                        notify(totell, message, 0);
                        exit(4);
                }
		if(newtape()) {
                        sprintf(message, "%s: No usable tape found in %s\n", cmdname, tfn);
                        notify(totell, message, 0);
                        exit(5);
                }
		tapestate = 1;
        }
        /*
         * invoke tar.
         */
	back = 0;
        do {
                sprintf(cmd, "/bin/tar r %s %s", volser, name);
                if((from = (system(cmd) >> 8) & LOW_BYTE) == 0)
                        break;
		sprintf(mes, "%s: %s exit code %d", cmdname, cmd, from);
		notify(totell, mes, 0);
        } while((back=newtape()) == 0);
	if(back) {
                sprintf(message, "%s: No usable tape found in %s\n", cmdname, tfn);
                notify(totell, message, 0);
                exit(5);
        }
	fprintf(fpix, "%s %s\n", name, volser);
	unlink(name);
	return;
}


/*
 * get top tape mounted.
 */
newtape()
{
	FILE *popen();
        FILE *fped;
	char *rindex();
	char mand[256];
	char *nl;
	int  fdtar;
	int  back;

	if(tapestate) {
		down();
		fseek(fptfn, 0, 0);
		fped = fopen(tempcut, "w");
		if(fped == NULL) {
			sprintf(message, "%s: cannot open temp file %s\n", cmdname, tempcut);
                        notify(totell, message, 0);
			return(-1);
		}
		/*
		 * Remove the first line from the file.
		 */
                if(fscanf(fptfn, "%s", volser) != 1) {
			sprintf(message, "%s: archiver is out of tapes", cmdname);
			notify(totell, message, 0);
                        return(-1);
		}
		/*
		 * If the next line is empty, then out of tapes as well.
		 */
                if(fscanf(fptfn, "%s", volser) != 1) {
			sprintf(message, "%s: archiver is out of tapes", cmdname);
			notify(totell, message, 0);
                }
		else {
			do
				fprintf(fped, "%s", cmdname, volser);
                        while(fscanf(fptfn, "%s", volser) == 1);
		}
		fclose(fped);
		fclose(fptfn);
		unlink(tfn);
		link(tempcut, tfn);
		unlink(tempcut);
		fptfn = fopen(tfn, "r");
		if(fptfn == NULL) {
			sprintf(message, "%s: cannot reopen tape file\n", cmdname);
                        notify(totell, message, 0);
			return(-1);
		}
	}
        if(fscanf(fptfn, "%s", volser) != 1)
                return(-1);
        if((nl=rindex(volser, '\n')) != NULL)
                *nl = 0;
        sprintf(mand, "/bin/tape -m -w -s -d 6250 %s", volser);
        back = system(mand);
        if(((back >> 8) & LOW_BYTE) != 0) {
                sprintf(message, "%s: %s failed", cmdname, mand);
                notify(totell, message, 0);
                return(-1);
        }
        sprintf(mand, "/dev/tape/%s", volser);
        while((fdtar=open(mand, 0)) < 0) {
                sleep(5);
	}
	close(fdtar);
	if(tapestate) {
		sprintf(mand, "/bin/label %s", volser);
		back = system(mand);
		if(((back >> 8) & LOW_BYTE) != 0) {
			sprintf(message, "%s: %s failed", cmdname, mand);
			notify(totell, message, 0);
			return(-1);
		}
		sprintf(mand, "/bin/tar c %s /usr/spool/arch/.today", volser);
		back = system(mand);
		if(((back >> 8) & LOW_BYTE) != 0) {
			sprintf(message, "%s: %s failed", cmdname, mand);
			notify(totell, message, 0);
			return(-1);
		}
	}
	return(0);
}
