/*
 * p/n:
 * Program name:    Dump Formatter header
 * Author:          Alan Ballard
 * Backup:
 *
 * Description:
 *    This file contains the header for common definitions of the
 *    various pieces of the dump formatter.
 *
 */

/*
 *  Some constants used in tree nodes (must be distinct from
 *  terminal symbols).
 */
#define ADDREXPR 1000
#define TABLE 1001
#define ARR 1002
#define DEV 1003

/*
 *  redefine some names if it is used with omak (so they don't conflict
 *  with kernel, other pieces of omak, or cause /libc stuff to
 *  be included.)
 */
#ifdef OMAKDUMP
#define printf omakprintf
#define fprintf omakfprintf
#define stacktrace printstack
#define tubitab omakitab
/*  getblk is trivial with omak  */
#define getblk(addr,n) addr
#endif

/*
 * The following enumeration type defines codes for the various
 * structures known to the dump formatter.  These are used
 * in "typing" the addresses being passed around between procedures.
 *
 * Note that nonecode must be last.
 */
enum structcode {bufcode, chancode, coretabcode, cucode, dasdcode,
    filecode, inodecode, ioqcode, mountcode, proccode, textcode,
    ttycode, tubecode, unitcode, usercode, commandcode, activecode,
    stackcode,
    nonecode};

/*
 *  The following are used to keep track of I/O unit addresses so that
 *  they can be accessed by the format routines for inclusion in the
 *  printout (the unit address cannot be determined from the
 *  structures).
 */

int     io_chan, io_cu, io_unit;

