# include "stdio.h"
# define U(x) x
# define NLSTATE yyprevious=YYNEWLINE
# define BEGIN yybgin = yysvec + 1 +
# define INITIAL 0
# define YYLERR yysvec
# define YYSTATE (yyestate-yysvec-1)
# define YYOPTIM 1
# define YYLMAX 200
# define output(c) putc(c,yyout)
# define input() (((yytchar=yysptr>yysbuf?U(*--yysptr):getc(yyin))==10?(yylineno++,yytchar):yytchar)==EOF?0:yytchar)
# define unput(c) {yytchar= (c);if(yytchar=='\n')yylineno--;*yysptr++=yytchar;}
# define yymore() (yymorfg=1)
# define ECHO fprintf(yyout, "%s",yytext)
# define REJECT { nstr = yyreject(); goto yyfussy;}
int yyleng; extern char yytext[];
int yymorfg;
extern char *yysptr, yysbuf[];
int yytchar;
FILE *yyin ={stdin}, *yyout ={stdout};
extern int yylineno;
struct yysvf { 
	struct yywork *yystoff;
	struct yysvf *yyother;
	short *yystops;};
struct yysvf *yyestate;
extern struct yysvf yysvec[], *yybgin;
/*
 * p/n:
 * Program Name:       Dump Formatter lexical scanner
 * Author:             Alan Ballard
 * Backup:
 *
 * Description:
 *    This component contains the LEX input for scanning input requests.
 */
# define PFILEN 2
# define PSHCMD 4
# define FORMAT 6
#include "y.tab.h"
#include "dump.h"

#define input getinput

extern int      yylval;       /* value of hex string */
int             aptnum;       /* value of decimal string */
int             cmdecho = 0;  /* flag for whether to echo input */
char            binsh[] = "/bin/sh -i";

# define YYNEWLINE 10
yylex(){
int nstr; extern int yyprevious;
 /*
  * Shell command (in appropriate context).  Takes rest of line.
  */
while((nstr = yylook()) >= 0)
yyfussy: switch(nstr){
case 0:
if(yywrap()) return(0); break;
case 1:
     {
                       if (yyleng > 1) {
                                yylval = calloc(yyleng+1,1);
                                strcpy(yylval, yytext);
			} else
                                yylval = 0;
                        BEGIN 0;        /* return to normal scanning */
                        return(REM);
                     }
break;
case 2:
  {
                     BEGIN PSHCMD;
                     return('!');
}
break;
 /*
  * newlines, blanks, etc.
  */
case 3:
                 ;
break;
case 4:
       return('\n');
break;
case 5:
                  ;
break;
case 6:
             {         /* comments */
                           yylval = calloc(yyleng-1, 1);
                           strcpy(yylval, yytext+2);
                           return(COMMENT);
                        }
break;
 /*
  * Filenames (in appropriate context).
  */
case 7:
  { if (yyleng > 0) {
                               yylval = calloc(yyleng+1,1);
                               strcpy(yylval, yytext);
                           } else
                               yylval = 0;
                           BEGIN 0;        /* return to normal scanning */
                           return(FILENAME);
                        }
break;
 /*
  * Reserved words for format command operands (but only in
  * appropriate context)
  */
case 8:
           return(USER);
break;
case 9:
            return(TTY);
break;
case 10:
            return(BUF);
break;
case 11:
        return(CORETAB);
break;
case 12:
           return(TEXT);
break;
case 13:
            return(IOQ);
break;
case 14:
           return(DASD);
break;
case 15:
           return(PROC);
break;
case 16:
         return(ACTIVE);
break;
case 17:
            return(UID);
break;
case 18:
            return(PID);
break;
case 19:
         return(PGROUP);
break;
case 20:
           return(CHAN);
break;
case 21:
             return(CU);
break;
case 22:
           return(UNIT);
break;
case 23:
          return(INODE);
break;
case 24:
           return(TUBE);
break;
case 25:
           return(FILSTRUC);
break;
case 26:
          return(MOUNT);
break;
case 27:
        return(COMMAND);
break;
case 28:
          return(STACK);
break;
 /*
  * Symbol (as long as not picked up by reserved word above)
  */
case 29:
{
                           yylval = calloc(yyleng+1,1);
                           strcpy(yylval,yytext);
                           return(SYMBOL);
                        }
break;
 /*
  * Number (when not matched above).  Interprets as both
  * hex and decimal.
  */
case 30:
         { yylval = tobinary(yytext,16);
                           aptnum = tobinary(yytext,10);
                           return(NUMBER);
                        }
break;
 /*
  * Reserved words for command names
  */
case 31:
                   return(MEM);
break;
case 32:
                  return(ADDR);
break;
case 33:
                return(FORM);
break;
case 34:
                  return(0);
break;
case 35:
                 return(PRINT);
break;
 /*
  * Any other single character (operators, parens)
  */
case 36:
                      return(yytext[0]);
break;
case -1:
break;
default:
fprintf(yyout,"bad switch yylook %d",nstr);
} return(0); }
/* end of yylex */
/*
 *  tobinary converts the specified hex or decimal string to a binary
 *  integer.
 */
tobinary(st, b)
char *st;               /* the string to convert */
register int b;         /* the base (10 or 16) */
{
	register int n, c;
	register char *s;
	int t;

	n = 0;
	s = st;
        while (c = *s++) {
		if (c >= '0' && c <= '9') t = c-'0';
		else if (b == 16 && c >= 'a' && c <= 'f') t = c-'a'+10;
		else if (b == 16 && c >= 'A' && c <= 'F') t = c-'A'+10;
		else {
                        /* error(0, "Illegal number"); */
                        /* gobble(); */
                        return(-1);
                }
		n = n*b+t;
        }
	return(n);
}

/*
 *  The following group of functions may be called from the parser
 *  to set the start condition.  This is done to control what strings
 *  are recognized as reserved words vs symbols.
 */

strtsh()                /* start a shell cmd */
{
  BEGIN PSHCMD;
}

endshell()                /* end a shell cmd */
{
  BEGIN 0;
}

strtfn()                /* start a file name */
{
  BEGIN PFILEN;
}

strtform()              /* start format command reserved words */
{
  BEGIN FORMAT;
}

strtnorm()              /* start normal (no reserved symbols) */
{
  BEGIN 0;
}

/*
 *  getinput obtains the next input character.  It is a version of
 *  the default LEX input routine, modified to echo the input if
 *  the echo switch is on.
 */
getinput()
{
        if (yysptr > yysbuf)
                yytchar = U(*--yysptr);
        else {
                yytchar = getc(yyin);
                if (cmdecho)
                        putchar(yytchar);
        }
        if (yytchar == 10)
                yylineno++;
        if (yytchar == EOF)
                return(0);
        return (yytchar);
}

/*
 *  gobble flushes input characters to end-of-line
 */
gobble()
{
        register int c;
        while ((c = input()) != '\n' && c != EOF)
                ;
        unput('\n');
}
short yyvstop[] ={
0,

1,
0,

1,
0,

1,
0,

1,
0,

1,
0,

1,
0,

1,
0,

1,
0,

36,
0,

5,
36,
0,

4,
0,

2,
36,
0,

29,
36,
0,

36,
0,

30,
36,
0,

36,
0,

29,
30,
36,
0,

36,
0,

7,
36,
0,

2,
7,
36,
0,

7,
29,
36,
0,

7,
36,
0,

7,
30,
36,
0,

7,
36,
0,

7,
29,
30,
36,
0,

7,
36,
0,

1,
36,
0,

1,
5,
36,
0,

1,
2,
36,
0,

1,
29,
36,
0,

1,
36,
0,

1,
30,
36,
0,

1,
36,
0,

1,
29,
30,
36,
0,

1,
36,
0,

29,
30,
36,
0,

29,
30,
36,
0,

29,
30,
36,
0,

29,
30,
36,
0,

29,
30,
36,
0,

29,
36,
0,

29,
36,
0,

29,
36,
0,

29,
36,
0,

29,
36,
0,

29,
36,
0,

29,
0,

6,
0,

30,
0,

29,
30,
0,

3,
0,

7,
0,

7,
29,
0,

6,
7,
0,

7,
30,
0,

7,
0,

7,
0,

7,
0,

7,
0,

7,
0,

7,
29,
30,
0,

1,
0,

1,
29,
0,

1,
6,
0,

1,
30,
0,

1,
0,

1,
0,

1,
0,

1,
0,

1,
0,

1,
29,
30,
0,

29,
30,
0,

29,
0,

29,
0,

29,
0,

21,
29,
0,

29,
30,
0,

29,
0,

29,
0,

29,
0,

29,
0,

29,
0,

29,
0,

29,
0,

29,
0,

29,
0,

29,
0,

29,
0,

29,
0,

29,
0,

29,
0,

7,
0,

7,
0,

7,
0,

7,
0,

7,
0,

1,
0,

1,
0,

1,
0,

1,
0,

1,
0,

29,
0,

10,
29,
0,

29,
0,

29,
0,

29,
0,

29,
0,

29,
0,

29,
0,

13,
29,
0,

29,
0,

29,
0,

18,
29,
0,

29,
0,

29,
0,

29,
0,

9,
29,
0,

29,
0,

17,
29,
0,

29,
0,

29,
0,

31,
0,

7,
0,

7,
0,

7,
31,
0,

7,
0,

7,
0,

1,
0,

1,
0,

1,
31,
0,

1,
0,

1,
0,

29,
0,

20,
29,
0,

29,
0,

29,
0,

14,
29,
0,

25,
29,
0,

29,
0,

29,
0,

29,
0,

15,
29,
0,

29,
0,

12,
29,
0,

24,
29,
0,

22,
29,
0,

8,
29,
0,

32,
0,

34,
0,

7,
32,
0,

7,
0,

7,
0,

7,
34,
0,

1,
32,
0,

1,
0,

1,
0,

1,
34,
0,

29,
0,

29,
0,

29,
0,

23,
29,
0,

26,
29,
0,

29,
0,

28,
29,
0,

35,
0,

7,
0,

7,
35,
0,

1,
0,

1,
35,
0,

16,
29,
0,

29,
0,

29,
0,

19,
29,
0,

33,
0,

7,
33,
0,

1,
33,
0,

27,
29,
0,

11,
29,
0,
0};
# define YYTYPE short
struct yywork { YYTYPE verify, advance; } yycrank[] ={
0,0,	0,0,	1,9,	0,0,	
0,0,	0,0,	3,19,	0,0,	
0,0,	0,0,	1,10,	1,11,	
18,56,	28,0,	29,0,	35,56,	
0,0,	0,0,	0,0,	67,0,	
71,0,	0,0,	4,19,	20,0,	
20,0,	0,0,	31,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	1,12,	72,0,	
2,12,	1,13,	3,20,	0,0,	
0,0,	3,21,	1,9,	5,27,	
14,48,	0,0,	20,0,	30,0,	
1,14,	1,15,	2,14,	5,28,	
3,22,	3,23,	4,20,	20,0,	
74,0,	4,21,	31,69,	6,27,	
1,16,	73,0,	2,16,	0,0,	
3,24,	0,0,	1,17,	6,28,	
4,22,	4,23,	3,25,	0,0,	
0,0,	30,68,	32,0,	5,29,	
0,0,	0,0,	5,30,	7,9,	
4,24,	0,0,	8,12,	5,27,	
75,0,	30,68,	4,25,	7,10,	
7,11,	5,31,	5,32,	6,29,	
0,0,	1,18,	6,30,	2,18,	
8,14,	3,26,	0,0,	6,27,	
70,0,	5,33,	30,68,	50,97,	
52,99,	6,31,	6,32,	5,34,	
8,16,	0,0,	71,107,	7,12,	
32,70,	4,26,	7,13,	16,50,	
42,86,	6,33,	44,90,	7,9,	
16,51,	26,0,	26,56,	6,34,	
51,98,	7,14,	7,15,	16,52,	
53,100,	32,70,	16,53,	16,54,	
41,84,	41,85,	5,35,	54,101,	
72,108,	7,16,	70,70,	22,0,	
22,0,	8,18,	78,113,	7,17,	
26,0,	79,114,	8,36,	8,37,	
8,38,	8,39,	6,35,	8,40,	
73,109,	26,0,	8,41,	70,70,	
83,118,	43,87,	8,42,	43,88,	
74,110,	8,43,	22,0,	84,119,	
8,44,	8,45,	8,46,	85,120,	
43,89,	46,94,	7,18,	22,0,	
22,59,	45,91,	46,95,	7,36,	
7,37,	7,38,	7,39,	46,96,	
7,40,	80,115,	86,121,	7,41,	
13,47,	87,122,	80,116,	7,42,	
45,92,	45,93,	7,43,	75,111,	
88,123,	7,44,	7,45,	7,46,	
13,47,	13,47,	13,47,	13,47,	
13,47,	13,47,	13,47,	13,47,	
13,47,	13,47,	89,124,	90,125,	
91,126,	92,127,	93,128,	94,129,	
13,47,	13,47,	13,47,	13,47,	
13,47,	13,47,	13,47,	13,47,	
13,47,	13,47,	13,47,	13,47,	
13,47,	13,47,	13,47,	13,47,	
13,47,	13,47,	13,47,	13,47,	
13,47,	13,47,	13,47,	13,47,	
13,47,	13,47,	13,47,	95,130,	
96,131,	97,132,	98,133,	13,47,	
99,134,	13,47,	13,47,	13,47,	
13,47,	13,47,	13,47,	13,47,	
13,47,	13,47,	13,47,	13,47,	
13,47,	13,47,	13,47,	13,47,	
13,47,	13,47,	13,47,	13,47,	
13,47,	13,47,	13,47,	13,47,	
13,47,	13,47,	13,47,	15,49,	
15,49,	15,49,	15,49,	15,49,	
15,49,	15,49,	15,49,	15,49,	
15,49,	34,0,	100,135,	101,136,	
108,0,	57,0,	57,0,	33,0,	
15,49,	15,49,	15,49,	15,49,	
15,49,	15,49,	17,55,	17,55,	
17,55,	17,55,	17,55,	17,55,	
17,55,	17,55,	17,55,	17,55,	
112,147,	114,148,	115,149,	34,68,	
57,0,	116,150,	107,0,	17,55,	
17,55,	17,55,	17,55,	17,55,	
17,55,	57,0,	19,57,	34,76,	
15,49,	15,49,	15,49,	15,49,	
15,49,	15,49,	19,0,	19,0,	
21,0,	21,0,	117,151,	23,0,	
23,0,	24,57,	118,152,	119,153,	
34,76,	121,154,	109,0,	25,0,	
25,0,	24,0,	24,0,	17,55,	
17,55,	17,55,	17,55,	17,55,	
17,55,	19,0,	122,155,	21,0,	
124,156,	19,57,	23,0,	21,58,	
125,157,	126,158,	19,0,	128,159,	
21,0,	130,160,	25,0,	23,0,	
24,0,	19,57,	25,58,	21,58,	
24,57,	110,0,	23,60,	25,0,	
68,0,	24,0,	33,71,	131,161,	
58,0,	58,0,	25,66,	33,72,	
24,57,	132,162,	19,57,	27,67,	
21,58,	133,163,	33,73,	23,60,	
108,143,	33,74,	33,75,	27,67,	
27,0,	61,0,	61,0,	25,66,	
48,48,	24,57,	68,68,	58,0,	
107,142,	62,0,	62,0,	58,58,	
48,48,	48,0,	135,164,	136,165,	
58,0,	111,0,	68,68,	144,0,	
147,174,	149,175,	150,176,	58,58,	
61,0,	153,177,	27,67,	154,178,	
155,179,	157,180,	163,181,	27,67,	
62,0,	61,0,	164,182,	68,68,	
170,0,	24,61,	27,67,	48,48,	
58,58,	62,0,	24,62,	142,0,	
48,48,	109,144,	143,0,	173,0,	
146,0,	24,63,	145,0,	48,48,	
24,64,	24,65,	172,0,	27,67,	
36,55,	36,55,	36,55,	36,55,	
36,55,	36,55,	36,55,	36,55,	
36,55,	36,55,	174,187,	175,188,	
48,48,	171,0,	63,0,	63,0,	
110,145,	36,55,	36,55,	36,55,	
36,55,	36,55,	36,55,	37,55,	
37,55,	37,55,	37,55,	37,55,	
37,55,	37,55,	37,55,	37,55,	
37,55,	76,0,	176,189,	179,190,	
61,102,	63,0,	181,191,	186,0,	
37,55,	37,55,	37,55,	37,55,	
37,55,	37,55,	63,0,	188,194,	
189,195,	36,55,	36,55,	36,77,	
36,55,	36,55,	36,55,	62,103,	
111,146,	193,0,	185,0,	76,68,	
0,0,	38,55,	38,55,	38,55,	
38,55,	38,55,	38,55,	38,55,	
38,55,	38,55,	38,55,	76,76,	
37,55,	37,55,	37,55,	37,55,	
37,55,	37,55,	38,55,	38,55,	
38,55,	38,55,	38,55,	38,55,	
64,0,	64,0,	60,0,	60,0,	
76,76,	143,171,	0,0,	142,170,	
37,78,	0,0,	145,172,	0,0,	
102,0,	102,0,	146,173,	0,0,	
171,185,	0,0,	0,0,	0,0,	
172,186,	0,0,	63,104,	64,0,	
0,0,	60,0,	38,55,	38,55,	
38,55,	38,55,	38,55,	38,55,	
64,0,	38,79,	60,0,	102,0,	
0,0,	0,0,	0,0,	0,0,	
38,80,	60,60,	0,0,	0,0,	
102,0,	0,0,	38,81,	39,55,	
39,55,	39,55,	39,55,	39,55,	
39,55,	39,55,	39,55,	39,55,	
39,55,	0,0,	60,60,	0,0,	
0,0,	65,0,	65,0,	0,0,	
39,55,	39,55,	39,55,	39,55,	
39,55,	39,55,	40,55,	40,55,	
40,55,	40,55,	40,55,	40,55,	
40,55,	40,55,	40,55,	40,55,	
185,193,	0,0,	0,0,	0,0,	
65,0,	103,0,	103,0,	40,55,	
40,55,	40,55,	40,55,	40,55,	
40,55,	65,0,	0,0,	0,0,	
39,82,	39,55,	39,55,	39,55,	
39,55,	39,55,	0,0,	102,137,	
59,59,	64,105,	0,0,	0,0,	
103,0,	0,0,	0,0,	0,0,	
0,0,	59,0,	0,0,	0,0,	
0,0,	103,0,	0,0,	40,55,	
40,55,	40,55,	40,55,	40,55,	
40,55,	0,0,	0,0,	40,83,	
55,55,	55,55,	55,55,	55,55,	
55,55,	55,55,	55,55,	55,55,	
55,55,	55,55,	0,0,	59,59,	
0,0,	104,0,	104,0,	105,0,	
105,0,	55,55,	55,55,	55,55,	
55,55,	55,55,	55,55,	59,59,	
0,0,	0,0,	69,69,	0,0,	
0,0,	0,0,	0,0,	0,0,	
66,0,	66,0,	69,69,	69,0,	
104,0,	0,0,	105,0,	0,0,	
59,59,	65,106,	0,0,	0,0,	
0,0,	104,0,	0,0,	105,0,	
0,0,	55,55,	55,55,	55,55,	
55,55,	55,55,	55,55,	66,0,	
0,0,	0,0,	0,0,	66,58,	
0,0,	69,69,	103,138,	0,0,	
66,0,	0,0,	69,69,	0,0,	
0,0,	0,0,	0,0,	66,66,	
0,0,	69,69,	77,55,	77,55,	
77,55,	77,55,	77,55,	77,55,	
77,55,	77,55,	77,55,	77,55,	
0,0,	0,0,	0,0,	0,0,	
66,66,	0,0,	69,69,	77,55,	
77,55,	77,55,	77,55,	77,55,	
77,55,	82,55,	82,55,	82,55,	
82,55,	82,55,	82,55,	82,55,	
82,55,	82,55,	82,55,	106,0,	
106,0,	137,0,	137,0,	105,140,	
0,0,	104,139,	82,55,	82,55,	
82,55,	82,55,	82,55,	82,55,	
138,0,	138,0,	0,0,	77,55,	
77,55,	77,55,	77,55,	77,55,	
77,55,	0,0,	106,0,	0,0,	
137,0,	139,0,	139,0,	140,0,	
140,0,	141,0,	141,0,	106,0,	
0,0,	137,0,	77,112,	138,0,	
0,0,	0,0,	82,55,	82,55,	
82,55,	82,55,	82,55,	82,55,	
138,0,	166,0,	166,0,	0,0,	
139,0,	0,0,	140,0,	0,0,	
141,0,	167,0,	167,0,	0,0,	
82,117,	139,0,	0,0,	140,0,	
0,0,	141,0,	0,0,	0,0,	
168,0,	168,0,	169,0,	169,0,	
166,0,	183,0,	183,0,	184,0,	
184,0,	0,0,	0,0,	0,0,	
167,0,	166,0,	0,0,	192,0,	
192,0,	0,0,	0,0,	0,0,	
0,0,	167,0,	0,0,	168,0,	
0,0,	169,0,	0,0,	0,0,	
183,0,	0,0,	184,0,	106,141,	
168,0,	0,0,	169,0,	0,0,	
0,0,	183,0,	192,0,	184,0,	
0,0,	0,0,	137,166,	0,0,	
0,0,	0,0,	0,0,	192,0,	
138,167,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
140,168,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
141,169,	0,0,	0,0,	0,0,	
0,0,	167,183,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	168,184,	
0,0,	0,0,	0,0,	0,0,	
183,192,	0,0,	0,0,	0,0,	
0,0};
struct yysvf yysvec[] ={
0,	0,	0,
yycrank+-1,	0,		yyvstop+1,
yycrank+-3,	yysvec+1,	yyvstop+3,
yycrank+-5,	yysvec+1,	yyvstop+5,
yycrank+-21,	yysvec+1,	yyvstop+7,
yycrank+-42,	yysvec+1,	yyvstop+9,
yycrank+-58,	yysvec+1,	yyvstop+11,
yycrank+-78,	0,		yyvstop+13,
yycrank+-49,	yysvec+7,	yyvstop+15,
yycrank+0,	0,		yyvstop+17,
yycrank+0,	0,		yyvstop+19,
yycrank+0,	0,		yyvstop+22,
yycrank+0,	0,		yyvstop+24,
yycrank+148,	0,		yyvstop+27,
yycrank+2,	0,		yyvstop+30,
yycrank+223,	0,		yyvstop+32,
yycrank+18,	0,		yyvstop+35,
yycrank+246,	yysvec+13,	yyvstop+37,
yycrank+2,	0,		yyvstop+41,
yycrank+-317,	0,		yyvstop+43,
yycrank+-14,	yysvec+19,	yyvstop+46,
yycrank+-319,	yysvec+19,	yyvstop+50,
yycrank+-130,	yysvec+19,	yyvstop+54,
yycrank+-322,	yysvec+19,	yyvstop+57,
yycrank+-332,	0,		yyvstop+61,
yycrank+-330,	yysvec+19,	yyvstop+64,
yycrank+-112,	yysvec+19,	yyvstop+69,
yycrank+-382,	0,		yyvstop+72,
yycrank+-3,	yysvec+27,	yyvstop+75,
yycrank+-4,	yysvec+27,	yyvstop+79,
yycrank+-37,	yysvec+27,	yyvstop+83,
yycrank+-16,	yysvec+27,	yyvstop+87,
yycrank+-64,	yysvec+27,	yyvstop+90,
yycrank+-277,	yysvec+27,	yyvstop+94,
yycrank+-271,	yysvec+27,	yyvstop+97,
yycrank+-5,	yysvec+27,	yyvstop+102,
yycrank+400,	yysvec+13,	yyvstop+105,
yycrank+423,	yysvec+13,	yyvstop+109,
yycrank+461,	yysvec+13,	yyvstop+113,
yycrank+531,	yysvec+13,	yyvstop+117,
yycrank+554,	yysvec+13,	yyvstop+121,
yycrank+22,	yysvec+13,	yyvstop+125,
yycrank+5,	yysvec+13,	yyvstop+128,
yycrank+54,	yysvec+13,	yyvstop+131,
yycrank+2,	yysvec+13,	yyvstop+134,
yycrank+72,	yysvec+13,	yyvstop+137,
yycrank+64,	yysvec+13,	yyvstop+140,
yycrank+0,	yysvec+13,	yyvstop+143,
yycrank+-395,	0,		yyvstop+145,
yycrank+0,	yysvec+15,	yyvstop+147,
yycrank+3,	0,		0,	
yycrank+13,	0,		0,	
yycrank+3,	0,		0,	
yycrank+14,	0,		0,	
yycrank+18,	0,		0,	
yycrank+612,	yysvec+13,	yyvstop+149,
yycrank+0,	0,		yyvstop+152,
yycrank+-276,	yysvec+19,	yyvstop+154,
yycrank+-367,	yysvec+19,	yyvstop+156,
yycrank+-635,	yysvec+48,	yyvstop+159,
yycrank+-525,	yysvec+19,	yyvstop+162,
yycrank+-384,	yysvec+19,	yyvstop+165,
yycrank+-392,	yysvec+19,	yyvstop+167,
yycrank+-453,	yysvec+19,	yyvstop+169,
yycrank+-523,	yysvec+19,	yyvstop+171,
yycrank+-584,	yysvec+19,	yyvstop+173,
yycrank+-683,	yysvec+19,	yyvstop+175,
yycrank+-9,	yysvec+27,	yyvstop+179,
yycrank+-362,	yysvec+27,	yyvstop+181,
yycrank+-685,	0,		yyvstop+184,
yycrank+-90,	yysvec+27,	yyvstop+187,
yycrank+-10,	yysvec+27,	yyvstop+190,
yycrank+-25,	yysvec+27,	yyvstop+192,
yycrank+-51,	yysvec+27,	yyvstop+194,
yycrank+-46,	yysvec+27,	yyvstop+196,
yycrank+-74,	yysvec+27,	yyvstop+198,
yycrank+-471,	yysvec+27,	yyvstop+200,
yycrank+686,	yysvec+13,	yyvstop+204,
yycrank+40,	yysvec+13,	yyvstop+207,
yycrank+48,	yysvec+13,	yyvstop+209,
yycrank+72,	yysvec+13,	yyvstop+211,
yycrank+0,	yysvec+13,	yyvstop+213,
yycrank+709,	yysvec+13,	yyvstop+216,
yycrank+48,	yysvec+13,	yyvstop+219,
yycrank+52,	yysvec+13,	yyvstop+221,
yycrank+54,	yysvec+13,	yyvstop+223,
yycrank+65,	yysvec+13,	yyvstop+225,
yycrank+71,	yysvec+13,	yyvstop+227,
yycrank+92,	yysvec+13,	yyvstop+229,
yycrank+95,	yysvec+13,	yyvstop+231,
yycrank+110,	yysvec+13,	yyvstop+233,
yycrank+88,	yysvec+13,	yyvstop+235,
yycrank+88,	yysvec+13,	yyvstop+237,
yycrank+112,	yysvec+13,	yyvstop+239,
yycrank+111,	yysvec+13,	yyvstop+241,
yycrank+134,	yysvec+13,	yyvstop+243,
yycrank+139,	yysvec+13,	yyvstop+245,
yycrank+141,	0,		0,	
yycrank+128,	0,		0,	
yycrank+135,	0,		0,	
yycrank+177,	0,		0,	
yycrank+178,	0,		0,	
yycrank+-535,	yysvec+19,	yyvstop+247,
yycrank+-608,	yysvec+19,	yyvstop+249,
yycrank+-664,	yysvec+19,	yyvstop+251,
yycrank+-666,	yysvec+19,	yyvstop+253,
yycrank+-758,	yysvec+19,	yyvstop+255,
yycrank+-300,	yysvec+27,	yyvstop+257,
yycrank+-274,	yysvec+27,	yyvstop+259,
yycrank+-328,	yysvec+27,	yyvstop+261,
yycrank+-359,	yysvec+27,	yyvstop+263,
yycrank+-399,	yysvec+27,	yyvstop+265,
yycrank+199,	yysvec+13,	yyvstop+267,
yycrank+0,	yysvec+13,	yyvstop+269,
yycrank+195,	yysvec+13,	yyvstop+272,
yycrank+197,	yysvec+13,	yyvstop+274,
yycrank+208,	yysvec+13,	yyvstop+276,
yycrank+230,	yysvec+13,	yyvstop+278,
yycrank+233,	yysvec+13,	yyvstop+280,
yycrank+235,	yysvec+13,	yyvstop+282,
yycrank+0,	yysvec+13,	yyvstop+284,
yycrank+227,	yysvec+13,	yyvstop+287,
yycrank+239,	yysvec+13,	yyvstop+289,
yycrank+0,	yysvec+13,	yyvstop+291,
yycrank+253,	yysvec+13,	yyvstop+294,
yycrank+257,	yysvec+13,	yyvstop+296,
yycrank+241,	yysvec+13,	yyvstop+298,
yycrank+0,	yysvec+13,	yyvstop+300,
yycrank+258,	yysvec+13,	yyvstop+303,
yycrank+0,	yysvec+13,	yyvstop+305,
yycrank+245,	yysvec+13,	yyvstop+308,
yycrank+261,	yysvec+13,	yyvstop+310,
yycrank+267,	0,		0,	
yycrank+276,	0,		0,	
yycrank+0,	0,		yyvstop+312,
yycrank+296,	0,		0,	
yycrank+291,	0,		0,	
yycrank+-760,	yysvec+19,	yyvstop+314,
yycrank+-771,	yysvec+19,	yyvstop+316,
yycrank+-784,	yysvec+19,	yyvstop+318,
yycrank+-786,	yysvec+19,	yyvstop+321,
yycrank+-788,	yysvec+19,	yyvstop+323,
yycrank+-425,	yysvec+27,	yyvstop+325,
yycrank+-428,	yysvec+27,	yyvstop+327,
yycrank+-401,	yysvec+27,	yyvstop+329,
yycrank+-432,	yysvec+27,	yyvstop+332,
yycrank+-430,	yysvec+27,	yyvstop+334,
yycrank+294,	yysvec+13,	yyvstop+336,
yycrank+0,	yysvec+13,	yyvstop+338,
yycrank+316,	yysvec+13,	yyvstop+341,
yycrank+298,	yysvec+13,	yyvstop+343,
yycrank+0,	yysvec+13,	yyvstop+345,
yycrank+0,	yysvec+13,	yyvstop+348,
yycrank+316,	yysvec+13,	yyvstop+351,
yycrank+303,	yysvec+13,	yyvstop+353,
yycrank+303,	yysvec+13,	yyvstop+355,
yycrank+0,	yysvec+13,	yyvstop+357,
yycrank+314,	yysvec+13,	yyvstop+360,
yycrank+0,	yysvec+13,	yyvstop+362,
yycrank+0,	yysvec+13,	yyvstop+365,
yycrank+0,	yysvec+13,	yyvstop+368,
yycrank+0,	yysvec+13,	yyvstop+371,
yycrank+0,	0,		yyvstop+374,
yycrank+325,	0,		0,	
yycrank+310,	0,		0,	
yycrank+0,	0,		yyvstop+376,
yycrank+-804,	yysvec+19,	yyvstop+378,
yycrank+-812,	yysvec+19,	yyvstop+381,
yycrank+-823,	yysvec+19,	yyvstop+383,
yycrank+-825,	yysvec+19,	yyvstop+385,
yycrank+-418,	yysvec+27,	yyvstop+388,
yycrank+-451,	yysvec+27,	yyvstop+391,
yycrank+-436,	yysvec+27,	yyvstop+393,
yycrank+-429,	yysvec+27,	yyvstop+395,
yycrank+357,	yysvec+13,	yyvstop+398,
yycrank+349,	yysvec+13,	yyvstop+400,
yycrank+385,	yysvec+13,	yyvstop+402,
yycrank+0,	yysvec+13,	yyvstop+404,
yycrank+0,	yysvec+13,	yyvstop+407,
yycrank+371,	yysvec+13,	yyvstop+410,
yycrank+0,	yysvec+13,	yyvstop+412,
yycrank+370,	0,		0,	
yycrank+0,	0,		yyvstop+415,
yycrank+-828,	yysvec+19,	yyvstop+417,
yycrank+-830,	yysvec+19,	yyvstop+419,
yycrank+-496,	yysvec+27,	yyvstop+422,
yycrank+-477,	yysvec+27,	yyvstop+424,
yycrank+0,	yysvec+13,	yyvstop+427,
yycrank+395,	yysvec+13,	yyvstop+430,
yycrank+398,	yysvec+13,	yyvstop+432,
yycrank+0,	yysvec+13,	yyvstop+434,
yycrank+0,	0,		yyvstop+437,
yycrank+-838,	yysvec+19,	yyvstop+439,
yycrank+-495,	yysvec+27,	yyvstop+442,
yycrank+0,	yysvec+13,	yyvstop+445,
yycrank+0,	yysvec+13,	yyvstop+448,
0,	0,	0};
struct yywork *yytop = yycrank+944;
struct yysvf *yybgin = yysvec+1;
char yymatch[] ={
00  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,011 ,012 ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
011 ,01  ,01  ,01  ,'$' ,01  ,01  ,01  ,
01  ,')' ,01  ,01  ,01  ,01  ,01  ,01  ,
'0' ,'0' ,'0' ,'0' ,'0' ,'0' ,'0' ,'0' ,
'0' ,'0' ,01  ,01  ,01  ,01  ,01  ,01  ,
'$' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'$' ,
'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,
'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,
'$' ,'$' ,'$' ,01  ,01  ,01  ,01  ,'$' ,
01  ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'$' ,
'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,
'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,
'$' ,'$' ,'$' ,01  ,01  ,01  ,01  ,01  ,
0};
char yyextra[] ={
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0};
int yylineno =1;
# define YYU(x) x
# define NLSTATE yyprevious=YYNEWLINE
char yytext[YYLMAX];
struct yysvf *yylstate [YYLMAX], **yylsp, **yyolsp;
char yysbuf[YYLMAX];
char *yysptr = yysbuf;
short *yyfnd;
extern struct yysvf *yyestate;
int yyprevious = YYNEWLINE;
yylook(){
	register struct yysvf *yystate, **lsp;
	register struct yywork *yyt;
	struct yysvf *yyz;
	int yych;
	struct yywork *yyr;
# ifdef LEXDEBUG
	int debug;
# endif
	char *yylastch;
	/* start off machines */
# ifdef LEXDEBUG
	debug = 0;
# endif
	if (!yymorfg)
		yylastch = yytext;
	else {
		yymorfg=0;
		yylastch = yytext+yyleng;
		}
	for(;;){
		lsp = yylstate;
		yyestate = yystate = yybgin;
		if (yyprevious==YYNEWLINE) yystate++;
		for (;;){
# ifdef LEXDEBUG
			if(debug)fprintf(yyout,"state %d\n",yystate-yysvec-1);
# endif
			yyt = yystate->yystoff;
			if(yyt == yycrank){		/* may not be any transitions */
				yyz = yystate->yyother;
				if(yyz == 0)break;
				if(yyz->yystoff == yycrank)break;
				}
			*yylastch++ = yych = input();
		tryagain:
# ifdef LEXDEBUG
			if(debug){
				fprintf(yyout,"char ");
				allprint(yych);
				putchar('\n');
				}
# endif
			yyr = yyt;
			if ( (int)yyt > (int)yycrank){
				yyt = yyr + yych;
				if (yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transitions */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				}
# ifdef YYOPTIM
			else if((int)yyt < (int)yycrank) {		/* r < yycrank */
				yyt = yyr = yycrank+(yycrank-yyt);
# ifdef LEXDEBUG
				if(debug)fprintf(yyout,"compressed state\n");
# endif
				yyt = yyt + yych;
				if(yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transitions */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				yyt = yyr + YYU(yymatch[yych]);
# ifdef LEXDEBUG
				if(debug){
					fprintf(yyout,"try fall back character ");
					allprint(YYU(yymatch[yych]));
					putchar('\n');
					}
# endif
				if(yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transition */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				}
			if ((yystate = yystate->yyother) && (yyt= yystate->yystoff) != yycrank){
# ifdef LEXDEBUG
				if(debug)fprintf(yyout,"fall back to state %d\n",yystate-yysvec-1);
# endif
				goto tryagain;
				}
# endif
			else
				{unput(*--yylastch);break;}
		contin:
# ifdef LEXDEBUG
			if(debug){
				fprintf(yyout,"state %d char ",yystate-yysvec-1);
				allprint(yych);
				putchar('\n');
				}
# endif
			;
			}
# ifdef LEXDEBUG
		if(debug){
			fprintf(yyout,"stopped at %d with ",*(lsp-1)-yysvec-1);
			allprint(yych);
			putchar('\n');
			}
# endif
		while (lsp-- > yylstate){
			*yylastch-- = 0;
			if (*lsp != 0 && (yyfnd= (*lsp)->yystops) && *yyfnd > 0){
				yyolsp = lsp;
				if(yyextra[*yyfnd]){		/* must backup */
					while(yyback((*lsp)->yystops,-*yyfnd) != 1 && lsp > yylstate){
						lsp--;
						unput(*yylastch--);
						}
					}
				yyprevious = YYU(*yylastch);
				yylsp = lsp;
				yyleng = yylastch-yytext+1;
				yytext[yyleng] = 0;
# ifdef LEXDEBUG
				if(debug){
					fprintf(yyout,"\nmatch ");
					sprint(yytext);
					fprintf(yyout," action %d\n",*yyfnd);
					}
# endif
				return(*yyfnd++);
				}
			unput(*yylastch);
			}
		if (yytext[0] == 0  /* && feof(yyin) */)
			{
			yysptr=yysbuf;
			return(0);
			}
		yyprevious = yytext[0] = input();
		if (yyprevious>0)
			output(yyprevious);
		yylastch=yytext;
# ifdef LEXDEBUG
		if(debug)putchar('\n');
# endif
		}
	}
yyback(p, m)
	int *p;
{
if (p==0) return(0);
while (*p)
	{
	if (*p++ == m)
		return(1);
	}
return(0);
}
	/* the following are only used in the lex library */
yyinput(){
	return(input());
	}
yyoutput(c)
  int c; {
	output(c);
	}
yyunput(c)
   int c; {
	unput(c);
	}
