/*
 *
 * program to make a dump file named dump
 *
 * prototype: makedump size
 *
 */
#include <stdio.h>
#include <ctype.h>

#define KILO            1024
#define MEG             (KILO*KILO)
#define MAXMEMSIZE      (16*MEG)

char buff[4096];
char dmpfile[] = "dump";
char usage[] = "Usage: %s size\n";

main(argc, argv)
int     argc;
char    **argv;
{
        int     size = 0;
	int     i;
        char    *p;
	char    *cmdname;
        FILE    *dump;

	cmdname = *argv++;
        /*
         * first check arguments.
         */
        if (argc == 1) {
                fprintf(stderr, usage, cmdname);
                exit(1);
        }
        p = *argv;             /* point at given memory size */
        while (*p) {
                if (isdigit(*p))
                        size = size*10 + (*p - '0');
                else if (*p == 'k' || *p == 'K')
                        size *= KILO;
                else if (*p == 'm' || *p == 'M')
                        size *= MEG;
		else {
                        fprintf(stderr, "%s: %s: illegal size\n",
                                cmdname, *argv);
                        exit(1);
                }
                *p++;
        }

        if ((size < 1) || (size > MAXMEMSIZE)) {
                fprintf(stderr, "%s: %s: illegal size\n",
                        cmdname, *argv);
                exit(1);
        }

        if ((dump = fopen(dmpfile, "w")) == NULL) {
                fprintf(stderr,"Unable to open dump file.\n");
                exit(1);
        }

        for (i = 0; i < size; i++)
                putc(0, dump);
}

