/*
 * Vmpunch daemon.
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <utmp.h>
#include <acct.h>
#include <ctype.h>
#include "vmpunch.h"

#define  BUFSIZ  512

extern char atetab[];
struct acct_io account;
struct stat statis;

main(argc, argv)
int argc;
char *argv[];
{
	int     ncmds;
	int     i;
	time_t  time();

	/*
	 * Reopen the standard output.
	 * The first three lines are CP commands to be executed.
	 */
	if(freopen(argv[1], "w", stdout) == NULL)
		exit(1);
	scanf("%d", &ncmds);
	while(getchar() != '\n')
                ;
	for (i = 0; i < ncmds; i++)
                docpcmd();
	/*
	 * Do the punching and accounting.
	 */
	fstat(fileno(stdin), &statis);
	account.ai_uid = statis.st_uid;
	account.ai_gid = statis.st_gid;
	account.ai_rid = A_PUNCH;
	account.ai_ctime = time();
	punch();
	acctwrt(&account, sizeof (account));
}

/*
 *  docpcmd - read a line from the standard input and
 *  execute it as a CP command.
 */
docpcmd()
{
	char    buf[BUFSIZ];

	gets(buf);
	if (cpcmd(buf) == -1) {
		fprintf(stderr, "CP command: %s failed\n", buf);
		exit(1);
	}
}

/*
 *  Decide which punching method to use.
 */
punch()
{
	int     mode, i;
	char    *h, *s;
	char    *modestr();
	char    *eupper();
	char    userid[10];
	char    destfile[BUFSIZ];
	char    header[HDRSIZ];

	scanf("%d %s %s", &mode, userid, destfile);
	while(getchar() != '\n')
                ;
	if (mode & HEADER) {
		for (i = 0; i < HDRSIZ; i++)
			header[i] = EOS;
		h = header;
		for (s = eupper(modestr(mode)); *s; )
			*h++ = *s++;
		*h++ = atetab[' '];
		for (s = eupper(userid); *s; )
			*h++ = *s++;
		*h++ = atetab[' '];
		for (s = eupper(destfile); *s; )
			*h++ = *s++;
		putw(MAGIC1, stdout);
		fwrite(header, HDRSIZ, 1, stdout);
        }
	if(mode & STREAM)
		if(mode & RAW)
			outsandr();
		else
			outsonly();
	else
		if(mode & RAW)
			outronly();
		else
			outneither();
	return;
}

/*
 *  Punch in unconverted 'stream' mode.
 *
 *  <two byte length><ascii data><two byte length><ascii data>...
 *
 */
outsandr()
{
	struct {
		short a;
		char  c[BUFSIZ];
	} buffer;
	int length;

	while( (length = fread(buffer.c, 1, BUFSIZ-2, stdin)) > 0) {
		buffer.a = length;
		fwrite((char *)&buffer, 1,length+2, stdout);
		account.ai_recs += (length + 2);
	}
	account.ai_recs += 79;
	account.ai_recs /= 80;
	puthw(0, stdout);
	return;
}

/*
 *  Punch in converted, card image format.
 *
 *        /-------------------------
 *     /-------------------------- |
 *  /--------------------------  | |
 *  |EBCIDIC ON VIRTUAL CARDS |  |_|
 *  |                         |__|
 *  |_________________________|
 *
 */
outneither()
{
	int  c;
	int  i, ct;

	ct = 0;
	while( (c = getc(stdin)) != EOF) {
		switch(c) {
			case '\n' :
				for(; ct<80; ct++)
					putc(atetab[' '], stdout);
				ct = 0;
				account.ai_recs++;
				break;
			case '\t' :
				for(i=ct % 8; i<8; i++) {
					putc(atetab[' '], stdout);
					ct++;
					if(ct == 80)
						break;
				}
				break;
			default :
				putc(atetab[c], stdout);
				ct++;
				break;
		}
	        if(ct == 80) {
		        ct = 0;
			account.ai_recs++;
			if( (c = getc(stdin)) != '\n')
				ungetc(c, stdin);
		}
	}
	return;
}

/*
 *  Punch in unconverted card image format.
 *  It is not obvious that this mode is of real value.
 *
 *        /-------------------------
 *     /-------------------------- |
 *  /--------------------------  | |
 *  |ascii on virtual cards   |  |_|
 *  |                         |__|
 *  |_________________________|
 */
outronly()
{
	int length;
	char buffer[BUFSIZ];

	while( (length = fread(buffer, 1,BUFSIZ, stdin)) > 0) {
		fwrite(buffer, length, 1, stdout);
		account.ai_recs += length;
	}
	account.ai_recs += 79;
	account.ai_recs /= 80;
	return;
}

/*
 *  Punch in converted 'stream' mode.
 *
 *  <two byte length><EBCIDIC data><two byte length><EBCIDIC data>...
 */
outsonly()
{
	char    *fgets();
	char    inhold[BUFSIZ],
		*toin;
	int     i, absct, length;

	while((int)fgets(inhold, BUFSIZ, stdin) != NULL) {
		length = abssize(inhold);
		if(length == 0) {
			puthw(1, stdout);
			putc(atetab[' '], stdout);
			account.ai_recs += 3;
		}
		else {
			account.ai_recs += (length + 2);
			puthw(length, stdout);
			absct = 0;
			toin = inhold;
			while(*toin != '\n' && *toin != 0) {
				if(*toin == '\t')
					for(i= absct % 8; i<8; i++) {
						putc(atetab[' '], stdout);
						absct++;
					}
				else {
					putc(atetab[*toin], stdout);
					absct++;
				}
				toin++;
			}
		}
	}
	account.ai_recs += 81;
	account.ai_recs /= 80;
	puthw(0, stdout);
	return;
}

/*
 *  Find the length of a string after expanding tabs.
 */
abssize(to)
char *to;
{
	int result, a;
	result = 0;
	while(*to != '\n' && *to != 0) {
		if(*to == '\t') {
			a = 7 - (result % 8);
			result += a;
		}
		result++;
		to++;
	}
	return(result);
}
/*
 *  modestr - convert numerical mode to a string for the header.
 */
char *
modestr(a)
int     a;
{
	struct  modetab *m;
	static  char    strmode[10];
	char    *s;
	FILE    *fp;

	s = strmode;
        for (m = modes; m->m_char; m++)
                if (a & m->m_bits)
                        *s++ = m->m_char;
	if (s == strmode)
		*s++ =' c';
	*s = EOS;
	return(strmode);
}
/*
 *  eupper - EBCDIC upper case
 *  Translate a string to upper case EBCDIC.  Upper case
 *  ASCII characters are preceeded by a backslash.
 */
char    *
eupper(str)
char    *str;
{
	static  char    buf[BUFSIZ];
        char    *b = buf;
        char    *s = str;
	int     c;

	while (c = *s++) {
		if (isupper(c))
			*b++ = atetab['\\'];
		else if (isalpha(c))
			c = toupper(c);
		*b++ = atetab[c];
	}
	*b = EOS;
	return(buf);
}
