/*
 * Header for object code improver
 */

#include <stdio.h>
#include <ctype.h>

#define JBR     1       /* unconditional branch "b" */
#define CBR     2       /* conditional branches */
#define JSW     3       /* switch table entry "dc a($nnn)" */
#define LABEL   4       /* C label "$nnn:" */
#define DLABEL  5       /* Other labels "xxx:" */
#define EROU    6       /* End of function -- "drop" */
#define TEXT    7       /* .text */
#define DATA    8       /* .data */
#define BSS     9       /* .bss */
#define END     10      /* end of file */
#define NOP     11      /* no-op */
/* random instructions */
#define ADD     12      /* A, AR, AH */
#define AND     13      /* N, NR */
#define NI      14
#define NC      15
#define BALR    16
#define BCR     17
#define BCTR    18
#define CMP     19      /* C, CR, CH */
#define CMPL    20      /* CL, CLR */
#define CLC     21
#define CLI     22
#define CLM     23
#define CLCL    24
#define CVB     25
#define CVD     26
#define DIV     27      /* D, DR */
#define XOR     28      /* XR, X */
#define XI      29
#define XC      30
#define IC      31
#define ICM     32
#define LOAD    33      /* L, LR, LH */
#define LA      34
#define LTR     35
#define LCR     36
#define LM      37
#define LNR     38
#define LPR     39
#define MC      40
#define MVI     41
#define MVC     42
#define MVCL    43
#define MULT    44      /* M, MR, MH */
#define OR      45      /* O, OR */
#define OI      46
#define OC      47
#define SPM     48
#define SLDA    49
#define SLDL    50
#define SLA     51
#define SLL     52
#define SRDA    53
#define SRDL    54
#define SRA     55
#define SRL     56
#define STORE   57      /* ST, STH, STC */
/*efine STC     58 now under STORE */
#define STCM    59
#define STM     60
#define SUB     61      /* S, SR, SH */
#define SUBL    62      /* SL, SLR */
#define ADDL    63      /* AL, ALR - forgot about these earlier*/
#define SVC     64
#define TS      65
#define TM      66
#define TR      67
#define TRT     68
#define ENTRY   100
#define USING   101
#define LTORG   102
#define COMM    103
#define DC      104
#define EQU     105
#define FADD    106     /* ADR, AD, AER, AE, AWR, AW, AUR, AU */
#define FCMP    107     /* CDR, CD, CER, CE */
#define FDIV    108     /* DDR, DD, DER, DE */
#define FHALF   109     /* HDR, HER */
#define FLTR    110     /* LTDR, LTER */
#define FLCR    111     /* LCDR, LCER */
#define FLOAD   112     /* LDR, LD, LER, LE */
#define FLPR    113     /* LPDR, LPER */
#define FMULT   114     /* MDR, MD, MER, ME */
#define FSTORE  115     /* STD, STE */
#define FSUB    116     /* SDR, SD, SER, SE, SWR, SW, SUR, SU */
#define DS      117

/* sub-ops */
/* branches: */
#define BNE     7
#define BE      8
/* general */
#define REG     0200    /* register - OR'ed with other subops */
#define HALF    21      /* half-word (AH, CH, etc.) */
#define CHAR    22      /* character (STC) */
/* floating */
#define SNGL    1       /* single precision */
#define DBL     2       /* double precision */
#define UNNRM   4       /* unnormalized */

#define NEQOP   10      /* things below this are never equal operators */


#define CLAB '$'        /* C label identifier */

#define	LSIZE	512

struct node {
	char	op;
	char	subop;
	struct	node	*forw;
	struct	node	*back;
	struct	node	*ref;
	int	labno;
	char	*code;
	int	refc;
};

struct optab {
	char	*opstring;
	int	opcode;
} optab[];

char	line[LSIZE];
struct	node	first;
char	*curlp;
int	nbrbr;
int	redunm;
int	iaftbr;
int	njp1;
int	nrlab;
int	nxjump;
int	ncmot;
int	nrevbr;
int	loopiv;
int	nredunj;
int	nskip;
int	ncomj;
int	nlit;
int     nrxrr;
int     nltr;

int	nchange;
int	isn;
int	debug;
int	lastseg;
char	*lasta;
char	*lastr;
char	*firstr;
#define	LABHS	127
#define OPHS    257

struct optab *ophash[OPHS];
struct	node *nonlab();
char	*copy();
char	*sbrk();
char	*findcon();
struct	node *insertl();
struct	node *codemove();
char	*sbrk();
char	*alloc();

/* Switches to enable or disable particular optimizations */
#define O_MOVEDAT 0
#define O_BRBR  1
#define O_IAFTBR 1
#define O_JP1   1
#define O_RLAB  1
#define O_XJUMP 1
#define O_CMOT  1
#define O_REVBR 1
#define O_REDUNM 1
#define O_SADDR 1
#define O_LOOPIV 1
#define O_REDUNT 1
#define O_COMJ  1
#define O_SKIP  1
#define O_SOB   1
#define O_RTST  1
#define O_LIT   1
