main()
{
	/* test cast conversion tests */

	cstintcvn();
	cstfieldcvn();
	cstdoublecvn();
	cstlongcvn();
	cstptrcvn();
	cstshortcvn();
	cstcharcvn();
	cstunsigncvn();

	/* test assignment conversion tests */

	asgnintcvn();
	asgnfieldcvn();
	asgndoublecvn();
	asgnlongcvn();
	asgnptrcvn();
	asgnshortcvn();
	asgncharcvn();
	asgnunsigncvn();

}

cstintcvn()
{
	char *s1 = "cast conversion";
	int i, *p;
	double d, *pd;
	long l;
	short s;
	register r;
	char c;
	unsigned u;
	struct {
		unsigned f1 : 5;
		unsigned f2 : 8;
		unsigned f3 : 25;
	} flag;

	/* double -> int */

	d = 5.0;
	i = (int) d;
	if (i != 5)
		error(s1, "double -> int ", "double = 5.0");

	i = (int) 5.0;
	if (i != 5)
		error(s1, "double -> int ", "double = 5.0");

	d = 0.0;
	i = (int) d;
	if (i)
		error(s1, "double -> int ", "double = 0.0");

	i = (int) 0.0;
	if (i)
		error(s1, "double -> int ", "double = 0.0");

	d = -5.0;
	i = (int) d;
	if (i != -5)
		error(s1, "double -> int ", "double = -5.0");

	i = (int) -5.0;
	if (i != -5)
		error(s1, "double -> int ", "double = -5.0");

	/* field -> int */

	flag.f3 = 5;
	i = (int) flag.f3;
	if (i != 5)
		error(s1, "field -> int ", "field = 5");

	flag.f3 = 0;
	i = (int) flag.f3;
	if (i)
		error(s1, "field -> int ", "field = 0");

	/* long -> int */

	l = 5;
	i = (int) l;
	if (i != 5)
		error(s1, "long -> int ", "long = 5l");

	i = (int) 5l;
	if (i != 5)
		error(s1, "long -> int ", "long = 5l");

	l = 0;
	i = (int) l;
	if (i)
		error(s1, "long -> int ", "long = 0l");

	i = (int) 0l;
	if (i)
		error(s1, "long -> int ", "long = 0l");

	l = -5;
	i = (int) l;
	if (i != -5)
		error(s1, "long -> int ", "long = -5l");

	i = (int) -5l;
	if (i != -5)
		error(s1, "long -> int ", "long = -5l");

	/* ptr -> int */

	p = &i;
	i = (int) p;
	if (i != (int)(&i))
		error(s1, "ptr -> int ", "ptr = &i");

	pd = &d;
	i = (int) pd;
	if (i != (int)(&d))
		error(s1, "ptr -> int ", "ptr = &d");

	/* short -> int */

	s = 5;
	i = (int) s;
	if (i != 5)
		error(s1, "short -> int ", "short = 5");

	s = 0;
	i = (int) s;
	if (i)
		error(s1, "short -> int ", "short = 0");

	s = -5;
	i = (int) s;
	if (i != -5)
		error(s1, "short -> int ", "short = -5");

	/* register -> int */

	r = 5;
	i = (int) r;
	if (i != 5)
		error(s1, "register -> int ", "register = 5");

	r = 0;
	i = (int) r;
	if (i)
		error(s1, "register -> int ", "register = 0");

	r = -5;
	i = (int) r;
	if (i != -5)
		error(s1, "register -> int ", "register = -5");

	/* char -> int */

	c = 'a';
	i = (int) c;
	if (i != 97)
		error(s1, "char -> int ", "char = 'a'");

	i = (int) 'a';
	if (i != 97)
		error(s1, "char -> int ", "char = 'a'");

	/* unsigned -> int */

	u = 5;
	i = (int) u;
	if (i != 5)
		error(s1, "unsigned -> int ", "unsigned = 5");

	u = 0;
	i = (int) u;
	if (i)
		error(s1, "unsigned -> int ", "unsigned = 0");

	u = -5;
	i = (int) u;
	if (i != -5)
		error(s1, "unsigned -> int ", "unsigned = -5");

}

cstfieldcvn()
{
	char *s1 = "cast conversion";
	int i, *p;
	double d;
	long l;
	short s;
	register r;
	char c;
	unsigned u;
	struct {
		unsigned f1 : 5;
		unsigned f2 : 8;
		unsigned f3 : 25;
	} flag;

	/* int -> field */

	i = 5;
	flag.f3 = i;
	if (flag.f3 != 5)
		error(s1, "int -> field", "int = 5");

	flag.f3 = 5;
	if (flag.f3 != 5)
		error(s1, "int -> field", "int = 5");
	i = 0;
	flag.f3 = i;
	if (flag.f3)
		error(s1, "int -> field", "int = 0");

	flag.f3 = 0;
	if (flag.f3)
		error(s1, "int -> field", "int = 0");

	/* double -> field */

	d = 5.0;
	flag.f3 = d;
	if (flag.f3 != 5)
		error(s1, "double -> field", "double = 5.0");

	flag.f3 = 5.0;
	if (flag.f3 != 5)
		error(s1, "double -> field", "double = 5.0");

	d = 0.0;
	flag.f3 = d;
	if (flag.f3)
		error(s1, "double -> field", "double = 0.0");

	flag.f3 = 0.0;
	if (flag.f3)
		error(s1, "double -> field", "double = 0.0");

	/* long -> field */

	l = 5;
	flag.f3 = l;
	if (flag.f3 != 5)
		error(s1, "long -> field", "long = 5");

	flag.f3 = 5l;
	if (flag.f3 != 5)
		error(s1, "long -> field", "long = 5");

	l = 0;
	flag.f3 = l;
	if (flag.f3)
		error(s1, "long -> field", "long = 0");

	flag.f3 = 0l;
	if (flag.f3)
		error(s1, "long -> field", "long = 0");

	/* ptr -> field */

	p = &i;
	flag.f3 = (int) p;
	if (flag.f3 != (int)(&i))
		error(s1, "ptr -> field", "ptr = &i");

	/* short -> field */

	s = 5;
	flag.f3 = s;
	if (flag.f3 != 5)
		error(s1, "short -> field", "short = 5");

	s = 0;
	flag.f3 = s;
	if (flag.f3)
		error(s1, "short -> field", "short = 0");

	/* register -> field */

	r = 5;
	flag.f3 = r;
	if (flag.f3 != 5)
		error(s1, "register -> field", "register = 5");

	r = 0;
	flag.f3 = r;
	if (flag.f3)
		error(s1, "register -> field", "register = 0");

	/* char -> field */

	c = 'a';
	flag.f3 = c;
	if (flag.f3 != 97)
		error(s1, "char -> field", "char = 'a'");

	flag.f3 = 'a';
	if (flag.f3 != 97)
		error(s1, "char -> field", "char = 'a'");

	/* unsigned -> field */

	u = 5;
	flag.f3 = u;
	if (flag.f3 != 5)
		error(s1, "unsigned -> field", "unsigned = 5");

	u = 0;
	flag.f3 = u;
	if (flag.f3)
		error(s1, "unsigned -> field", "unsigned = 0");

}

cstdoublecvn()
{
	char *s1 = "cast conversion";
	int i;
	double d;
	long l;
	register r;
	char c;
	unsigned u;
	struct {
		unsigned f1 : 5;
		unsigned f2 : 8;
		unsigned f3 : 25;
	} flag;

	/* int -> double */

	i = 5;
	d = (double) i;
	if (d != 5.0)
		error(s1, "int -> double", "int = 5");

	d = (double) 5;
	if (d != 5.0)
		error(s1, "int -> double", "int = 5");

	i = 0;
	d = (double) i;
	if (d)
		error(s1, "int -> double", "int = 0");

	d = (double) 0;
	if (d)
		error(s1, "int -> double", "int = 0");

	i = -5;
	d = (double) i;
	if (d != -5.0)
		error(s1, "int -> double", "int = -5");

	d = (double) -5;
	if (d != -5.0)
		error(s1, "int -> double", "int = -5");

	/* field -> double */

	flag.f3 = 5;
	d = (double) flag.f3;
	if (d != 5.0)
		error(s1, "field -> double", "field = 5");

	flag.f3 = 0;
	d = (double) flag.f3;
	if (d)
		error(s1, "field -> double", "field = 0");

	/* long -> double */

	l = 5;
	d = (double) l;
	if (d != 5.0)
		error(s1, "long -> double", "long = 5");

	d = (double) 5l;
	if (d != 5.0)
		error(s1, "long -> double", "long = 5");

	l = 0;
	d = (double) l;
	if (d)
		error(s1, "long -> double", "long = 0");

	d = (double) 0l;
	if (d)
		error(s1, "long -> double", "long = 0");

	l = -5;
	d = (double) l;
	if (d != -5.0)
		error(s1, "long -> double", "long = -5");

	d = (double) -5l;
	if (d != -5.0)
		error(s1, "long -> double", "long = -5");

	/* ptr -> double - illegal conversion */

	/* register -> double */

	r = 5;
	d = (double) r;
	if (d != 5.0)
		error(s1, "register -> double", "register = 5");

	r = 0;
	d = (double) r;
	if (d)
		error(s1, "register -> double", "register = 0");

	r = -5;
	d = (double) r;
	if (d != -5.0)
		error(s1, "register -> double", "register = -5");

	/* char -> double */

	c = 'a';
	d = (double) c;
	if (d != 97.0)
		error(s1, "char -> double", "char = 'a'");


	d = (double) 'a';
	if (d != 97.0)
		error(s1, "char -> double", "char = 'a'");

	/* unsigned -> double */

	u = 5;
	d = (double) u;
	if (d != 5.0)
		error(s1, "unsigned -> double", "unsigned = 5");

	u = 0;
	d = (double) u;
	if (d)
		error(s1, "unsigned -> double", "unsigned = 0");
}

cstlongcvn()
{
	char *s1 = "cast conversion";
	int i, *p;
	double d;
	long l;
	short s;
	register r;
	char c;
	unsigned u;
	struct {
		unsigned f1 : 5;
		unsigned f2 : 8;
		unsigned f3 : 25;
	} flag;

	/* int -> long */

	i = 5;
	l = (long) i;
	if (l != 5)
		error(s1, "int -> long", "int = 5");

	i = 0;
	l = (long) i;
	if (l)
		error(s1, "int -> long", "int = 0");

	i = -5;
	l = (long) i;
	if (l != -5)
		error(s1, "int -> long", "int = -5");

	/* field -> long */

	flag.f2 = 5;
	l = (long) flag.f2;
	if (l != 5)
		error(s1, "field -> long", "field = 5");

	flag.f2 = 0;
	l = (long) flag.f2;
	if (l != 0)
		error(s1, "field -> long", "field = 0");

	/* double -> long */

	d = 5.0;
	l = (long) d;
	if (l != 5)
		error(s1, "double -> long", "double = 5.0");

	l = (long) 5.0;
	if (l != 5)
		error(s1, "double -> long", "double = 5.0");

	d = 0.0;
	l = (long) d;
	if (l)
		error(s1, "double -> long", "double = 0.0");

	l = (long) 0.0;
	if (l != 0)
		error(s1, "double -> long", "double = 0.0");

	d = -5.0;
	l = (long) d;
	if (l != -5)
		error(s1, "double -> long", "double = -5.0");

	l = (long) -5.0;
	if (l != -5)
		error(s1, "double -> long", "double = -5.0");

	/* ptr -> long */

	p = &i;
	l = (long) p;
	if (l != (int)(&i))
		error(s1, "ptr -> long", "ptr = &i");

	/* short -> long */

	s = 5;
	l = (long) s;
	if (l != 5)
		error(s1, "short -> long", "short = 5");

	s = 0;
	l = (long) s;
	if (l)
		error(s1, "short -> long", "short = 0");

	s = -5;
	l = (long) s;
	if (l != -5)
		error(s1, "short -> long", "short = -5");

	/* register -> long */

	r = 5;
	l = (long) r;
	if (l != 5)
		error(s1, "register -> long", "register = 5");

	r = 0;
	l = (long) r;
	if (l)
		error(s1, "register -> long", "register = 0");

	r = -5;
	l = (long) r;
	if (l != -5)
		error(s1, "register -> long", "register = -5");

	/* char -> long */

	c = 'a';
	l = (long) c;
	if (l != 97)
		error(s1, "char -> long", "char = 'a'");

	l = (long) 'a';
	if (l != 97)
		error(s1, "char -> long", "char = 'a'");

	/* unsigned -> long */

	u = 5;
	l = (long) u;
	if (l != 5)
		error(s1, "unsigned -> long", "unsigned = 5");

	u = 0;
	l = (long) u;
	if (l)
		error(s1, "unsigned -> long", "unsigned = 0");
}

cstptrcvn()
{
	char *s1 = "cast conversion";
	int i, *p;
	double d, *pd;
	long l;
	short s;
	register r;
	char c;
	unsigned u;
	struct {
		unsigned f1 : 5;
		unsigned f2 : 8;
		unsigned f3 : 25;
	} flag;

	/* int -> ptr */

	i = 5;
	p = (int *) i;
	if (((int) p) != 5)
		error(s1, "int -> ptr", "int = 5");

	/* field -> ptr */

	flag.f1 = 5;
	p = (int *) flag.f1;
	if (((int) p) != 5)
		error(s1, "field -> ptr", "field = 5");

	/* double -> ptr - illegal conversion */

	/* long -> ptr */

	l = 5;
	p = (int *) l;
	if (((int) p) != 5)
		error(s1, "long -> ptr", "long = 5");

	/* ptr -> ptr */

	pd = &d;
	p = (int *) pd;
	if (((int) p) != (int)(&d))
		error(s1, "ptr -> ptr", "ptr = double");

	/* short -> ptr */

	s = 5;
	p = (int *) s;
	if (((int) p) != 5)
		error(s1, "short -> ptr", "short = 5");

	/* register -> ptr */

	r = 5;
	p = (int *) r;
	if (((int) p) != 5)
		error(s1, "register -> ptr", "register = 5");

	/* char -> ptr */

	c = 'a';
	p = (int *) c;
	if (((int) p) != 97)
		error(s1, "char -> ptr", "char = 'a'");

	/* unsigned -> ptr */

	u = 5;
	p = (int *) u;
	if (((int) p) != 5)
		error(s1, "unsigned -> ptr", "unsigned = 5");
}

cstshortcvn()
{
	char *s1 = "cast conversion";
	int i;
	double d;
	long l;
	short s;
	char c;
	unsigned u;
	struct {
		unsigned f1 : 5;
		unsigned f2 : 8;
		unsigned f3 : 25;
	} flag;

	/* int -> short */

	i = 5;
	s = (short) i;
	if (s != 5)
		error(s1, "int -> short", "int = 5");

	i = 0;
	s = (short) i;
	if (s)
		error(s1, "int -> short", "int = 0");

	i = -5;
	s = (short) i;
	if (s != -5)
		error(s1, "int -> short", "int = -5");

	/* field -> short */

	flag.f2 = 5;
	s = (short) flag.f2;
	if (s != 5)
		error(s1, "field -> short", "field = 5");

	flag.f2 = 0;
	s = (short) flag.f2;
	if (s != 0)
		error(s1, "field -> short", "field = 0");

	/* double -> short */

	d = 5.0;
	s = (short) d;
	if (s != 5)
		error(s1, "double -> short", "double = 5.0");

	s = 5.0;
	if (s != 5.0)
		error(s1, "double -> short", "double = 5.0");

	d = 0.0;
	s = (short) d;
	if (s)
		error(s1, "double -> short", "double = 0.0");

	d = -5.0;
	s = (short) d;
	if (s != -5)
		error(s1, "double -> short", "double = -5.0");

	/* long -> short */

	l = 5;
	s = (short) l;
	if (s != 5)
		error(s1, "long -> short", "long = 5");

	l = 0;
	s = (short) l;
	if (s)
		error(s1, "long -> short", "long = 0");

	l = -5;
	s = (short) l;
	if (s != -5)
		error(s1, "long -> short", "long = -5");

	/* char -> short */

	c = 'a';
	s = (short) c;
	if (s != 97)
		error(s1, "char -> short", "char = 'a'");

	s = 'a';
	if (s != 97)
		error(s1, "char -> short", "char = 'a'");

	/* unsigned -> short */

	u = 5;
	s = (short) u;
	if (s != 5)
		error(s1, "unsigned -> short", "unsigned = 5");

	u = 0;
	s = (short) u;
	if (s)
		error(s1, "unsigned -> short", "unsigned = 0");

	u = -5;
	s = (short) u;
	if (s != -5)
		error(s1, "unsigned -> short", "unsigned = -5");
}

cstcharcvn()
{
	char *s1 = "cast conversion";
	int i, *p;
	double d;
	long l;
	short s;
	register r;
	char c;
	unsigned u;
	struct {
		unsigned f1 : 5;
		unsigned f2 : 8;
		unsigned f3 : 25;
	} flag;

	/* int -> char */

	i = 97;
	c = (char) i;
	if (c != 'a')
		error(s1, "int -> char", "int = 97");

	/* field -> char */

	flag.f3 = 97;
	c = (char) flag.f3;
	if (c != 'a')
		error(s1, "field -> char", "field = 97");

	/* double -> char */

	d = 97.0;
	c = (char) d;
	if (c != 'a')
		error(s1, "double -> char", "double = 97.0");

	/* long -> char */

	l = 97l;
	c = (char) l;
	if (c != 'a')
		error(s1, "long -> char", "long = 97");

	/* ptr -> char */

	p = (int *) 97;
	c = (int) p;
	if (c != 'a')
		error(s1, "ptr -> char", "ptr = 97");

	/* short -> char */

	s = 97;
	c = (char) s;
	if (c != 'a')
		error(s1, "short -> char", "short = 97");

	/* register -> char */

	r = 97;
	c = (char) r;
	if (c != 'a')
		error(s1, "register -> char", "register = 97");

	/* unsigned -> char */

	u = 97;
	c = (char) u;
	if (c != 'a')
		error(s1, "unsigned -> char", "unsigned = 97");
}

cstunsigncvn()
{
	char *s1 = "cast conversion";
	int i, *p;
	double d;
	long l;
	short s;
	register r;
	char c;
	unsigned u;

	/* int -> unsigned */

	i = 5;
	u = (unsigned) i;
	if (u != 5)
		error(s1, "int -> unsigned", "int = 5");

	i = 0;
	u = (unsigned) i;
	if (u)
		error(s1, "int -> unsigned", "int = 0");

	i = -5;
	u = (unsigned) i;
	if (u != (unsigned) -5)
		error(s1, "int -> unsigned", "int = -5");

	/* double -> unsigned */

	d = 5.0;
	u = (unsigned) d;
	if (u != 5)
		error(s1, "double -> unsigned", "double = 5.0");

	d = 0.0;
	u = (unsigned) d;
	if (u)
		error(s1, "double -> unsigned", "double = 0.0");

	d = -5.0;
	u = (unsigned) d;
	if (u != (unsigned) -5)
		error(s1, "double -> unsigned", "double = -5.0");

	/* long -> unsigned */

	l = 5;
	u = (unsigned) l;
	if (u != 5)
		error(s1, "long -> unsigned", "long = 5");

	l = 0;
	u = (unsigned) l;
	if (u)
		error(s1, "long -> unsigned", "long = 0");

	l = -5;
	u = (unsigned) l;
	if (u != (unsigned) -5)
		error(s1, "long -> unsigned", "long = -5");

	/* ptr -> unsigned */

	p = (int *) 5;
	u = (unsigned) p;
	if (u != 5)
		error(s1, "ptr -> unsigned", "ptr = 5");

	/* short -> unsigned */

	s = 5;
	u = (unsigned) s;
	if (u != 5)
		error(s1, "short -> unsigned", "short = 5");

	s = 0;
	u = (unsigned) s;
	if (u)
		error(s1, "short -> unsigned", "short = 0");

	s = -5;
	u = (unsigned) s;
	if (u != (unsigned) -5)
		error(s1, "short -> unsigned", "short = -5");

	/* register -> unsigned */

	r = 5;
	u = (unsigned) r;
	if (u != 5)
		error(s1, "register -> unsigned", "register = 5");

	r = 0;
	u = (unsigned) r;
	if (u)
		error(s1, "register -> unsigned", "register = 0");

	r = -5;
	u = (unsigned) r;
	if (u != (unsigned) -5)
		error(s1, "register -> unsigned", "register = -5");

	/* char -> unsigned */

	c = 'a';
	u = (unsigned) c;
	if (u != 97)
		error(s1, "char -> unsigned", "char = 97");
}

asgnintcvn()
{
	char *s1 = "assignment conversion";
	int i, *p;
	double d, *pd;
	long l;
	short s;
	register r;
	char c;
	unsigned u;
	struct {
		unsigned f1 : 5;
		unsigned f2 : 8;
		unsigned f3 : 25;
	} flag;

	/* double -> int */

	d = 5.0;
	i = d;
	if (i != 5)
		error(s1, "double -> int ", "double = 5.0");

	i = 5.0;
	if (i != 5)
		error(s1, "double -> int ", "double = 5.0");

	d = 0.0;
	i = d;
	if (i)
		error(s1, "double -> int ", "double = 0.0");

	i = 0.0;
	if (i)
		error(s1, "double -> int ", "double = 0.0");

	d = -5.0;
	i = d;
	if (i != -5)
		error(s1, "double -> int ", "double = -5.0");

	i = -5.0;
	if (i != -5)
		error(s1, "double -> int ", "double = -5.0");

	/* field -> int */

	flag.f3 = 5;
	i = flag.f3;
	if (i != 5)
		error(s1, "field -> int ", "field = 5");

	flag.f3 = 0;
	i = flag.f3;
	if (i)
		error(s1, "field -> int ", "field = 0");

	/* long -> int */

	l = 5;
	i = l;
	if (i != 5)
		error(s1, "long -> int ", "long = 5l");

	i = 5l;
	if (i != 5)
		error(s1, "long -> int ", "long = 5l");

	l = 0;
	i = l;
	if (i)
		error(s1, "long -> int ", "long = 0l");

	i = 0l;
	if (i)
		error(s1, "long -> int ", "long = 0l");

	l = -5;
	i = l;
	if (i != -5)
		error(s1, "long -> int ", "long = -5l");

	i = -5l;
	if (i != -5)
		error(s1, "long -> int ", "long = -5l");

	/* ptr -> int */

	p = &i;
	i = (int) p;
	if (i != (int)(&i))
		error(s1, "ptr -> int ", "ptr = &i");

	pd = &d;
	i = (int) pd;
	if (i != (int)(&d))
		error(s1, "ptr -> int ", "ptr = &d");

	/* short -> int */

	s = 5;
	i = s;
	if (i != 5)
		error(s1, "short -> int ", "short = 5");

	s = 0;
	i = s;
	if (i)
		error(s1, "short -> int ", "short = 0");

	s = -5;
	i = s;
	if (i != -5)
		error(s1, "short -> int ", "short = -5");

	/* register -> int */

	r = 5;
	i = r;
	if (i != 5)
		error(s1, "register -> int ", "register = 5");

	r = 0;
	i = r;
	if (i)
		error(s1, "register -> int ", "register = 0");

	r = -5;
	i = r;
	if (i != -5)
		error(s1, "register -> int ", "register = -5");

	/* char -> int */

	c = 'a';
	i = c;
	if (i != 97)
		error(s1, "char -> int ", "char = 'a'");

	i = 'a';
	if (i != 97)
		error(s1, "char -> int ", "char = 'a'");

	/* unsigned -> int */

	u = 5;
	i = u;
	if (i != 5)
		error(s1, "unsigned -> int ", "unsigned = 5");

	u = 0;
	i = u;
	if (i)
		error(s1, "unsigned -> int ", "unsigned = 0");

	u = -5;
	i = u;
	if (i != -5)
		error(s1, "unsigned -> int ", "unsigned = -5");

}

asgnfieldcvn()
{
	char *s1 = "assignment conversion";
	int i, *p;
	double d;
	long l;
	short s;
	register r;
	char c;
	unsigned u;
	struct {
		unsigned f1 : 5;
		unsigned f2 : 8;
		unsigned f3 : 25;
	} flag;

	/* int -> field */

	i = 5;
	flag.f3 = i;
	if (flag.f3 != 5)
		error(s1, "int -> field", "int = 5");

	flag.f3 = 5;
	if (flag.f3 != 5)
		error(s1, "int -> field", "int = 5");
	i = 0;
	flag.f3 = i;
	if (flag.f3)
		error(s1, "int -> field", "int = 0");

	flag.f3 = 0;
	if (flag.f3)
		error(s1, "int -> field", "int = 0");

	/* double -> field */

	d = 5.0;
	flag.f3 = d;
	if (flag.f3 != 5)
		error(s1, "double -> field", "double = 5.0");

	flag.f3 = 5.0;
	if (flag.f3 != 5)
		error(s1, "double -> field", "double = 5.0");

	d = 0.0;
	flag.f3 = d;
	if (flag.f3)
		error(s1, "double -> field", "double = 0.0");

	flag.f3 = 0.0;
	if (flag.f3)
		error(s1, "double -> field", "double = 0.0");

	/* long -> field */

	l = 5;
	flag.f3 = l;
	if (flag.f3 != 5)
		error(s1, "long -> field", "long = 5");

	flag.f3 = 5l;
	if (flag.f3 != 5)
		error(s1, "long -> field", "long = 5");

	l = 0;
	flag.f3 = l;
	if (flag.f3)
		error(s1, "long -> field", "long = 0");

	flag.f3 = 0l;
	if (flag.f3)
		error(s1, "long -> field", "long = 0");

	/* ptr -> field */

	p = &i;
	flag.f3 = (int) p;
	if (flag.f3 != (int)(&i))
		error(s1, "ptr -> field", "ptr = &i");

	/* short -> field */

	s = 5;
	flag.f3 = s;
	if (flag.f3 != 5)
		error(s1, "short -> field", "short = 5");

	s = 0;
	flag.f3 = s;
	if (flag.f3)
		error(s1, "short -> field", "short = 0");

	/* register -> field */

	r = 5;
	flag.f3 = r;
	if (flag.f3 != 5)
		error(s1, "register -> field", "register = 5");

	r = 0;
	flag.f3 = r;
	if (flag.f3)
		error(s1, "register -> field", "register = 0");

	/* char -> field */

	c = 'a';
	flag.f3 = c;
	if (flag.f3 != 97)
		error(s1, "char -> field", "char = 'a'");

	flag.f3 = 'a';
	if (flag.f3 != 97)
		error(s1, "char -> field", "char = 'a'");

	/* unsigned -> field */

	u = 5;
	flag.f3 = u;
	if (flag.f3 != 5)
		error(s1, "unsigned -> field", "unsigned = 5");

	u = 0;
	flag.f3 = u;
	if (flag.f3)
		error(s1, "unsigned -> field", "unsigned = 0");

}

asgndoublecvn()
{
	char *s1 = "assignment conversion";
	int i;
	double d;
	long l;
	register r;
	char c;
	unsigned u;
	struct {
		unsigned f1 : 5;
		unsigned f2 : 8;
		unsigned f3 : 25;
	} flag;

	/* int -> double */

	i = 5;
	d = i;
	if (d != 5.0)
		error(s1, "int -> double", "int = 5");

	d = 5;
	if (d != 5.0)
		error(s1, "int -> double", "int = 5");

	i = 0;
	d = i;
	if (d)
		error(s1, "int -> double", "int = 0");

	d = 0;
	if (d)
		error(s1, "int -> double", "int = 0");

	i = -5;
	d = i;
	if (d != -5.0)
		error(s1, "int -> double", "int = -5");

	d = -5;
	if (d != -5.0)
		error(s1, "int -> double", "int = -5");

	/* field -> double */

	flag.f3 = 5;
	d = flag.f3;
	if (d != 5.0)
		error(s1, "field -> double", "field = 5");

	flag.f3 = 0;
	d = flag.f3;
	if (d)
		error(s1, "field -> double", "field = 0");

	/* long -> double */

	l = 5;
	d = l;
	if (d != 5.0)
		error(s1, "long -> double", "long = 5");

	d = 5l;
	if (d != 5.0)
		error(s1, "long -> double", "long = 5");

	l = 0;
	d = l;
	if (d)
		error(s1, "long -> double", "long = 0");

	d = 0l;
	if (d)
		error(s1, "long -> double", "long = 0");

	l = -5;
	d = l;
	if (d != -5.0)
		error(s1, "long -> double", "long = -5");

	d = -5l;
	if (d != -5.0)
		error(s1, "long -> double", "long = -5");

	/* ptr -> double - illegal conversion */

	/* register -> double */

	r = 5;
	d = r;
	if (d != 5.0)
		error(s1, "register -> double", "register = 5");

	r = 0;
	d = r;
	if (d)
		error(s1, "register -> double", "register = 0");

	r = -5;
	d = r;
	if (d != -5.0)
		error(s1, "register -> double", "register = -5");

	/* char -> double */

	c = 'a';
	d = c;
	if (d != 97.0)
		error(s1, "char -> double", "char = 'a'");


	d = 'a';
	if (d != 97.0)
		error(s1, "char -> double", "char = 'a'");

	/* unsigned -> double */

	u = 5;
	d = u;
	if (d != 5.0)
		error(s1, "unsigned -> double", "unsigned = 5");

	u = 0;
	d = u;
	if (d)
		error(s1, "unsigned -> double", "unsigned = 0");
}

asgnlongcvn()
{
	char *s1 = "assignment conversion";
	int i, *p;
	double d;
	long l;
	short s;
	register r;
	char c;
	unsigned u;
	struct {
		unsigned f1 : 5;
		unsigned f2 : 8;
		unsigned f3 : 25;
	} flag;

	/* int -> long */

	i = 5;
	l = i;
	if (l != 5)
		error(s1, "int -> long", "int = 5");

	i = 0;
	l = i;
	if (l)
		error(s1, "int -> long", "int = 0");

	i = -5;
	l = i;
	if (l != -5)
		error(s1, "int -> long", "int = -5");

	/* field -> long */

	flag.f2 = 5;
	l = flag.f2;
	if (l != 5)
		error(s1, "field -> long", "field = 5");

	flag.f2 = 0;
	l = flag.f2;
	if (l != 0)
		error(s1, "field -> long", "field = 0");

	/* double -> long */

	d = 5.0;
	l = d;
	if (l != 5)
		error(s1, "double -> long", "double = 5.0");

	l = 5.0;
	if (l != 5)
		error(s1, "double -> long", "double = 5.0");

	d = 0.0;
	l = d;
	if (l)
		error(s1, "double -> long", "double = 0.0");

	l = 0.0;
	if (l != 0)
		error(s1, "double -> long", "double = 0.0");

	d = -5.0;
	l = d;
	if (l != -5)
		error(s1, "double -> long", "double = -5.0");

	l = -5.0;
	if (l != -5)
		error(s1, "double -> long", "double = -5.0");

	/* ptr -> long */

	p = &i;
	l = (long) p;
	if (l != (long)(&i))
		error(s1, "ptr -> long", "ptr = &i");

	/* short -> long */

	s = 5;
	l = s;
	if (l != 5)
		error(s1, "short -> long", "short = 5");

	s = 0;
	l = s;
	if (l)
		error(s1, "short -> long", "short = 0");

	s = -5;
	l = s;
	if (l != -5)
		error(s1, "short -> long", "short = -5");

	/* register -> long */

	r = 5;
	l = r;
	if (l != 5)
		error(s1, "register -> long", "register = 5");

	r = 0;
	l = r;
	if (l)
		error(s1, "register -> long", "register = 0");

	r = -5;
	l = r;
	if (l != -5)
		error(s1, "register -> long", "register = -5");

	/* char -> long */

	c = 'a';
	l = c;
	if (l != 97)
		error(s1, "char -> long", "char = 'a'");

	l = 'a';
	if (l != 97)
		error(s1, "char -> long", "char = 'a'");

	/* unsigned -> long */

	u = 5;
	l = u;
	if (l != 5)
		error(s1, "unsigned -> long", "unsigned = 5");

	u = 0;
	l = u;
	if (l)
		error(s1, "unsigned -> long", "unsigned = 0");
}

asgnptrcvn()
{
	char *s1 = "assignment conversion";
	int i, *p;
	double d, *pd;
	long l;
	short s;
	register r;
	char c;
	unsigned u;
	struct {
		unsigned f1 : 5;
		unsigned f2 : 8;
		unsigned f3 : 25;
	} flag;

	/* int -> ptr */

	i = 5;
	p = (int *) i;
	if (((int) p) != 5)
		error(s1, "int -> ptr", "int = 5");

	/* field -> ptr */

	flag.f1 = 5;
	p = (int *) flag.f1;
	if (((int) p) != 5)
		error(s1, "field -> ptr", "field = 5");

	/* double -> ptr - illegal conversion */

	/* long -> ptr */

	l = 5;
	p = (int *) l;
	if (((int) p) != 5)
		error(s1, "long -> ptr", "long = 5");

	/* ptr -> ptr */

	pd = &d;
	p = (int *) pd;
	if (p != (int *)(&d))
		error(s1, "ptr -> ptr", "ptr = double");

	/* short -> ptr */

	s = 5;
	p = (int *) s;
	if (p != (int *) 5)
		error(s1, "short -> ptr", "short = 5");

	/* register -> ptr */

	r = 5;
	p = (int *) r;
	if (p != (int *) 5)
		error(s1, "register -> ptr", "register = 5");

	/* char -> ptr */

	c = 'a';
	p = (int *) c;
	if (p != (int *) 97)
		error(s1, "char -> ptr", "char = 'a'");

	/* unsigned -> ptr */

	u = 5;
	p = (int *) u;
	if (p != (int *) 5)
		error(s1, "unsigned -> ptr", "unsigned = 5");
}

asgnshortcvn()
{
	char *s1 = "assignment conversion";
	int i;
	double d;
	long l;
	short s;
	char c;
	unsigned u;
	struct {
		unsigned f1 : 5;
		unsigned f2 : 8;
		unsigned f3 : 25;
	} flag;

	/* int -> short */

	i = 5;
	s = i;
	if (s != 5)
		error(s1, "int -> short", "int = 5");

	i = 0;
	s = i;
	if (s)
		error(s1, "int -> short", "int = 0");

	i = -5;
	s = i;
	if (s != -5)
		error(s1, "int -> short", "int = -5");

	/* field -> short */

	flag.f2 = 5;
	s = flag.f2;
	if (s != 5)
		error(s1, "field -> short", "field = 5");

	flag.f2 = 0;
	s = flag.f2;
	if (s != 0)
		error(s1, "field -> short", "field = 0");

	/* double -> short */

	d = 5.0;
	s = d;
	if (s != 5)
		error(s1, "double -> short", "double = 5.0");

	s = 5.0;
	if (s != 5.0)
		error(s1, "double -> short", "double = 5.0");

	d = 0.0;
	s = d;
	if (s)
		error(s1, "double -> short", "double = 0.0");

	d = -5.0;
	s = d;
	if (s != -5)
		error(s1, "double -> short", "double = -5.0");

	/* long -> short */

	l = 5;
	s = l;
	if (s != 5)
		error(s1, "long -> short", "long = 5");

	l = 0;
	s = l;
	if (s)
		error(s1, "long -> short", "long = 0");

	l = -5;
	s = l;
	if (s != -5)
		error(s1, "long -> short", "long = -5");

	/* char -> short */

	c = 'a';
	s = c;
	if (s != 97)
		error(s1, "char -> short", "char = 'a'");

	s = 'a';
	if (s != 97)
		error(s1, "char -> short", "char = 'a'");

	/* unsigned -> short */

	u = 5;
	s = u;
	if (s != 5)
		error(s1, "unsigned -> short", "unsigned = 5");

	u = 0;
	s = u;
	if (s)
		error(s1, "unsigned -> short", "unsigned = 0");

	u = -5;
	s = u;
	if (s != -5)
		error(s1, "unsigned -> short", "unsigned = -5");
}

asgncharcvn()
{
	char *s1 = "assignment conversion";
	int i, *p;
	double d;
	long l;
	short s;
	register r;
	char c;
	unsigned u;
	struct {
		unsigned f1 : 5;
		unsigned f2 : 8;
		unsigned f3 : 25;
	} flag;

	/* int -> char */

	i = 97;
	c = i;
	if (c != 'a')
		error(s1, "int -> char", "int = 97");

	/* field -> char */

	flag.f3 = 97;
	c = flag.f3;
	if (c != 'a')
		error(s1, "field -> char", "field = 97");

	/* double -> char */

	d = 97.0;
	c = d;
	if (c != 'a')
		error(s1, "double -> char", "double = 97.0");

	/* long -> char */

	l = 97l;
	c = l;
	if (c != 'a')
		error(s1, "long -> char", "long = 97");

	/* ptr -> char */

	p = (int *) 97;
	c = (int) p;
	if (c != 'a')
		error(s1, "ptr -> char", "ptr = 97");

	/* short -> char */

	s = 97;
	c = s;
	if (c != 'a')
		error(s1, "short -> char", "short = 97");

	/* register -> char */

	r = 97;
	c = r;
	if (c != 'a')
		error(s1, "register -> char", "register = 97");

	/* unsigned -> char */

	u = 97;
	c = u;
	if (c != 'a')
		error(s1, "unsigned -> char", "unsigned = 97");
}

asgnunsigncvn()
{
	char *s1 = "assignment conversion";
	int i, *p;
	double d;
	long l;
	short s;
	register r;
	char c;
	unsigned u;

	/* int -> unsigned */

	i = 5;
	u = i;
	if (u != 5)
		error(s1, "int -> unsigned", "int = 5");

	i = 0;
	u = i;
	if (u)
		error(s1, "int -> unsigned", "int = 0");

	i = -5;
	u = i;
	if (u != (unsigned) -5)
		error(s1, "int -> unsigned", "int = -5");

	/* double -> unsigned */

	d = 5.0;
	u = d;
	if (u != 5)
		error(s1, "double -> unsigned", "double = 5.0");

	d = 0.0;
	u = d;
	if (u)
		error(s1, "double -> unsigned", "double = 0.0");

	d = -5.0;
	u = d;
	if (u != (unsigned) -5)
		error(s1, "double -> unsigned", "double = -5.0");

	/* long -> unsigned */

	l = 5;
	u = l;
	if (u != 5)
		error(s1, "long -> unsigned", "long = 5");

	l = 0;
	u = l;
	if (u)
		error(s1, "long -> unsigned", "long = 0");

	l = -5;
	u = l;
	if (u != (unsigned) -5)
		error(s1, "long -> unsigned", "long = -5");

	/* ptr -> unsigned */

	p = (int *) 5;
	u = (unsigned) p;
	if (u != 5)
		error(s1, "ptr -> unsigned", "ptr = 5");

	/* short -> unsigned */

	s = 5;
	u = s;
	if (u != 5)
		error(s1, "short -> unsigned", "short = 5");

	s = 0;
	u = s;
	if (u)
		error(s1, "short -> unsigned", "short = 0");

	s = -5;
	u = s;
	if (u != (unsigned) -5)
		error(s1, "short -> unsigned", "short = -5");

	/* register -> unsigned */

	r = 5;
	u = r;
	if (u != 5)
		error(s1, "register -> unsigned", "register = 5");

	r = 0;
	u = r;
	if (u)
		error(s1, "register -> unsigned", "register = 0");

	r = -5;
	u = r;
	if (u != (unsigned) -5)
		error(s1, "register -> unsigned", "register = -5");

	/* char -> unsigned */

	c = 'a';
	u = c;
	if (u != 97)
		error(s1, "char -> unsigned", "char = 97");
}

/* NOSTRICT */
/* VARARGS */
error(s1, t1, t2)
char *s1, *t1, *t2;
{
	printf("fatal error:  %s %s: %s\n", s1, t1, t2);
	exit(2);
}
