/*
 * test file for unsigned shorts
 */

unsigned short x1 = 32;
unsigned short y1 = -10;
unsigned short unarray[100];

struct {
	unsigned short a1, b1;
       } z1;

main()
{
	unsign1();
	unsign2();
	unsign3();
}

unsign1()
{
	unsigned short a, b, *c, x, y, z;
	register int j;
	unsigned short copy(), (*px)();

	j = (int) &y1;
	j -= (int) &x1;
	if (j != 2)
	        error("size", "&x", "&y");
	if (sizeof(z1) != 4)
	        error("sizeof", "z", "");
	px = copy;

	/*
	 * ++, --
	 */
	x = 12;
	x++;
	if (x != 13)
		error("++", "x", "pos");

	x = -5;
	x++;
	if (x != (unsigned) -4)
		error("++", "x", "neg");

	x = 12;
	y = 5;
	z = (x++) + y;
	if (z != 17)
		error("+", "(x++)", "y");

	z = (++x) + y;
	if (z != 19)
		error("+", "(++x)", "y");

	z = (b = y) + (a = (x++) + y);
	if (z != 24)
		error("+", "(b = y++)", "(a = (x++) + y)");

	z = (b = y) + (a = (++x) + y);
	if (z != 26)
		error("+", "(b = y++)", "(a = (++x) + y)");

	x = 25;
	x--;
	if (x != 24)
		error("--", "x", "pos");

	x = -10;
	x--;
	if (x != (unsigned) -11)
		error("--", "x", "neg");

	x = 12;
	++x;
	if (x != 13)
		error("++", "x", "pos");

	x = -5;
	++x;
	if (x != (unsigned) -4)
		error("++", "x", "neg");

	x = 25;
	--x;
	if (x != 24)
		error("--", "x", "pos");

	x = -10;
	--x;
	if (x != (unsigned) -11)
		error("--", "x", "neg");

	x = 12;
	y = 5;
	z = (x--) + y;
	if (z != 17)
		error("+", "(x--)", "y");

	z = (--x) + y;
	if (z != 15)
		error("+", "(--x)", "y");

	z = (b = y) + (a = (x--) + y);
	if (z != 20)
		error("+", "(b = y)", "(a = (x--) + y)");

	z = (b = y) + (a = (--x) + y);
	if (z != 18)
		error("+", "(b = y)", "(a = (--x) + y)");

	/*
	 * >>, =>>
	 */

	x = 24;
	y = 2;
	z = x >> y;
	if (z != 6)
		error(">>", "x", "y");

	z = (b = 256) >> (a = x >> y);
	if (z != 4)
		error(">>", "(b = 256)", "(a = x >> y)");

	z = x >> ((*px)(2));
	if (z != 6)
		error(">>", "x", "((*px)(2))");

	x = 24;
	y = 3;
	x >>= y;
	if (x != 3)
		error("=>>", "x", "y");
	x = 24;
	y = 2;
	z = 256;
	z >>= (a = x>>y);
	if (z != 4)
		error("=>>", "z", "(a = x >> y)");
	z = 256;
	z >>= (x >> ((*px)(3)));
	if (z != 32)
		error("=>>", "z", "(x >> ((*px)(3)))");
	c = &z;
	z = 256;
	*c >>= y;
	if (*c != 64)
		error("=>>", "*c", "y");
	z = 256;
	*c >>= (a = x>>y);
	if (*c != 4)
		error("=>>", "*c", "(a = x >> y)");
	z = 256;
	*c >>= (x >> ((*px)(3)));
	if (*c != 32)
		error("=>>", "*c", "(x >> ((*px)(3)))");

	/*
	 * <<, =<<
	 */

	x = 24;
	y = 2;
	z = x << y;
	if (z != 96)
		error("<<", "x", "y");

	z = (b = 6) << (a = y << 2);
	if (z != 1536)
		error("<<", "(b = 6)", "(a = y << 2)");

	z = x << ((*px)(2));
	if (z != 96)
		error("<<", "x", "((*px)(2))");

	x = 24;
	y = 3;
	x <<= y;
	if (x != 192)
		error("=<<", "x", "y");

	x = 2;
	y = 2;
	z = 6;
	z <<= (a = x << y);
	if (z != 1536)
		error("=<<", "z", "(a = x << y)");

	z = 6;
	z <<= (x << ((*px)(2)));
	if (z != 1536)
		error("=<<", "z", "(x << ((*px)(2)))");

	c = &z;
	z = 16;
	*c <<= y;
	if (*c != 64)
		error("=<<", "*c", "y");

	z = 6;
	*c <<= (a = x << y);
	if (*c != 1536)
		error("=<<", "*c", "(a = x << y)");

	z = 6;
	*c <<= (x << ((*px)(2)));
	if (*c != 1536)
		error("=<<", "*c", "(x << ((*px)(2)))");

	/*
	 * &, =&
	 */

	x = 12;
	y = 5;
	z = x & y;
	if (z != 4)
		error("&", "x", "y");

	z = (b = y) & (a = x & y);
	if (z != 4)
		error("&", "b = y" , "(a = x & y)");

	z = x & ((*px)(5));
	if (z != 4)
		error("&", "x" , "((*px)(5))");

	x &= y;
	if (x != 4)
		error("&=", "x", "y");

	x = 12;
	z = 20;
	z &= (b = x) & (a = x & y);
	if (z != 4)
		error("&=", "z" , "(b = x) & (a = x & y)");

	z = 20;
	z &= x & ((*px)(5));
	if (z != 4)
		error("&=", "z" , "x & ((*px)(5))");

	c = &x;
	x = 12;
	*c &= y;
	if (*c != 4)
		error("&=", "*c", "y");

	c = &z;
	z = 20;
	x = 12;
	*c &= (b = x) & (a = x & y);
	if (*c != 4)
		error("&=", "*c" , "(b = x) & (a = x & y)");

	*c = 20;
	*c &= x & ((*px)(5));
	if (*c != 4)
		error("&=", "*c" , "x & ((*px)(5))");

	/*
	 * |, =|
	 */

	x = 12;
	y = 5;
	z = x | y;
	if (z != 13)
		error("|", "x", "y");

	y = 7;
	z = (b = y) | (a = x | 5);
	if (z != 15)
		error("|", "b = y" , "(a = x | 5)");

	z = x | ((*px)(5));
	if (z != 13)
		error("|", "x" , "((*px)(5))");

	y = 5;
	x |= y;
	if (x != 13)
		error("|=", "x", "y");

	x = 12;
	z = 20;
	z |= (b = 7) | (a = x | y);
	if (z != 31)
		error("|=", "z" , "(b = x) | (a = x | y)");

	z = 20;
	z |= x | ((*px)(5));
	if (z != 29)
		error("|=", "z" , "x | ((*px)(5))");

	c = &x;
	x = 12;
	*c |= y;
	if (*c != 13)
		error("|=", "*c", "y");

	c = &z;
	z = 20;
	x = 12;
	y = 5;
	*c |= (b = x) | (a = x | y);
	if (*c != 29)
		error("|=", "*c" , "(b = x) | (a = x | y)");

	*c = 20;
	*c |= x | ((*px)(5));
	if (*c != 29)
		error("|=", "*c" , "x | ((*px)(5))");

	/*
	 * ^, =^
	 */

	x = 12;
	y = 5;
	z = x ^ y;
	if (z != 9)
		error("^", "x", "y");

	y = 7;
	z = (b = y) ^ (a = x ^ 5);
	if (z != 14)
		error("^", "b = y" , "(a = x ^ 5)");

	z = x ^ ((*px)(5));
	if (z != 9)
		error("^", "x" , "((*px)(5))");

	y = 5;
	x ^= y;
	if (x != 9)
		error("^=", "x", "y");

	x = 12;
	z = 20;
	z ^= (b = 7) ^ (a = x ^ y);
	if (z != 26)
		error("^=", "z" , "(b = x) ^ (a = x ^ y)");

	z = 20;
	z ^= x ^ ((*px)(5));
	if (z != 29)
		error("^=", "z" , "x ^ ((*px)(5))");

	c = &x;
	x = 12;
	*c ^= y;
	if (*c != 9)
		error("^=", "*c", "y");

	c = &z;
	z = 20;
	x = 12;
	y = 5;
	*c ^= (b = x) ^ (a = x ^ y);
	if (*c != 17)
		error("^=", "*c" , "(b = x) ^ (a = x ^ y)");

	*c = 20;
	*c ^= x ^ ((*px)(5));
	if (*c != 29)
		error("^=", "*c" , "x ^ ((*px)(5))");
}

unsign2()
{
	unsigned short q, a, b, *c, d, e, x, y, z, arr[10], *ptr;
	int i;
	unsigned short copy(), (*px)();

	/*
	 * +, +=
	 */

	px = copy;
	x = 12;
	y = 5;
	z = x + y;
	if (z != 17)
		error("+", "x", "y");
	z = (b = y) + (a = x + y);
	if (z != 22)
		error("+", "(b = y)", "(a = x + y)");
	z = x + ((*px)(5));
	if (z != 17)
		error("+", "x", "(*px)(5)");
	z += y;
	if (z != 22)
		error("+=", "x", "y");
	z += (a = x + y);
	if (z != 39)
		error("+=", "z", "(a = x + y)");
	z += (x + ((*px)(5)));
	if (z != 56)
		error("+=", "z", "(x + ((*px)(5)))");
	c = &d;
	d = 10;
	*c += y;
	if (*c != 15)
		error("+=", "*c", "y");
	*c += ((a = x + y) + 2);
	if (*c != 34)
		error("+=", "*c", "(a = x + y)");
	b = 10;
	z += ((q = x + z) + (a = b + z) + (*c += (e = x + y)));
	if (z != 241)
		error("+=", "z", "((a = x + z) + (a = b + z) + (*c += (e = x + y)))");

	/*
	 * -, -=
	 */

	x = 12;
	y = 5;
	z = x - y;
	if (z != 7)
		error("-", "x", "y");
	z = (b = y) - (a = x - y);
	if (z != (unsigned) -2)
		error("-", "(b = y)", "(a = x - y)");
	z = x - ((*px)(5));
	if (z != 7)
		error("-", "x", "(*px)(5)");
	z -= y;
	if (z != 2)
		error("-=", "x", "y");
	z -= (a = x - y);
	if (z != (unsigned) -5)
		error("-=", "z", "(a = x - y)");
	z -= (x - ((*px)(5)));
	if (z != (unsigned) -12)
		error("-=", "z", "(x - ((*px)(5)))");
	c = &d;
	d = 10;
	*c -= y;
	if (*c != 5)
		error("-=", "*c", "y");
	*c -= ((a = x - y) - 2);
	if (*c)
		error("-=", "*c", "(a = x - y)");
	b = 10;
	z -= ((q = x - z) - (a = b - z) - (*c -= (e = x - y)));
	if (z != (unsigned) -21)
		error("-=", "z", "((a = x - z) - (a = b - z) - (*c -= (e = x - y)))");

	/*
	 * *, *=
	 */

	x = 12;
	y = 5;
	z = x * y;
	if (z != 60)
		error("*", "x", "y");
	z = (b = y) * (a = x * y);
	if (z != 300)
		error("*", "(b = y)", "(a = x * y)");
	z = x * ((*px)(5));
	if (z != 60)
		error("*", "x", "(*px)(5)");
	z *= y;
	if (z != 300)
		error("*=", "x", "y");
	z *= (a = x * y);
	if (z != 18000)
		error("*=", "z", "(a = x * y)");
	c = &d;
	d = 10;
	*c *= y;
	if (*c != 50)
		error("*=", "*c", "y");
	*c *= (a = x * y);
	if (*c != 3000)
		error("*=", "*c", "(a = x * y)");

	/*
	 * /, /=
	 */

	x = 12;
	y = 5;
	z = x / y;
	if (z != 2)
		error("/", "x", "y");
	z = (b = y) / (a = 10 / y);
	if (z != 2)
		error("/", "(b = y)", "(a = 10 / y)");
	z = x / ((*px)(5));
	if (z != 2)
		error("/", "x", "(*px)(5)");
	z = 2;
	z /= y;
	if (z != 0)
		error("/=", "z", "y");
	z /= (a = x / y);
	if (z != 0)
		error("/=", "z", "(a = x / y)");
	z = 48;
	z /= (x / ((*px)(5)));
	if (z != 24)
		error("/=", "z", "(x / ((*px)(5)))");
	c = &d;
	d = 10;
	*c /= y;
	if (*c != 2)
		error("/=", "*c", "y");
	d = 4;
	*c /= (a = x / y);
	if (*c != 2)
		error("/=", "*c", "(a = x / y)");


	/*
	 * mod, =mod
	 */

	x = 12;
	y = 5;
	z = x % y;
	if (z != 2)
		error("%", "x", "y");
	z = (b = y) % (a = 13 % y);
	if (z != 2)
		error("%", "(b = y)", "(a = 13 % y)");
	z = x % ((*px)(5));
	if (z != 2)
		error("%", "x", "(*px)(5)");
	z = 2;
	z %= y;
	if (z != 2)
		error("%=", "z", "y");
	z %= (a = x % y);
	if (z != 0)
		error("%=", "z", "(a = x % y)");
	z = 48;
	z %= (x % ((*px)(5)));
	if (z != 0)
		error("%=", "z", "(x % ((*px)(5)))");
	c = &d;
	d = 10;
	*c %= y;
	if (*c != 0)
		error("%=", "*c", "y");
	d = 7;
	*c %= (a = x % y);
	if (*c != 1)
		error("%=", "*c", "(a = x % y)");

	/*
	 * negation
	 */

	z = 12;
	z = -z;
	if (z != (unsigned) -12)
		error("negation", "z", "-12");

	z = 0;
	z = -z;
	if (z)
		error("negation", "z", "0");

	z = -12;
	z = -z;
	if (z != 12)
		error("negation", "z", "12");

	z = 12;
	z = -z;
	z = -z;
	if (z != 12)
		error("negation", "z", "-z");

	/*
	 * complement
	 */

	y = 0;
	y = ~y;
	if (y != (unsigned) -1)
		error("~", "y", "y");
	y = ~y;
	if (y != 0)
		error("~", "y", "y");
	/*
	 * arrays
	 */

	for (i = 0; i < 9; i++)
		arr[i] = i;

	ptr = arr;
	for (i = 0; i < 9; i++)
		if (*ptr++ != i)
			error("array access", "*ptr", "");

	for (i = 0; i < 9; i++)
		unarray[i] = i;

	ptr = unarray;
	for (i = 0; i < 9; i++)
		if (*ptr++ != i)
			error("external array access", "*ptr", "");
}

unsigned short copy(x)
unsigned short x;
{
	return(x);
}


unsign3(){
	unsigned short int a, b;

	a = 0xff01;

	/*
	 * comparison
	 */
	if (a < 3) error2("<", a, 3);
	if (a < 0) error2("<", a, 0);

	/*
	 * /, %
	 */
	b = a;
	if (b != 65281) error2("=", b, (int) a);
	b /= 3;
	if (b != 21760) error2("/", b, 3);
	if (a%4 != 1) error2("%", a, 4);
	}

error(t1, t2, t3)
char *t1, *t2, *t3;
{
	printf("fatal error:  unsigned short  %s: %s %s\n", t1, t2, t3);
	exit(2);
}

error2(t1, t2, t3)
char *t1;
unsigned int t2;
int t3;
{
	printf("fatal error:  unsigned short  %s: %4x %4x\n", t1, t2, t3);
	exit(2);
}
