/*
 * The user structure.
 * One allocated per process.
 * Contains all per process data
 * that doesn't need to be referenced
 * while the process is swapped.
 * The user block is USIZE pages
 * long; is pointed to by the external
 * variable u; contains the system
 * stack per user; is cross referenced
 * with the proc structure for the
 * same process.
 */
struct  user
{
	struct {                       /* program state vector */
		int     ps_sig;         /* signal being processed */
		int     ps_svc;         /* svc code (loc 136) */
		int     ps_pgm;         /* pgm code (loc 140) */
		int     ps_trans;       /* translation exception address (loc 144) */
	} u_ps;
	char    u_sig[(NSIG+8)/8];    /* signals received so far */
	char    u_sigtr[(NSIG+8)/8];  /* signals being traced */
        int     u_rsav[2];            /* save r12,r13 when exchanging   stacks */
        int     u_tpages;               /* pages for text segment */
        int     u_lpages;               /* pages for linkable segment */
        int     u_gpages;               /* pages for global segment */
        int     u_dpages;               /* pages for data segment */
        int     u_spages;               /* pages for stack segment */
        int     u_tsize;                /* text size (pages) */
	int     u_gsize;                /* global size (pages) */
        int     u_dsize;                /* data size (pages) */
        int     u_ssize;                /* stack size (pages) */
        int     u_rlist;                /* list of entries in process */
        int     u_linkend;              /* end of link segment */
        int     u_globtop;              /* top of glob segment */
        int     u_dataend;              /* end of data segment */
        int     u_procp;                /* pointer to proc structure */
        char    u_segflg;               /* flag for IO; user or kernel space */
        char    u_error;                /* return error code */
        char    u_uid;                  /* effective user id */
        char    u_gid;                  /* effective group id */
        char    u_ruid;                 /* real user id */
        char    u_rgid;                 /* real group id */
        char    *u_base;                /* base address for IO */
        char    *u_count;               /* bytes remaining for IO */
        char    *u_offset;              /* offset in file for IO */
        int     *u_cdir;                /* pointer to inode of current directory */
        char    u_dbuf[DIRSIZ];         /* current pathname component */
        char    *u_dirp;                /* current pointer to inode */
        char    u_dent[DIRSIZ+2];      /* current directory entry */
        int     *u_pdir;                /* inode of parent directory of dirp */
        int     u_ofile[NOFILE];        /* pointers to file structures of open files */
        int     u_arg[5];               /* arguments to current system call */
        int     u_qsav[2];              /* label variable for quits and interrupts */
        int     u_signal[NSIG + 1];     /* disposition of signals */
        char    u_cmd[DIRSIZ];          /* command name */
        int     u_rdwr;                   /* read/write count */
        int     *u_ar0;                   /* addr of regs saved at intr */
        char    u_info[INFSIZ];         /* user info */
        char    u_name[NAMESIZE+1];     /* name of the process */
        char    u_intflg;                 /* catch intr from sys */
        /*
         * kernel stack per user
         * extends from u + USIZE*PGSIZE
         * backward not to reach here
         */
} *u;

/* u_error codes */
#define ESYS	100
#define EFAULT  106
#define ENOREC  101
#define EPERM   1
#define ENOENT  2
#define ESRCH   3
#define EINTR   4
#define EIO     5
#define ENXIO   6
#define E2BIG   7
#define ENOEXEC 8
#define EBADF   9
#define ECHILD  10
#define EAGAIN  11
#define ENOMEM  12
#define EACCES  13
#define ENOTBLK 15
#define EBUSY   16
#define EEXIST  17
#define EXDEV   18
#define ENODEV  19
#define ENOTDIR 20
#define EISDIR  21
#define EINVAL  22
#define ENFILE  23
#define EMFILE  24
#define ENOTTY  25
#define ETXTBSY 26
#define EFBIG   27
#define ENOSPC  28
#define ESPIPE  29
#define EROFS   30
#define EMLINK  31
#define EPIPE   32
#define ENOPSPC 33
#define EIMODE  34
#define EICCW   35
#define EFLOCK  36
#define ENOLINK 37
#define ENAME   38
#define EOUTXMT 39
#define ENOTREC 40
#define ENOXMT  41
#define ECANTRDY 42
#define ENOTLINK 42
#define ECANTSUSP 43
#define NOGLOBAL 44
#define EPETBUSY 45
#define EOUTSIG  46
#define ELOCKED  47
#define EIOTMO   48
#define EPANIC   49
#define EBADDB   50
#define EOUTXT   51
