/*
 * floating point to ascii
 */

#define NPOWS 169
#define POWONE 75
#define MAXDIG 17

extern double pow10[];

ftoa(x, buf, prec)
double x;
char *buf;
int prec;
{
	register char *p;
	register int i, c, exp;
	int ndig;
	double s, t, u;

	p = buf;
	if (x < 0) {
		*p++ = '-';
		x = -x;
		}
	if (x == 0.) {
		*p++ = '0';
		exp = 0;
		goto finish;
		}
	if(prec > 0) {
		x += 0.5 * pow10[POWONE+prec];
	} else if (prec < 0) {
		prec = -prec;
                for (i = 0; i < NPOWS; i++) {
                        if (pow10[i] <= x) break;
                        }
		x += 0.5 * pow10[i+prec];
	}
	for (i = 0; i < NPOWS; i++) {
		if (pow10[i] <= x) break;
		}
	exp = POWONE-i;
	s = 0;
	for(ndig = 0; s < x && ndig < MAXDIG; ndig++) {
		c = '0';
		t = pow10[i++];
		while ((u = s+t) <= x) {
			s = u;
			if (++c == '9') break;
			}
		*p++ = c;
		}
finish:
	*p = '\0';
	return(exp);
	}
