#include <stdio.h>
#include <stdioerr.h>

char	*malloc();


int
_filbuf(iop)
	register FILE *iop;
{
	static char smallbuf[_NFILE];

	if (iop == NULL)
		return(_stdioerr(EFPNULL, NULL));
	if (iop->_flag&_IOMEM)
		return(_mfilbuf(iop));
	if (iop->_flag&_IORW)
		iop->_flag |= _IOREAD;

	if(iop->_flag&_IOSTRG)
		return(EOF);
	if ((iop->_flag&_IOREAD) == 0)
		return(_stdioerr(EBADUSE, NULL, iop->_filename, "reading"));

tryagain:
	if (iop->_base == NULL) {
		if (iop->_flag & _IONBF) {
			iop->_base = &smallbuf[fileno(iop)];
			goto tryagain;
		}
		if ((iop->_base = malloc(BUFSIZ)) == NULL) {
			iop->_flag |= _IONBF;
			goto tryagain;
		}
		iop->_flag |= _IOMYBUF;
	}

	/* Flush stdout(if a terminal) if reading from a terminal or pipe at stdin */
	if(iop == stdin) {
		if((stdin->_flag & _IOGTTY) == 0) {
			if(isatty(fileno(stdin)) || isapipe(fileno(stdin)))
				stdin->_flag |= _IOTTY;
			stdin->_flag |= _IOGTTY;
		}
		if((stdin->_flag & _IOTTY) && (stdout->_flag & _IOTTY))
			fflush(stdout);
	}

	iop->_ptr = iop->_base;
	iop->_cnt = read(fileno(iop), iop->_ptr, iop->_flag&_IONBF?1:BUFSIZ);
	if (--iop->_cnt < 0) {
		if (iop->_cnt == -1) {
                        if (iop->_flag&_IOEOF)
				_stdioerr(EPASTEOF, NULL, iop->_filename);
			iop->_flag |= _IOEOF;
			if (iop->_flag & _IORW)
				iop->_flag &= ~_IOREAD;
		} else {
			iop->_flag |= _IOERR;
			_stdioerr(EIO, NULL, "reading", iop->_filename);
		}
		iop->_cnt = 0;
		return(EOF);
	}
	return(*iop->_ptr++ & 0377);
}
