#include <stdio.h>
#include <stdioerr.h>

char	*malloc();

int
_flsbuf(c, iop)
	int c;
	register FILE *iop;
{
	register char *base;
	register n, rn;
	char c1;
	extern char _sobuf[];
	extern int errno;

	if (iop == NULL)
		return(_stdioerr(EFPNULL, "_flsbuf"));
	if (iop->_flag&_IOMEM)
		return(_mflsbuf(c, iop));
	if (iop->_flag&_IORW) {
		iop->_flag |= _IOWRT;
		iop->_flag &= ~_IOEOF;
	}
	if ((iop->_flag&_IOWRT) == 0 || iop->_flag&_IOSTRG)
		return(_stdioerr(EBADUSE, NULL, iop->_filename, "writing"));

tryagain:
	if (iop->_flag & _IONBF) {
		c1 = c;
		rn = 1;
		n = write(fileno(iop), &c1, rn);
		iop->_cnt = 0;
	} else {
		if ((base = iop->_base) == NULL) {
			if (iop == stdout) {
				if (isatty(fileno(stdout)))
					iop->_flag |= _IOTTY;
				iop->_flag |= _IOGTTY;
				iop->_base = _sobuf;
				iop->_ptr = _sobuf;
				goto tryagain;
			}
			if ((iop->_base = base = malloc(BUFSIZ)) == NULL) {
				iop->_flag |= _IONBF;
				goto tryagain;
			}
			iop->_flag |= _IOMYBUF;
			rn = n = 0;
		} else if ((rn = n = iop->_ptr - base) > 0) {
			iop->_ptr = base;
			n = write(fileno(iop), base, n);
		}
		iop->_cnt = BUFSIZ - 1;
		*base++ = c;
		iop->_ptr = base;
	}
	if (rn != n) {
		iop->_flag |= _IOERR;
		if (n < 0)
		        return(_stdioerr(errno, NULL, "writing", iop->_filename));
		else
		        return(_stdioerr(EWRTCNT, NULL, iop->_filename));
	}
	return(c);
}

int
fflush(iop)
	register FILE *iop;
{
	register char *base;
	register n, nn;
	extern int errno;

	if (iop == NULL)
		_stdioerr(EFPNULL, "fflush");
	if (iop->_flag&_IOMEM)
		return(_mflush(iop));
	if ((iop->_flag & (_IONBF|_IOWRT)) == _IOWRT
	 && (base = iop->_base) != NULL && (n = iop->_ptr - base) > 0) {
		iop->_ptr = base;
		iop->_cnt = BUFSIZ;
		if ((nn = write(fileno(iop), base, n)) != n) {
			iop->_flag |= _IOERR;
			if (nn < 0)
			        return(_stdioerr(errno, "fflush", "writing", iop->_filename));
			else
			        return(_stdioerr(EWRTCNT, "fflush", iop->_filename));
		}
	}
	return(0);
}

/*
 * Flush buffers on exit
 */

_cleanup()
{
	register FILE *iop;
	extern FILE *_lastbuf;

	for(iop = _iob; iop < _lastbuf; iop++)
		if (iop->_flag&_IOMEM)
			memclose(iop);
		else
			fclose(iop);
}

int
fclose(iop)
	register FILE *iop;
{
	register r;

	if (iop == NULL)
		return(_stdioerr(EFPNULL, "fclose"));
	if (iop->_flag&_IOMEM)
	        return(memclose(iop));
	r = EOF;
	if (iop->_flag & (_IOREAD|_IOWRT|_IORW)
	    && (iop->_flag & _IOSTRG) == 0) {
		r = fflush(iop);
		if (close(fileno(iop)) < 0)
			r = EOF;
		if (iop->_flag & _IOMYBUF)
			free(iop->_base);
		if (iop->_flag & (_IOMYBUF|_IONBF))
			iop->_base = NULL;
	}
	iop->_flag &=
		~(_IOREAD|_IOWRT|_IONBF|_IOMYBUF|_IOERR|_IOEOF|_IOSTRG|_IORW|_IOGTTY|_IOTTY);
	iop->_cnt = 0;
	iop->_ptr = iop->_base;
	return(r);
}
