#include <stdio.h>
#include <stdioerr.h>

/*
 * Called by the gethw, getw, and getdw macros in
 *  stdio.h.  It is called when p->_cnt has gone negative.
 */

long
_getw(p, size)
	FILE    *p;
{
	register int    c;
        register int    ctr = size;
        long     wd = 0l;
 
	if (p == NULL)
		return(_stdioerr(EFPNULL, "_getw"));
	p->_cnt += size;
        while (ctr--) {
		c = getc(p);
                if (p->_flag&_IOEOF)
                        return(EOF);
                wd = (wd << 8) | (long) c;
        }
        return(wd);
}
