/
/ Function:
/   STRNCMP compares s1 and s2, and returns 0 if equal, -1 if s1 < s2,
/   and 1 if s1 > s2. At most n characters are compared.
/
/ Calling Sequence:
/   strncmp(s1, s2, n)  char *s1, *s2; int n;
/
	entry   strncmp
	using   strncmp,15
strncmp:
	lr	r0,sp
	s	sp,=f'64'
	stm	0,15,0(sp)
	st	0,52(,sp)
	lr	r12,sp

	l       r5,64(,sp)          / Get s1 address
	l       r6,68(,sp)          / Get s2 address
	l       r7,72(,sp)          / Get n
	ltr     r7,r7               / Zero or negative length ?
	bnp     7f                  / Yes, strings are equal
	la      r8,256              / Initial length
	l       r4,=v(_strtabl)     / Get trt table address
0:
	cr      r7,r8               / long?
	bh      1f                  / Yes, skip
	lr      r8,r7               / Last segment
1:
	lr      r9,r8               / decrement for silly trt
	bctr    r9,0
	ex      r9,xtrt             / Scan for null
	bc      8,6f                / CC=0?  No null found
	sr      r1,r6               / Else calc length to compare
	ex      r1,xclc             / Execute compare
        bh      3f
        bl      4f
7:
        sr      r0,r0               / Strings are equal
        b       5f
3:
        la      r0,1                / s1 > s2
        b       5f
4:
        l       r0,=f'-1'           / s1 < s2
5:
	lm      r1,r15,4(r12)       / Return
	br      r14
6:
	ex      r9,xclc             / Compare them
	bh      3b
	bl      4b
	ar      r5,r8               / Increment addresses
	ar      r6,r8
	sr      r7,r8               / Any more?
	bnz     0b                  / Yes, Continue scan
	sr      r0,r0
	b       5b                  / Equal enough

xclc:   clc     0(,r5),0(r6)        / Model clc 0(0,r5),0(r6)
xtrt:   trt     0(,r6),0(r4)        / Model trt - Scan for null
