	 entry  zero,exttrap,svctrap,pgmtrap,iotrap,mcktrap,ctrap
zero:
resnpsw: ds	0d
ipsw:    dc     x'000c0000',a(main)
resopsw: ds	0d
iccw1:   ds     d
iccw2:   ds     d
extopsw: ds	d
svcopsw: ds	d
pgmopsw: ds	d
mckopsw: ds	d
ioopsw:  ds     d
csw:     ds     d
caw:     ds     f
         ds     f
timer:   dc     f'-1'
         ds     f
extnpsw: ds	0d
         dc     x'001c0000',a(exttrap)
svcnpsw: ds	0d
         dc     x'001c0000',a(svctrap)
pgmnpsw: ds	0d
         dc     x'001c0000',a(pgmtrap)
mcknpsw: ds     0d
         dc     x'00180000',a(mcktrap)
ionpsw:  ds     0d
         dc     x'001c0000',a(iotrap)
         ds     f
         ds     h       / "processor address"
extcode: ds	h
svccode: ds	f
pgmcode: ds	f	/ program interrupt code in low order byte
tranexcp: ds	f	/ translation exection addres
monclass: ds	h	/ monitor class number
percode: ds	h
peraddr: ds	f
moncode: ds	f
         ds     2f
chanlid: ds     f
ioel:    ds     f
         ds     f       / limited channel logout
         ds     f
ioaddr:  ds     f       / i/o address

/ these next two are set by ipl program before we get control
. = zero + 192
         entry  ipladdr, sysname
ipladdr: ds     f       / ipl device address
sysname: ds     cl20    / unix name

/ save areas for machine checks
timersa: ds     d
clocksa: ds     d
mcic:   ds      d       / interrupt code
        ds      d
fsa:    ds      f       / failing storage address
regcode: ds     f       / region code
mcfla:  ds      12d     / fixed logout area
fprsa:  ds      4d      / floating reg save area
gprsa:  ds      16f     / general reg save area
crsa:   ds      16f     / control reg save area
/ extended logout starts here (not used on Amdahl machines)

/ end of fixed area

. = zero+512
/
usize = 1
pgsize = 4096
stkdrop = 108
probstat = x'01'
nowait = x'fd'

SVC = 1
PGM = 2
IO = 3
EXT = 4
MCK = 5
INIT = 6

/
/ Variables used by main, ctrap and the new psw routines
/
	entry   uptr
uptr:   ds      f       / pointer to u area of currently running process
ustack:	ds	f	/ temporary for user stack pointer
temp15: ds      f       / temporary for r15
	ds      0d      / for alignment
runpsw: ds      d       / psw to run user
wmask:  ds      c       / interrupt mask for window

/
/ area used by tryaddr
/
adpswsav:ds     d
trynpsw:ds      0d
	dc      x'000c0000',a(addrint)  / pgm new psw for tryaddr

/
/ VM (SEPP) accounting interface area (16 bytes, see trap.c)
/
	entry   vmai
vmai:   ds      2d
	ds      d       / extra doubleword at Amdahl

/
/ Second 2k will be write protected to prevent overwriting of zero code.
/ Would like to have put the code in the first 2k and protected it there
/ and also protected the new psw's (overwriting them leads to very bad
/ things) but the io instructions in asm.s need to write in the caw and
/ csw locations.  Protecting and unprotecting the first 2k would be
/ prohibitively expensive.  Too bad.
/
	. = 2048
/
	using	zero,0
/ these routines resides in low core, and therefore need no base registers
exttrap:
        mvc     runpsw(8),extopsw
        st      r15,temp15
        la      r15,EXT
        b       ctrap
svctrap:
        mvc     runpsw(8),svcopsw
        st      r15,temp15
        la      r15,SVC
        b       ctrap
pgmtrap:
        mvc     runpsw(8),pgmopsw
        st      r15,temp15
        la      r15,PGM
        b       ctrap
iotrap:
        mvc     runpsw(8),ioopsw
        st      r15,temp15
        la      r15,IO
        b       ctrap
mcktrap:
        mvc     runpsw(8),mckopsw
        st      r15,temp15
        la      r15,MCK
        b       ctrap

/ common trap code
ctrap:
        st      sp,ustack       / save user sp
        tm      runpsw+1,probstat       / user or system?
        bz      1f              / system
        l       sp,uptr         / user
        la      sp,usize*pgsize-stkdrop(,sp)
        b       2f
1:      s       sp,=a(stkdrop)
2:      stm     r0,r14,4(sp)    / save gprs
        l       r0,ustack
        st      r0,sp*4+4(,sp)
	st      r15,0(,sp)      / trap type
        l       r0,temp15
        st      r0,r15*4+4(,sp)
        mvc     68(8,sp),runpsw         / save psw
        std     r0,76(,sp)      / save fprs
        std     r2,84(,sp)
        std     r4,92(,sp)
        std     r6,100(,sp)
/ call C routine
        sr      r12,r12         / must be here for fixstak
	l       r15,=v(trap)
        balr    r14,r15
/ restore state and return to interrupted program
        mvc     runpsw(8),68(sp)        / put psw where we can find it
        ni      runpsw+1,nowait         / turn off wait state
        ld      r0,76(,sp)              / restore fprs
        ld      r2,84(,sp)
        ld      r4,92(,sp)
        ld      r6,100(,sp)
        lm      r0,r15,4(sp)            / restore gprs
        lpsw    runpsw                  / fly away home

main:
///     bal     r14,stopit      / pop into cp mode - for debugging
        mvc     184(4),=f'9'    / load up i/o address with 9 for omak
        l       r15,=v(omak)    / gear up for off to debugger
        balr    r14,r15         / off to initialize omak et all.
	l	r2,=v(edata)	/ get bss start addr
	lr      r3,r2           / dup
	s	r3,=v(end)	/ get neg length of bss
	lpr     r3,r3           / absolute value
	sr      r4,r4           / no second op
	sr      r5,r5           / zero to r5
	mvcl    r2,r4           / zero bss segment
	l	r1,=v(end)	/ get addr of kernel end
	la	r1,4095(,r1)	/ round up to
	n	r1,=x'fffff000'	/ page boundary
	st      r1,uptr         / use it as u struct ptr
	lr      r2,r1           / dup u ptr
	l	r3,=f'4096'	/ page length
	sr      r4,r4           / zero second oper
	sr      r5,r5           / zero second length
	mvcl    r2,r4           / fill page with zeroes
	l       r3,=v(proc)     / get &proc[0]
        st      r3,0(,r1)       / stuff in u.u_procp
	lr      r2,r1           / dup u ptr
	a       r2,=f'4096'     / first free address
	l       r3,=v(coretab)  / get coretab addr
	st      r2,0(r3)        / store addr for coretab
	stck    vmai+8
	spt     t_high
	la      r15,INIT
        mvc     runpsw(8),userinit
        b       ctrap           / enter C routine
	ds      0d
userinit:
	dc	x'071d0f00'
	dc	f'0'
t_high:
	dc      x'7fffffffffffffff'

/ see if a given page is addressable
	entry   tryaddr
tryaddr:
	mvc     adpswsav(8),pgmnpsw     / save new pgm psw
	mvc     pgmnpsw(8),trynpsw      / move in new pgm psw
	l       r1,0(sp)                / get addr
	l       r1,0(r1)                / try addressing exception
	mvc     pgmnpsw(8),adpswsav     / restore psw
	la      r0,1                    / return true
	br      r14
addrint:mvc     pgmnpsw(8),adpswsav     / restore psw
	sr      r0,r0                   / return false
	br      r14

/
/ Interrupt window -
/ this routine must reside in page 0 to prevent
/ pseudo-page faults in the kernel
/
	entry   window
window:
	stosm   wmask,x'03'     / save status and enable interrupts
	ssm     wmask           / restore interrupt status
	br      r14

/ Idle - enter wait state
/ This routine must also reside in page zero, for above reason
/
	entry   idle
idle:
	lpsw    wait            / load enabled wait state psw
                                / interrupts occur here
return: ssm     imask           / disable interrupts
        br      r14             / return
imask:  dc      x'00'           / normal interrupt mask
wait:	ds	0d
	dc      x'031e0000'
	dc	a(return)

	entry   stopit
stopit:
	sr      r0,r0
	diag    r0,r0,8 / pop into cp mode
	br      14
ltorg

dc c'@(#)zero.s 1.5>'       / sccs id
/
/ Memory management handles memory in 4K chunks.
/ Since it is desirable to protect the entire text of
/ the kernel (except zero which needs to write into low core)
/ we must ensure that the next routine in the executable file
/ is on the first 4K boundry, plus we must "push up" the
/ data segment to at least one page past the end of the text
/ segment (because the ipl program can't handle normal
/ "text shared" programs).
/
	. = 4092
	ds      f
/
	.data
	ds      1024f
