#include "../h/param.h"
#include "../h/systm.h"
#include "../h/dir.h"
#include "../h/user.h"
#include "../h/proc.h"
#include "../h/conf.h"
#include "../h/tty.h"
#include "../h/370.h"
#include "../h/io.h"

#define ILEN 136
#define OLEN 255

extern  int     conaddr[];

struct {
        ccw_t   iccw;           /* read ccw */
        ccw_t   occw;           /* write ccw */
        char ibuf[ILEN];        /* input buffer */
        char obuf[OLEN];        /* output buffer */
        int     ilen;           /* input count */
        char    *optr;          /* output pointer */
        char    started;        /* busy flag */
        char    reread;         /* retry read flag */
} cons;
 
/*
 * CCW definitions
 */
#define WRITE    0x01
#define WRITEACR 0x09
#define READINQ  0x0a
 
struct tty ctty;
extern char atetab[];
extern char etatab[];
 
#define EBC_NL   0x15     /* ebcdic new line */
#define EBC_BLNK 0x40    /* blank */
#define EBC_CENT 0x4a    /* cent sign */
#define EBC_BKSL 0xe0    /* back slash */
#define EBC_E    0x85     /* 'e' */
#define EBC_I    0x89     /* 'i' */
 
/*
 * Console Initialization - called by system during initialization
 */
coninit()
{
        int constart();
 
        cons.iccw.cc_cmd = READINQ;
        cons.iccw.cc_addr = (int)cons.ibuf;
        cons.iccw.cc_sli = 1;
        cons.iccw.cc_count = ILEN;
	cons.occw.cc_addr = (int)cons.obuf;
        cons.optr = cons.obuf;
        ctty.t_oproc = constart;
}
 
/*
 * Open console
 */
/* ARGSUSED */
conopen(dev, flag)
{
        int conaint();
 
	if((ctty.t_state & ISOPEN) == 0) {
		ctty.t_state = ISOPEN | CARR_ON;
		ctty.t_flags = XTABS | IDBL | ODBL;
		ttychars(&ctty);
		ctty.t_kill = '\0';
		ctty.t_erase = '\0';
	}
	ttyopen(dev, &ctty);
        setax(conaddr[0], conaint, 0);
        cpcmd("TERM MODE VM");
}
 
/*
 * Close console
 */
/* ARGSUSED */
conclose(dev)
{
        ttyclose(&ctty);
        cpcmd("CLOSE CONS");
        cpcmd("TERM MODE CP");
}
 
/*
 * Read from console, after flushing any output.
 * This insures that prompts will be seen, even if
 * not terminated by a new line.
 */
/* ARGSUSED */
conread(dev)
{
        while(ctty.t_outq.c_cc) sleep((caddr_t)&ctty.t_outq, TTOPRI);
        conflush();
        ttread(&ctty);
}
 
/*
 * User write to console
 */
/* ARGSUSED */
conwrite(dev)
{
        ttwrite(&ctty);
}
 
char	*msgbufp = msgbuf;	/* Next saved printf character */
/*
 * System write to console
 * The last MSGBUFS characters are saved in msgbuf.
 */
putchar(c)
char c;
{
	*msgbufp++ = c;
	if(msgbufp >= &msgbuf[MSGBUFS])
		msgbufp = msgbuf;
        ttyoutput(c, &ctty);
        constart();
}

/*
 * Drain console output buffer.
 * Used by system before going down.
 */
condrain()
{
	while(ctty.t_outq.c_cc) {
		idle();
		constart();
	}
}

/*
 * Console ioctl
 */
/* ARGSUSED */
conioctl(dev, cmd, argp, flag)
dev_t dev;
caddr_t argp;
{
	if(!ttioccomm(cmd, &ctty, argp, dev))
		u.u_error = ENOTTY;
}
 
/*
 * Start output to console
 */
constart()
{
        int c;
 
        c = -1;
        while(!cons.started && ctty.t_outq.c_cc > 0) {
                c = getc(&ctty.t_outq);
                c = atetab[c];
                if(c) *cons.optr++ = c;
                if(c == EBC_NL || (cons.optr >= cons.obuf+OLEN))
                        conflush();
        }
        if(c != -1) wakeup((caddr_t)&ctty.t_outq);
}
 
/*
 * Flush all or part of a line to the console
 */
conflush()
{
        int n, conwint();
 
        if(cons.optr <= cons.obuf)
                return;
        if(cons.optr[-1] == EBC_NL) {
                /* full line */
                cons.occw.cc_cmd = WRITEACR;
                n = cons.optr - cons.obuf - 1;
                if(n == 0) {
                        /* null line - write single blank */
                        cons.obuf[0] = EBC_BLNK;
                        n = 1;
                }
        } else {
                /* part line */
                cons.occw.cc_cmd = WRITE;
                n = cons.optr - cons.obuf;
        }
	cons.occw.cc_count = n;
        cons.started = 1;
        cons.optr = cons.obuf;
        sio(conaddr[0], &cons.occw, conwint, 0);
}
 
/*
 * Console write interrupt
 */
/* ARGSUSED */
conwint(arg, csw, sense)
int arg;
csw_t *csw;
char *sense;
{
        if(csw->cs_de) {
                cons.started = 0;
                if(ctty.t_outq.c_cc)
                        constart();
        }
}
 
/*
 * Console attention interrupt
 */
/* ARGSUSED */
conaint(arg, csw, sense)
int arg;
csw_t *csw;
char *sense;
{
        if(csw->cs_attn)
                constrd();
}
 
/*
 * Start reading from the console
 */
constrd()
{
        int conrint();
 
        sio(conaddr[0], &cons.iccw, conrint, 0);
}
 
/*
 * Console read interrupt
 */
/* ARGSUSED */
conrint(arg, csw, sense)
int arg;
csw_t *csw;
char *sense;
{
        char *cp;
 
        if(csw->cs_ue)     /* cancel */
                cons.reread = 1;
        if(csw->cs_ce)
                cons.ilen = ILEN - csw->cs_count;
        if(csw->cs_de) {
                if(cons.reread) {
                        cons.reread = 0;
                        constrd();
                        return;
                }
                cp = cons.ibuf;
                if(*cp == EBC_CENT || *cp == EBC_BKSL) switch(*++cp) {
                case EBC_CENT: case EBC_BKSL:
                        cons.ilen--;
                        break;
 
                case EBC_E:
                        ttyinput(CEOT, &ctty);
                        return;
 
                case EBC_I:
                        ttyinput(CINTR, &ctty);
                        return;
 
                default:
                        cp--;
                }
                while(cons.ilen--)
                        ttyinput(etatab[*cp++], &ctty);
                ttyinput('\n', &ctty);
        }
}
