#include "../h/conf.h"
#include "../h/param.h"
#include "../h/systm.h"
#include "../h/buf.h"
#include "../h/dir.h"
#include "../h/user.h"
#include "../h/io.h"
#include "../h/tag.h"
 
/*
 * Virtual or real reader driver
 */
#define MAXCR   1
#define BUFFSIZE 156
struct cr {            /* must be double word aligned */
        ccw_t   cr_ccw;         /* read ccw */
        int     cr_count;       /* buffer count */
        char    *cr_bufp;       /* buffer pointer */
        char    cr_buf[BUFFSIZE];     /* buffer */
        int     cr_state;       /* reader state */
        int     cr_addr;        /* reader address */
} readers[MAXCR];
 
/* States */
#define FREE    0
#define OPEN    1
#define DONE    2
#define EMPTY   3
 
#define RDPRI   PUSER
#define READ    0x02
extern char etatab[];
 
/*
 * Open reader
 */
/* ARGSUSED */
cropen(dev, flag)
{
        struct cr *cr;
        int craint(), crintr();
 
        if(minor(dev) >= MAXCR) {
                u.u_error = ENXIO;
                return;
        }
        cr = &readers[minor(dev)];
        if(cr->cr_state != FREE) {
                u.u_error = EBUSY;
                return;
        }
        cr->cr_state = DONE;
        cr->cr_count = 0;
        cr->cr_addr = cdevsw[major(dev)].d_addrs[minor(dev)];
        cr->cr_ccw.cc_cmd = READ;
        cr->cr_ccw.cc_addr = (int)cr->cr_buf;
        cr->cr_ccw.cc_sli = 1;
        cr->cr_ccw.cc_count = BUFFSIZE;
	cpcmd("SP RDR CL *");   /* prevents tag reading from getting out of synch */
        setax(cr->cr_addr, craint, (int)cr);
}
 
/*
 * Close reader
 */
crclose(dev)
{
        struct cr *cr;

        cr = &readers[minor(dev)];
        if(cr->cr_state == OPEN)
		while(cr->cr_state != DONE)
                        sleep((caddr_t)cr, RDPRI);
        cr->cr_state = FREE;
        cpclose(cr->cr_addr);
}
 
/*
 * Reader Read
 */
crread(dev)
{
        struct cr *cr;
        int crintr();
 
        cr = &readers[minor(dev)];
        if(cr->cr_state == DONE && cr->cr_count == 0) {
                cr->cr_state = OPEN;
                sio(cr->cr_addr, &cr->cr_ccw, crintr, (int)cr);
        }
        while(cr->cr_state != DONE)
                sleep((caddr_t)cr, RDPRI);
        if(cr->cr_count < 0) {
                cr->cr_count = 0;
                return;
        }
        while(cr->cr_count > 0) {
                if(passc(*cr->cr_bufp)) return;
                cr->cr_bufp++;
                cr->cr_count--;
        }
        cr->cr_state = OPEN;
        sio(cr->cr_addr, &cr->cr_ccw, crintr, (int)cr);
}
 
/*
 * Card reader interrupt
 */
/* ARGSUSED */
crintr(cr, csw, sense)
struct cr *cr;
csw_t *csw;
char *sense;
{
	if(cr->cr_state == FREE)
		return;
        if(csw->cs_ue) {  /* eof */
                cr->cr_count = -1;
                cr->cr_state = DONE;
                wakeup((caddr_t)cr);
        }
        if(csw->cs_uc) {  /* empty reader */
                cr->cr_state = EMPTY;
                return;
        }
        if(csw->cs_ce)
                cr->cr_count = BUFFSIZE - csw->cs_count;
        if(csw->cs_de) {
                cr->cr_bufp = cr->cr_buf;
                cr->cr_state = DONE;
                wakeup((caddr_t)cr);
        }
}
 
/*
 * Reader asynchronous interrupt
 */
/* ARGSUSED */
craint(cr, csw, sense)
struct cr *cr;
csw_t *csw;
char *sense;
{
        if(csw->cs_de) {
                if(cr->cr_state == EMPTY) {
                        cr->cr_state = OPEN;
                        sio(cr->cr_addr, &cr->cr_ccw, crintr, (int)cr);
                }
                wakeup((caddr_t)craint);
        }
}
 
/*
 * Tag psuedo-driver
 */
tagread(dev)
{
        static struct sfblok t;
        int id, rdraddr;
 
        if(!vm)
                return;
loop:
	id = 0; /* start search for file at beginning */
        while(d_gettag(&t, id) == 0) {
		id = t.sf_fid;  /* next time, start at this one */
		if((t.sf_flag & (SF_UHOLD+SF_SHOLD)) == 0) /* valid file */
			goto found;
	}
        sleep((caddr_t)craint, RDPRI);
	goto loop;

found:
	rdraddr = readers[minor(dev)].cr_addr;
	d_order(id, rdraddr); /* make this file next in line to be read */
        iomove((caddr_t)&t, sizeof t, B_READ);
}
