/*
 * I/O Supervisor tables and definitions.
 */
 
#define NCHANS  16      /* number of channels */
#define SENSEL  24      /* maximum sense bytes */
#define SENSE   0x04    /* sense command code */
 
struct ioq {           /* I/O queue element */
        struct ioq *io_next;    /* must be first */
        int     io_qnum;        /* age */
        int     io_type;        /* SIO, TIO, or HIO */
        int     io_caw;         /* CCW ptr and key */
        int     io_devaddr;     /* physical device address */
        int     (*io_intr)();   /* intr rtn addr */
        int     io_arg;         /* intr rtn arg */
	int     io_mint;        /* missing interrupt time */
};
 
struct unit {          /* unit descriptor */
        ccw_t   un_sccw;        /* sense ccw */
        int     un_state;       /* FREE, WORKING, HUNG, or DEAD */
        struct ioq *un_actv;    /* active I/O request */
        struct ioq *un_q;       /* queue ptr */
        int     (*un_intr)();   /* asynch intr rtn addr */
        int     un_arg;         /* asynch intr rtn arg */
	int     un_mint;        /* missing interrupt time */
        csw_t   un_csw;         /* CSW passed to intr rtn */
        char    un_sense[SENSEL];     /* sense info */
};
 
struct cu {            /* control unit descriptor */
        struct unit *cu_un[16];       /* unit ptrs */
        int     cu_state;       /* FREE or WORKING */
        struct ioq *cu_q;       /* queue ptr */
};
 
struct chan {          /* channel descriptor */
        struct cu *ch_cu[16]; /* control unit ptrs */
        int     ch_type;        /* MX, BMX, or SELECTOR */
        int     ch_state;       /* FREE or WORKING */
        struct ioq *ch_q;       /* queue ptr */
};
 
struct chan *chans[NCHANS];
 
/*
 * Channel types from STIDC instruction.
 */
#define SELECTOR 0
#define MX      1
#define BMX     2
 
/*
 * I/O component states
 */
#define FREE    0       /* nothing happening */
#define WORKING 1       /* I/O in progress */
#define HUNG    2       /* waiting for DE */
#define DEAD    3       /* received CC 3 */
 
/*
 * I/O requests
 */
#define SIO     1
#define TIO     2
#define HIO     3
#define CLR_HDV   4
#define CLR_CLRIO 5

#define MINT 15    /* missing interrupt time unit */

struct ioq *getq(), *iodeq();
