/*
 * Structure to access hardware page tables.
 */
#define PTSIZE  16
#define PTINV   0x8             /* flag for invalid page table entry */
#define PTSHFT  8               /* number of bits to shift addr for pt_entry */
struct  pagetab {
	struct  pagetab *pt_next;
	int     pt_junk;
	short   pt_entry[PTSIZE];
};

#define SEGINV  1               /* flag for invalid segment table entry */
#define PTLEN   0xf0000000      /* page table length indicator */
#define SEGLEN  0x0f000000      /* segment table length indicator */

/* macros to convert page table entry to page address and vice-versa */
#define pte2pa(p) ((caddr_t)(((p) << PTSHFT) & ~(PSIZE-1)))
#define pa2pte(p) ((short)(((int)p) >> PTSHFT))

/*
 * Segment table
 */
union segtab {
	short   *sg_ptab[256];       /* page table pointers */
	int     sg_ctl[256];         /* control info */
	union   segtab  *sg_next;    /* next free segtab */
};
