/*
 * Structure obtained from /dev/tag.
 * This is the same as the SFBLOK dsect in the CP source file "SPOOL COPY"
 */
struct sfblok {
	long    sf_junk1;
	char    sf_owner[8];            /* owner of spool file */
	char    sf_origin[8];           /* origin of spool file */
	int     sf_nrecs;               /* number of records */
	short   sf_recsize;             /* record size */
	short   sf_fid;                 /* spool file id */
	char    sf_flag;                /* see below */
	char    sf_type;                /* ? */
	short   sf_misc1;               /* ? */
	int     sf_recptr;              /* garbage */
	char    sf_name[24];            /* file name and type */
	char    sf_date[8];             /* creation date */
	char    sf_time[8];             /* creation time */
	char    sf_blast;               /* garbage */
	short   sf_copies;              /* number of copies */
	char    sf_class;               /* class */
	char    sf_flag2;               /* funny flags */
	char    sf_dist[8];             /* distribution */
	int     sf_flash;               /* flash code for 3800 */
	char    sf_scopy;               /* re-start copy number */
	char    sf_rsvd[3];             /* reserved */
/* end of SFBLOK, beginning of "first record of file" (tag) */
	char    sf_junk5[12];
	char    sf_tag[136];            /* The Tag */
};

/*
 * Bits in sf_flag
 */
#define SF_INUSE        0x80    /* file being processed */
#define SF_RECOK        0x40    /* ? */
#define SF_UHOLD        0x20    /* in user hold */
#define SF_DUMP         0x10    /* CP system dump */
#define SF_OPEN         0x08    /* input file has been opened */
#define SF_SHOLD        0x04    /* in system hold */
#define SF_EOF          0x02    /* EOF reached */
#define SF_RECERR       0x01    /* ? */
