/*
 * Text structure.
 * One allocated per pure
 * procedure on swap device.
 * Manipulated by text.c
 */
struct text           /* depends on user.h for structs u_pgtb, u_exdata */
{
        struct u_pgtb  x_tseg, x_dseg; /* page table headers */
	struct inode *x_iptr;          /* inode of prototype */
	struct u_header x_exdata;      /* header information */
	int     x_allin;               /* 1 = all readi's done */
	short   x_count;               /* reference count */
	char    x_flag;                /* traced, written flags */
};

extern struct text text[];

#define	XTRC	01		/* Text may be written, exclusive use */
#define	XWRIT	02		/* Text written into, must swap out */
#define	XLOAD	04		/* Currently being read from file */
#define	XLOCK	010		/* Being swapped in or out */
#define	XWANT	020		/* Wanted for swapping */
