#include <stdio.h>

main(argc,argv)
 int argc;
 char **argv;
{
 /* The invocation of Omak, the Au kernel debugger.           *
  *                                                           *
  *    the command syntax   "omak addr"                       *
  *                                                           *
  *       addr is the device address for omak to do i/o to    *
  *                                                           *
  *   NOTE: better not miss with the address, kernel will     *
  *         tumbling down..........                           *
  *                                                           *
  * This is the command that the Au developer will issue      *
  * when Omak is to be given control of the kernel for        *
  * debugging purposes.                                       *
  *                                                           *
  * The function of this code is to get the terminal address  *
  * of the invoking terminal and pass it to the Omak system   *
  * call.                                                     *
  *                                                           */

  int file;
  if (argc < 2) {
                  printf("need a real i/o device address \n");
                  exit(4);
                }
  argv++; /* get to the device address */
  sscanf(*argv,"%x",&file);

  /*  pass the device address to omak after                  *
   *   checking the address for legality.                    */

  if (file != 0x009 && (file < 0x400 || file > 0x40f) )
                   {
                   printf("not a legal address, need 9 or 400-40f\n");
                   exit(4);
                   }
  omak(file);

}
