         entry omak
omak:
         using   omakb,10             / use 10 as the base register
         st      r10,16               / save a copy of r10 in low core
         balr    r10,r0               / give r10 the address where we are
omakb:   stm     r0,r15,gprsa         / save gprs
         mvc     gprsa+40(4),16       / save r10
         stctl   r0,r15,cregs         / save au's control regs
         stpt    cputim               / save au's cpu timer
/
/ set up the breakpoint handling stuff, point the svc new psw at omakbp.
/
         la      r6,omakbp             / this will be the svc new psw
         l       r7,100                / get current svc new addr handler
         cr      r6,r7                 / is it omak's svc addr in there?
         bc      8,bypass              / yes, no need to save au's
         mvc     AUSVCN(8),96          / put au's svc new psw at 160
         st      r6,aptsvcn+4          / store addr into the svc new psw
         mvc     96(8),aptsvcn         / move in the svc new psw
/
         la      r13,stack            / give r13 a stack pointer
         a       r13,=f'2048'         / bump the stack a bit.
/        a       r13,=f'4096'         / bump the stack a bit.
                                      / set up parms for passage to comak
/
/ this next bunch of stuff will set up the stack for comak
/
         sr      r6,r6                / zero into r6
/        a       r6,=f'576'           / add a 240, device addr, for now
         l       r6,184               / get the i/o address to r6
         st      r6,0(r13)            / store the i/o address on the stack
         la      r6,gprsa             / get address of au gpr's
         st      r6,4(r13)            / ptr to the gpr's, to the stack
         la      r6,aupsw             / get addr of au's current psw
         st      r6,8(r13)            / ptr to au's psw, stack time
         la      r6,cregs             / get addr of au's control regs
         st      r6,12(r13)           / put control reg addr on stack
         l       r6,=a(edata)         / get addr of symbol table
         st      r6,16(r13)           / put sym table addr on stack
         stcm    r14,7,aupsw +5       / move in the branch from addr for
                                      /  au's initial psw
/
         l       r15,=a(comak)        / load up 15 with address of comak
/
/ call up the comak routine
/
         balr    r14,r15
/
/ omak's C program return's here.
/
/ this will be executed when the user enters the ;quit command.
/
         spt     cputim                / reset cpu timer to Au's
         tm      junk,x'00'            / set condition to 0, all is well??
         lctl    r0,r15,cregs          / load Au's control regs
         lm      r0,r15,gprsa          / restore gprs
         br      r14                   / fly away home, back from whence
                                       /   we came, aaahh, to Au
bypass:
         l       r2,=f'2'              / length of svc instr
         l       r3,36                 / get svc old addr
         ar      r2,r3                 / add 2 to the svc old address
         mvc     aupsw (4),32          / get svc old psw for omak, 4 bytes
         st      r2,aupsw +4           / put rest of psw in for omak
         lm      r0,r15,omgprs         / load up omak's registers
         br      r14                   / head on back, sort of from onward
/
/ need the routine to give control back to Au, after cont or go
/ command has been executed. save the gprs and such so that we can
/ restore the correct state upon return to omak after a break point.
/
it = .
         drop    r10
         entry   onward
onward:
         using   onward,r15
         stm     r0,r15,omgprs        / save omak's registers, from ;cont
         stctl   r0,r1,omcregs        / save omak's control regs 0, 1
         stctl   r14,r14,omcregs+8    / save oamk's control reg 14
/
/ do whatever needs to be done to get Au off the ground, ha ha
/
         l       r1,=a(stsion)         / do we need to do a sio for Au?
         l       r1,0(,r1)             / get the flag into r1
         sr      r2,r2
         cr      r1,r2                 / is the sio Au flag set?
         be      goau                  / flag not set.
/
         l       r8,=a(auaddr)         / load up device address
         l       r8,0(r8)              / get the address
         sr      r1,r1
         la      r1,576(,r1)
         cr      r1,r8
         bne     fullio
/ send a console sio
         l       r7,=a(consio)
	 stcm    r7,7,conccw+1         / need to write something
         la      r1,conccw             / set up for sio
         st      r1,72                 / store into caw
         b       dosio
/ send a full screen sio
fullio:  l       r7,=a(readbuf)        / where we reading the buffer to?
	 stcm    r7,7,rdccw+1          / need a response area
         la      r1,rdccw              / set up for sio
         st      r1,72                 / store into caw
dosio:   sio     0(r8)                 / to the sio for Au
         sr      r1,r1                 / need to reset the stsion flag
         l       r2,=a(stsion)         / get addr of stsion
         st      r1,0(,r2)             / all reset boss.
goau:    spt     cputim                / reset cpu timer to Au's
         mvc     AUPSW(8),aupsw        / move in Au's psw for use
         mvc     SVCCODE(2),ausvc      / move in Au's svc code
         lctl    r0,r15,cregs          / load Au's control regs
         lm      r0,r15,gprsa          / give Au his registers
         lpsw    AUPSW                 / on to Au, no base here boss
/
/ this is the break point entry routine,
/ the proper thing to do here is to pass omak the address that had
/ the break point
ot = .
         drop    r15
         entry   omakbp
omakbp:
         using   .,r15                 / set up the offsets correctly
         st      r15,16                / store r15 in low core for safety
         l       r15,100               / use the svc new addr for base.
         stm     r0,r14,gprsa          / save Au's registers 0-14
         mvc     gprsa+60(4),16        / save Au's r15, from low core
         stctl   r0,r15,cregs          / save Au's control regs
         stpt    cputim                / save Au's cpu timer
         lh      r2,SVCCODE            / get the svc int code
         ch      r2,omaksvc            / compare with omak's svc code
         bc      8,ontoco              / got a break point, onto comak
         ch      r2,omaksvcf           / compare with omak's front door
         bc      8,frontd              / got the front door, init things
         mvc     ausvc(2),SVCCODE      / get the svc int code for safety
         lctl    r0,r15,cregs          / load Au's control regs
         lm      r0,r15,gprsa          / restore registers, Au's svc
         lpsw    AUSVCN                / get Au's svc new handler addr
                                       / and let us in fact do so
ontoco:
         mvc     aupsw (8),32          / get svc old psw for omak
kludge:
         mvc     SVCCODE(2),ausvc      / move in Au's svc code
         lctl    r0,r1,omcregs         / load omak's control regs 0,1
         lctl    r14,r14,omcregs+8     / load omak's control reg 14
         lm      r0,r15,omgprs         / load up omak's registers
         br      r14                   / head on back, sort of from onward
/
/ omak front door, shell hit us over the head with the 89
/  r0 has the device address to talk to.
/
frontd:
         la      r13,devaddr     / get r13 the dev address
         st      r0,devaddr      / put the dev addr here for use
         lr      r5,r15          / save r15 for a bit
         l       r15,=v(initio)  / on to initio
         balr    r14,r15         / init that io dev address
         lr      r15,r5          / what about restore of r15
         l       r5,36           / get svc old psw
         a       r5,=f'2'        / bump address by 2, svc length
         mvc     aupsw (4),32    / get first 4 bytes of svc old psw
         st      r5,aupsw+4      / put in last 4 bytes of psw
         b       kludge          / on to comak, really think this kludge
                                 /   is going to work?
/

AUPSW    = 16
SVCCODE  = 138
AUSVCN = 160

omaksvc: dc      x'005a'               / svc code 90 for omak's brk points
omaksvcf: dc     x'0059'               / svc code 89 for omak's zipper
ausvc:   ds      1h                    / save area for Au's svc code
junk:    ds      0d
cputim:  ds      2f                    / Au cpu timer save area
junk1:   ds      0d
aupsw :  dc      x'0008000000000000'   / Au's psw save area
aptsvcn: dc      x'0008000000000000'   / breakpoint svc time, new psw
devaddr: ds      1f                    / device address for safe keeping
cregs:   ds      16f                   / control reg save area
omcregs: ds      3f                    / omak's control reg save area
gprsa:   ds      16f                   / general reg save area
omgprs:  ds      16f                   / omak's general reg save area
stack:   ds      512f                  / stack for omak's use, 4k for now
turkey:  ds      6f                    / this is for the first stuff that
                                       / omak puts on his stack.
consio:
         dc      x'4040404082a8854082a885'
conccw:
         ccw     x'09',0,x'00',11
         ccw     x'03',0,x'20',1
readbuf:
         ds      4f
rdccw:
         ccw     x'06',0,x'60',16
         ccw     x'03',0,x'20',1
         end
