#include "../h/param.h"
#include "../h/systm.h"
#include "../h/acct.h"
#include "../h/dir.h"
#include "../h/user.h"
#include "../h/inode.h"
#include "../h/proc.h"

struct inode *acctp;
struct acct acctbuf;

/*
 * Switch accounting files
 */
sysacct()
{
	register struct inode *ip;
	register struct a {
		char	*fname;
	} *uap;

	uap = (struct a *)u.u_ap;
	if (suser()) {
		if (acctp) {
			plock(acctp);
			iput(acctp);
			acctp = NULL;
		}
		if (uap->fname==NULL) {
			return;
		}
		ip = namei(uchar, 0);
		if(ip == NULL)
			return;
		if((ip->i_mode & IFMT) != IFREG) {
			u.u_error = EACCES;
			iput(ip);
			return;
		}
		acctp = ip;
		prele(ip);
	}
}

/*
 * On exit, write a record on the accounting file.
 */
acct()
{
	register i;
	register struct inode *ip;
	off_t siz;

	if ((ip=acctp)==NULL)
		return;
	plock(ip);
	for (i=0; i<sizeof(acctbuf.ac_comm); i++)
		acctbuf.ac_comm[i] = u.u_comm[i];
	acctbuf.ac_utime = u.u_utime >> 12;
	acctbuf.ac_stime = u.u_stime >> 12;
	acctbuf.ac_etime = time - u.u_start;
	acctbuf.ac_btime = u.u_start;
	acctbuf.ac_uid = u.u_ruid;
	acctbuf.ac_gid = u.u_rgid;
	acctbuf.ac_rdwr = u.u_rdwr;
	acctbuf.ac_tty = u.u_ttyd;
	acctbuf.ac_flag = u.u_acflag;
	siz = ip->i_size;
	u.u_offset = siz;
	u.u_base = (caddr_t)&acctbuf;
	u.u_count = sizeof(acctbuf);
	u.u_segflg = 1;
	u.u_error = 0;
	writei(ip);
	if(u.u_error)
		ip->i_size = siz;
	prele(ip);
}

/*
 * Write an arbitrary record to the accounting file
 */
acctwrt()
{
	register struct a {
		caddr_t bufp;
		int len;
	} *ap;
	register struct inode *ip;
	register off_t siz;

	ap = (struct a *)u.u_ap;
	if(suser()) {
                if ((ip=acctp)==NULL)
                        return;
                plock(ip);
                siz = ip->i_size;
                u.u_offset = siz;
                u.u_base = ap->bufp;
                u.u_count = ap->len;
                u.u_segflg = 0;
                u.u_error = 0;
                writei(ip);
                if(u.u_error)
                        ip->i_size = siz;
                prele(ip);
	}
}
