#include "../h/param.h"

/*
 * In case console is off,
 * panicstr contains argument to last
 * call to panic.
 */
char    *panicstr;
 
/*
 * Panic is called on unresolvable
 * fatal errors.
 * It syncs, prints "panic: mesg" and
 * then loops.
 */
panic(s)
char *s;
{
        update();
	ipanic(s);
}
ipanic(s)
char *s;
{
        static char panbuf[100];
	char *sprintf();

        panicstr = s;
        sprintf(panbuf, "M * panic: %s\n", s);
        printf(panbuf+4);
	condrain();
        cpcmd(panbuf);

	memdump();

	condrain();
	cpcmd("SYSTEM RESET");
	for(;;) idle();
}
 
/*
 * prdev prints a warning message of the
 * form "mesg on dev x/y".
 * x and y are the major and minor parts of
 * the device argument.
 */
prdev(str, dev)
char *str;
dev_t dev;
{
        printf("%s on dev %d/%d\n", str, major(dev), minor(dev));
}
 
/*
 * Scaled down version of C library printf and sprintf.
 * (No floating point)
 */
#define CHARSIZE 4
#define INTSIZE  4
#define SIGN     2147483648            /* 2 to the 31  */
#define BUFFSIZE 256
#define OCTSIGN  11
#define HEXSIGN  8
#define OCTMASK  2
#define HEXMASK  8
 
 
#define OBFSIZE  128
static char _outbuf[OBFSIZE];
static char *_obufp,*_str;
static int (*_putch)();
 
/*
 * formatted print in C
 */
 
/*VARARGS1*/
printf(fmt,args)
char *fmt;
{
        int putchar();

        _putch = putchar;
        _putf(fmt,(caddr_t)&args);
}
 
/*VARARGS2*/
char *sprintf(str,fmt,args)
char *str;
char *fmt;
{
        int _putsb();

        _putch = _putsb;
        _str = str;
        _putf(fmt,(caddr_t)&args);
        *_str = '\0';
        return(str);
}
 
static _putf(fmt,ap)
char *fmt;
caddr_t ap;
{
        char *cap,*p,*q,buff[BUFFSIZE],*cap2;
        char c,blank,*b;
        int *iap,i,s,t,shift;
        int leftf,width,prec,blankc;

        _obufp = _outbuf;
        while (c = *fmt++){
                leftf = 0; width = 0; prec = 0;
                if (c != '%'){
                        (*_putch)(c);
                        continue;
                        }
                c = *fmt++;
                if (c == '-'){
                        leftf = -1;
                        c = *fmt++;
                        }
                while (c <= '9' && c >= '0'){
                        width = 10*width+(c-'0');
                        c = *fmt++;
                        }
                if (c == '.'){
                        c = *fmt++;
                        while (c <= '9' && c >= '0'){
                                prec = 10*prec+(c-'0');
                                c = *fmt++;
                                }
                        }
                p = buff; q = buff;
                blank = ' ';
                cap = ap+3;
                iap = (int *)ap;
                switch(c){
                        case 'r':
                                iap = (int *)*iap;
                                fmt = (char *)*iap++;
                                ap = (caddr_t)iap;
                                continue;
                        case 'u':
                        case 'd':
                        case 'D':
                                ap += INTSIZE;
				i = *iap;
                                while (s = i/10){
                                        t = i-s*10;
					if(t < 0) t = -t;
                                        if (t >= 10) *p++ = t-10+'A';
                                        else *p++ = t+'0';
                                        i = s;
                                        }
				if(i < 0) i = -i;
                                if (i >= 10) *p++ = i-10+'A';
                                else *p++ = i+'0';
                                if (*iap < 0) *p++ = '-';
                                break;
                        case 'o':
                        case 'O':
                                shift = 3;
                        case 'x':
                        case 'X':
                                if (c == 'x' || c == 'X'){
                                        if (!leftf) blank = '0';
                                        shift = 4;
                                        }
                                i = *iap;
                                ap += INTSIZE;
                                while (s = (i >> shift)){
                                        t = i-(s << shift);
                                        if (t >= 10) *p++ = t-10+'A';
                                        else *p++ = t+'0';
                                        i = s;
                                        }
                                if (i >= 10) *p++ = i-10+'A';
                                else *p++ = i+'0';
                                if (shift == 3 && *(p-1) != '0') *p++ = '0';
                                break;
                        case 'c':
                                leftf = 1;
                                *p++ = *cap;
                                ap = ap+CHARSIZE;
                                break;
                        case 's':
                                leftf = 1;
                                cap = (char *)*iap;
                                p = q = buff+BUFFSIZE;
                                if (prec) cap2 = cap+prec;
                                else cap2 = cap+BUFFSIZE;
                                while (*cap && (cap < cap2))
                                        *--q = *cap++;
                                ap = ap+INTSIZE;
                                break;
                        default:
                                (*_putch)(c);
                                continue;
                        }
                blankc = width-(p-q);
                if (!leftf)
                        for (i = 0; i < blankc; i++) (*_putch)(blank);
                for (b = p-1; b >= q; b--) (*_putch)(*b);
                if (leftf)
                        for (i = 0; i < blankc; i++) (*_putch)(blank);
                }
        }
 
_putsb(c)
char c;
{
        *_str++ = c;
}
