/*
*  This is a modification of e1print.c, used by e1opr, written
*  by Don Walters.  Modifications were made by Diane Warner.
*  This routine formats a file so it can be sent to MVS without
*  loosing long records.  Output records are formated as follows:
*
*  -------------------------------------------------------------------
*  | 6 char line# | 2 char seq# | 72 bytes of data                   |
*  -------------------------------------------------------------------
*
*  This is called by the com command to reformat the input files.
*  Further modifications have been made to treat a title file differently
*  so that carriage control characters are not inserted in the title info.
*/

#include <stdio.h>
int lineno, lno, ulflag;
int mlen;
int nextcc ' ';
int cflg;
int lflag;
int tflag;
char ul[BUFSIZ];
char line[BUFSIZ];
FILE *file,*tfile,*fopen();
main(argc, argv) char **argv;
{
	char *ap;
	int i;
	tflag = 0;
	lflag = 0;

	/* this is to debug the link between com, send, and reform */
	setbuf(stderr,NULL);

	argv++;
        while(--argc > 0 && *argv[0]=='-') {
                ap = *argv + 1;
                switch(*ap) {
			/*
			 * c - put form feed carriage control after every 60 lines
			 * Here, set the flag.
			 * This flag is not used by com.
			 */
                        case 'c':
                                cflg++;
                                break;
			/*
			 * l - maximum number of bytes per record
			 * is the next arg given
			 */
			case 'l':
				argv++;
				argc--;
				mlen = atoi(*argv);
				lflag++;
				break;
			/*
			 * t - title file is specified.
			 * open file and set flag
			 */
			case 't':
				argv++;
				argc--;
				if ((tfile = fopen(*argv,"r")) == NULL) {
					fprintf(stderr,"reform:");
					fprintf(stderr,"Cannot open title file %s \n",*argv);
				}
				else tflag++;
				break;
                        default:
                                fprintf(stderr,"Invalid flag given.\n");
                                exit(1);
				break;
                }
		argv++;
        }
	/*
	 * process the title file
	 */
	if (tflag)
		tprocess(tfile);

	/*
	 * set default length if none is specified
	 */
	if (!lflag)
		mlen = 80;

	/*
	 * process the standard input
	 */
	if (argc <= 0)
		process(stdin);

	/*
	 * determine, open and process input files
	 */
	else {
		argv--;
		do {
			argv++;
			if (strcmp(*argv, "-")==0)
				file = stdin;
			else
				if ((file=fopen(*argv, "r")) == NULL) {
					fprintf(stderr,"reform: ");
					fprintf(stderr,"Cannot open input file %s\n",
					        *argv);
					continue;
				}
			process(file);
		        fclose(file);
		} while(--argc);
	}
}

/*
 * This subroutine processes the title file.
 * Lines are read in and put in the record format shown above.
 * This is actually a subset of the 'process' subroutine;
 * it is a separate function because the carriage control characters
 * inserted by 'process' are not desired in the title information.
 */
tprocess(tfile)
FILE *tfile;
{
	char card[81],*s;
	int reclen,bleft;

	lineno = 0;
	while((bleft = tline(line,tfile)) > 0){
		bleft--;
		s = line;
		lineno++;
		while(bleft >= 0){
			reclen = bleft;
			if (reclen > 72) reclen = 72;
			sprintf(card,"%6d%2d",lineno,reclen);
			if (reclen > 0) move (s,card+8,reclen);
			card[reclen+8] = 0;
			puts(card);
			s =+ 72;
			bleft =- 72;
		}
	}
}

/*
 * This function gets the next line of the title file and returns its
 * length.  No modifications are made to the line.
 */
tline(line,tfile)
char *line;
FILE *tfile;
{
	register c;
	register char *l;
	int len;

	l = line;
	len = 0;
	while((c = getc(tfile)) != EOF && c != '\n'){
		len++;
		if (len > BUFSIZ - 1){
			fprintf(stderr,"reform:");
			fprintf(stderr,"max line length exceeded.\n");
			exit(1);
		}
		*l++ = c;
	}
	if (len == 0)
		return(-1);
	*l = '\0';
	return(++len);
}

/*
 * This subroutine processes an input file.  Each line of the file
 * is read and put into the record format shown above.  Carriage control
 * characters are inserted for overprinting and, if specified, for
 * form feeds every 60 lines.
 */
process(file)
FILE *file;
{
	int reclen, bleft, thiscc;
        char card[81], *s;

	lno = 0;
	while((bleft = getline(line, file)) > 0) {
		bleft--;
                s = line;
	        lineno++;
		thiscc = *s;
putline:        while (bleft>=0) {
			reclen = bleft;
                        if (reclen > 72) reclen=72;
                        sprintf(card, "%6d%2d", lineno, reclen);
                        if (reclen>0) move(s, card+8, reclen);
                        card[reclen+8] = 0;
                        puts(card);
                        s =+ 72;
                        bleft =- 72;
		}
		if (ulflag) {
			bleft = strlen(ul) - 1;
			s = ul;
			lineno++;
			ulflag = 0;
			goto putline;
		}
		if (cflg) switch(thiscc) {
			case ' ':
			case '+':
				if (nextcc != '+') /* then */
				if (++lno >= 60) {
					nextcc = '1';
					lno = 0;
				}
				break;
			case '1':
				lno = 1;
				break;
		}
	}
	nextcc = '1';
}

/*
*  Get the next line, expanding all leading tab characters to an
*  appropriate number of blanks.  Return the length.
*  If underline characters are found, fill 'ul' and set ulflag.
*/
getline(line, file)
char *line;
FILE *file;
{
        register c;
        register char *l, *u;
        int len, i, mode;

        l = line;
        u = ul;
        len  = 0;
        mode = 1;
	*l++ = nextcc;
        *u++ = '+';
	nextcc = ' ';
        while ((c=getc(file)) != EOF) {
                len++;
                if (len > BUFSIZ-1) {
			fprintf(stderr,"reform:");
                        fprintf(stderr, "Max line length exceeded.\n");
                        exit(1);
                }
                if (mode == 1)
                        if (c == '"') mode = 0;
                else
			if (c == '"') mode = 1;
                if (c == '\t' && mode) {
                        i = len + (8-(len-1)%8) - 1;
                        while (len < i) {
                                len++;
                                *l++ = ' ';
                                *u++ = ' ';
                        }
                        *l++ = ' ';
                        *u++ = ' ';
                }
                else {
			switch(c) {
			   /*   case '[':
					*l++ = '(';
					*l++ = '|';
					*u++ = ' ';
					*u++ = ' ';
					len++;
					break;
				case ']':
					*l++ = '|';
					*l++ = ')';
					*u++ = ' ';
					*u++ = ' ';
					len++;
					break;
                           */
				case '{':
					*l++ = '(';
					*l++ = '<';
					*u++ = ' ';
					*u++ = ' ';
					len++;
					break;
				case '}':
					*l++ = '>';
					*l++ = ')';
					*u++ = ' ';
					*u++ = ' ';
					len++;
					break;
				case '^':
					*l++ = '*';
					*l++ = '~';
					*u++ = ' ';
					*u++ = ' ';
					len++;
					break;
				case '\\':
					*l++ = '*';
					*u++ = ' ';
					break;
				case '\b':
					*(u-1) = getc(file);
					ulflag++;
					len--;
					goto nextchar;
				default:
	                                *l++ = c;
					*u++ = ' ';
					break;
			}
                        if (c == '\n') break;
			if (c == '\f') {
				nextcc = '1';
				break;
			}
			if (c == '\r') {
				nextcc = '+';
				break;
			}
nextchar:       ;
                }
        }
        if (len == 0)
                return(-1); /* hit end of file */
        *u = '\0';
	if (len > mlen) {
		fprintf(stderr,"reform:");
		fprintf(stderr,"Line %d longer than %d bytes -- truncated.\n",lineno+1,mlen);
		line[ mlen] = '\0';
		return(mlen + 1);
	}
        *l = '\0';
        return(++len);
}
