/*------------ source/s4/util/xopen.c --------*/
/* char Sccsid [] "@(#)xopen 1.1"; */
/*
        Interface to open(II) which differentiates among the various
        open errors.
        Returns file descriptor on success,
        fatal() on failure.
*/
 
# include <errno.h>
 
xopen(name,mode)
char name[];
int mode;
{
        register int fd;
        extern int errno;
        extern char Error[];
 
        if ((fd = open(name,mode)) < 0) {
                if(errno == EACCES) {
                        if(mode == 0)
                                sprintf(Error,"`%s' unreadable (help sys.5)",name);
                        else if(mode == 1)
                                sprintf(Error,"`%s' unwritable (help sys.6)",name);
                        else
                                sprintf(Error,
                                 "r%s' unreadable or unwritable (help sys.7)",
                                 name);
                        fd = fatal(Error);
                }
                else
                        fd = xmsg(name,"xopen");
        }
        return(fd);
}
